/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.mapper;

import dev.robocode.tankroyale.botapi.BotException;
import dev.robocode.tankroyale.botapi.BulletState;
import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitWallEvent;
import dev.robocode.tankroyale.botapi.events.DeathEvent;
import dev.robocode.tankroyale.botapi.events.HitBotEvent;
import dev.robocode.tankroyale.botapi.events.HitByBulletEvent;
import dev.robocode.tankroyale.botapi.events.HitWallEvent;
import dev.robocode.tankroyale.botapi.events.ScannedBotEvent;
import dev.robocode.tankroyale.botapi.events.SkippedTurnEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.mapper.BotStateMapper;
import dev.robocode.tankroyale.botapi.mapper.BulletStateMapper;
import dev.robocode.tankroyale.schema.BotDeathEvent;
import dev.robocode.tankroyale.schema.BotHitBotEvent;
import dev.robocode.tankroyale.schema.BotHitWallEvent;
import dev.robocode.tankroyale.schema.BulletFiredEvent;
import dev.robocode.tankroyale.schema.BulletHitBotEvent;
import dev.robocode.tankroyale.schema.BulletHitBulletEvent;
import dev.robocode.tankroyale.schema.Event;
import dev.robocode.tankroyale.schema.TickEventForBot;
import dev.robocode.tankroyale.schema.WonRoundEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class EventMapper {
    public static TickEvent map(TickEventForBot source, int myBotId) {
        return new TickEvent(source.getTurnNumber(), source.getRoundNumber(), source.getEnemyCount(), BotStateMapper.map(source.getBotState()), BulletStateMapper.map(source.getBulletStates()), EventMapper.map(source.getEvents(), myBotId));
    }

    private static Set<BotEvent> map(Collection<Event> source, int myBotId) {
        HashSet<BotEvent> gameBotEvents = new HashSet<BotEvent>();
        source.forEach(event -> gameBotEvents.add(EventMapper.map(event, myBotId)));
        return gameBotEvents;
    }

    public static BotEvent map(Event source, int myBotId) {
        if (source instanceof BotDeathEvent) {
            return EventMapper.map((BotDeathEvent)source, myBotId);
        }
        if (source instanceof BotHitBotEvent) {
            return EventMapper.map((BotHitBotEvent)source);
        }
        if (source instanceof BotHitWallEvent) {
            return EventMapper.map((BotHitWallEvent)source);
        }
        if (source instanceof BulletFiredEvent) {
            return EventMapper.map((BulletFiredEvent)source);
        }
        if (source instanceof BulletHitBotEvent) {
            return EventMapper.map((BulletHitBotEvent)source, myBotId);
        }
        if (source instanceof BulletHitBulletEvent) {
            return EventMapper.map((BulletHitBulletEvent)source);
        }
        if (source instanceof dev.robocode.tankroyale.schema.BulletHitWallEvent) {
            return EventMapper.map((dev.robocode.tankroyale.schema.BulletHitWallEvent)source);
        }
        if (source instanceof dev.robocode.tankroyale.schema.ScannedBotEvent) {
            return EventMapper.map((dev.robocode.tankroyale.schema.ScannedBotEvent)source);
        }
        if (source instanceof dev.robocode.tankroyale.schema.SkippedTurnEvent) {
            return EventMapper.map((dev.robocode.tankroyale.schema.SkippedTurnEvent)source);
        }
        if (source instanceof WonRoundEvent) {
            return EventMapper.map((WonRoundEvent)source);
        }
        throw new BotException("No mapping exists for event type: " + source.getClass().getSimpleName());
    }

    private static BotEvent map(BotDeathEvent source, int myBotId) {
        if (source.getVictimId() == myBotId) {
            return new DeathEvent(source.getTurnNumber());
        }
        return new dev.robocode.tankroyale.botapi.events.BotDeathEvent(source.getTurnNumber(), source.getVictimId());
    }

    private static HitBotEvent map(BotHitBotEvent source) {
        return new HitBotEvent(source.getTurnNumber(), source.getVictimId(), source.getEnergy(), source.getX(), source.getY(), source.getRammed());
    }

    private static HitWallEvent map(BotHitWallEvent source) {
        return new HitWallEvent(source.getTurnNumber());
    }

    private static dev.robocode.tankroyale.botapi.events.BulletFiredEvent map(BulletFiredEvent source) {
        return new dev.robocode.tankroyale.botapi.events.BulletFiredEvent(source.getTurnNumber(), BulletStateMapper.map(source.getBullet()));
    }

    private static BotEvent map(BulletHitBotEvent source, int myBotId) {
        BulletState bullet = BulletStateMapper.map(source.getBullet());
        if (source.getVictimId() == myBotId) {
            return new HitByBulletEvent(source.getTurnNumber(), bullet, source.getDamage(), source.getEnergy());
        }
        return new dev.robocode.tankroyale.botapi.events.BulletHitBotEvent(source.getTurnNumber(), source.getVictimId(), bullet, source.getDamage(), source.getEnergy());
    }

    private static dev.robocode.tankroyale.botapi.events.BulletHitBulletEvent map(BulletHitBulletEvent source) {
        return new dev.robocode.tankroyale.botapi.events.BulletHitBulletEvent(source.getTurnNumber(), BulletStateMapper.map(source.getBullet()), BulletStateMapper.map(source.getHitBullet()));
    }

    private static BulletHitWallEvent map(dev.robocode.tankroyale.schema.BulletHitWallEvent source) {
        return new BulletHitWallEvent(source.getTurnNumber(), BulletStateMapper.map(source.getBullet()));
    }

    private static ScannedBotEvent map(dev.robocode.tankroyale.schema.ScannedBotEvent source) {
        return new ScannedBotEvent(source.getTurnNumber(), source.getScannedByBotId(), source.getScannedBotId(), source.getEnergy(), source.getX(), source.getY(), source.getDirection(), source.getSpeed());
    }

    private static SkippedTurnEvent map(dev.robocode.tankroyale.schema.SkippedTurnEvent source) {
        return new SkippedTurnEvent(source.getTurnNumber());
    }

    private static dev.robocode.tankroyale.botapi.events.WonRoundEvent map(WonRoundEvent source) {
        return new dev.robocode.tankroyale.botapi.events.WonRoundEvent(source.getTurnNumber());
    }
}

