/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.schema;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;

public class Message {
    @SerializedName(value="type")
    @Expose
    private Type type;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Message.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Message)) {
            return false;
        }
        Message rhs = (Message)other;
        return this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type);
    }

    public static enum Type {
        BOT_HANDSHAKE("BotHandshake"),
        CONTROLLER_HANDSHAKE("ControllerHandshake"),
        OBSERVER_HANDSHAKE("ObserverHandshake"),
        SERVER_HANDSHAKE("ServerHandshake"),
        BOT_READY("BotReady"),
        BOT_INTENT("BotIntent"),
        BOT_INFO("BotInfo"),
        BOT_LIST_UPDATE("BotListUpdate"),
        GAME_STARTED_EVENT_FOR_BOT("GameStartedEventForBot"),
        GAME_STARTED_EVENT_FOR_OBSERVER("GameStartedEventForObserver"),
        GAME_ENDED_EVENT_FOR_BOT("GameEndedEventForBot"),
        GAME_ENDED_EVENT_FOR_OBSERVER("GameEndedEventForObserver"),
        GAME_ABORTED_EVENT("GameAbortedEvent"),
        GAME_PAUSED_EVENT_FOR_OBSERVER("GamePausedEventForObserver"),
        GAME_RESUMED_EVENT_FOR_OBSERVER("GameResumedEventForObserver"),
        ROUND_STARTED_EVENT("RoundStartedEvent"),
        ROUND_ENDED_EVENT("RoundEndedEvent"),
        CHANGE_TPS("ChangeTps"),
        TPS_CHANGED_EVENT("TpsChangedEvent"),
        BOT_DEATH_EVENT("BotDeathEvent"),
        BOT_HIT_BOT_EVENT("BotHitBotEvent"),
        BOT_HIT_WALL_EVENT("BotHitWallEvent"),
        BULLET_FIRED_EVENT("BulletFiredEvent"),
        BULLET_HIT_BOT_EVENT("BulletHitBotEvent"),
        BULLET_HIT_BULLET_EVENT("BulletHitBulletEvent"),
        BULLET_HIT_WALL_EVENT("BulletHitWallEvent"),
        HIT_BY_BULLET_EVENT("HitByBulletEvent"),
        SCANNED_BOT_EVENT("ScannedBotEvent"),
        SKIPPED_TURN_EVENT("SkippedTurnEvent"),
        TICK_EVENT_FOR_BOT("TickEventForBot"),
        TICK_EVENT_FOR_OBSERVER("TickEventForObserver"),
        WON_ROUND_EVENT("WonRoundEvent"),
        START_GAME("StartGame"),
        STOP_GAME("StopGame"),
        PAUSE_GAME("PauseGame"),
        RESUME_GAME("ResumeGame"),
        NEXT_TURN("NextTurn");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

