/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi;

import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dev.sanda.datafi.EnglishUtils;
import dev.sanda.datafi.annotations.EntityApiSpec;
import dev.sanda.datafi.code_generator.annotated_element_specs.EntityDalSpec;
import dev.sanda.datafi.dto.PageRequest;
import dev.sanda.datafi.persistence.Archivable;
import dev.sanda.datafi.reflection.cached_type_info.CachedEntityTypeInfo;
import dev.sanda.datafi.reflection.runtime_services.ReflectionCache;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;
import org.atteo.evo.inflector.English;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.springframework.aop.framework.Advised;
import org.springframework.data.domain.Sort;

public class DatafiStaticUtils {
    private static final Set<Class<? extends Annotation>> JPA_RELATIONS = new HashSet<Class>(Arrays.asList(OneToOne.class, OneToMany.class, ManyToMany.class, ManyToOne.class));

    public static String toPascalCase(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String toCamelCase(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static String toPlural(String word) {
        return English.plural((String)word);
    }

    public static String toSingular(String word) {
        return EnglishUtils.singularOf(word);
    }

    public static void logCompilationError(ProcessingEnvironment processingEnvironment, Element element, String message) {
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, message + " --> " + element.getSimpleName().toString(), element);
    }

    public static void writeToJavaFile(String entitySimpleName, String packageName, TypeSpec.Builder builder, ProcessingEnvironment processingEnvironment, String templateType) {
        builder.addJavadoc(entitySimpleName + " " + templateType + " generated by dev.sanda @" + LocalDateTime.now(), new Object[0]);
        TypeSpec newClass = builder.build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)newClass).build();
        try {
            javaFile.writeTo((Appendable)System.out);
            javaFile.writeTo(processingEnvironment.getFiler());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<VariableElement> getFieldsOf(TypeElement entity) {
        return entity.getEnclosedElements().stream().filter(e -> e.getKind().isField()).map(e -> (VariableElement)e).collect(Collectors.toList());
    }

    public static List<ExecutableElement> getGettersOf(TypeElement entity) {
        if (entity == null) {
            return new ArrayList<ExecutableElement>();
        }
        return entity.getEnclosedElements().stream().filter(e -> e instanceof ExecutableElement).map(e -> (ExecutableElement)e).filter(e -> e.getSimpleName().toString().startsWith("get")).collect(Collectors.toList());
    }

    public static boolean isCollectionField(Element element, ProcessingEnvironment env) {
        boolean isField = element.getKind().isField();
        if (!isField) {
            return false;
        }
        Types typeUtils = env.getTypeUtils();
        TypeMirror collection = typeUtils.erasure(env.getElementUtils().getTypeElement("java.util.Set").asType());
        return typeUtils.isAssignable(typeUtils.erasure(element.asType()), collection);
    }

    public static void throwEntityNotFoundException(String simpleName, Object id) {
        throw new RuntimeException("Cannot find " + simpleName + " by id: " + id);
    }

    public static <T> List<Object> getIdList(Collection<T> input, ReflectionCache reflectionCache) {
        if (input.isEmpty()) {
            return new ArrayList<Object>();
        }
        Collection deproxifiedInput = input.stream().map(DatafiStaticUtils::deProxify).collect(Collectors.toSet());
        Object firstItem = deproxifiedInput.iterator().next();
        String clazzName = firstItem.getClass().getSimpleName();
        CachedEntityTypeInfo cachedEntityTypeInfo = reflectionCache.getEntitiesCache().get(clazzName);
        ArrayList<Object> ids = new ArrayList<Object>();
        deproxifiedInput.forEach(item -> ids.add(cachedEntityTypeInfo.getId(item)));
        return ids;
    }

    public static <T> org.springframework.data.domain.PageRequest generatePageRequest(PageRequest request, long totalCount) {
        int pageSize;
        int pageNumber;
        if (request.getFetchAll().booleanValue()) {
            pageNumber = 0;
            pageSize = (int)totalCount;
        } else {
            if (!request.isValidPagingRange()) {
                throw new IllegalArgumentException("Invalid paging range");
            }
            pageNumber = request.getPageNumber();
            pageSize = request.getPageSize();
        }
        if (request.getSortBy() != null) {
            return org.springframework.data.domain.PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)request.getSortDirection(), (String[])new String[]{request.getSortBy()}));
        }
        return org.springframework.data.domain.PageRequest.of((int)pageNumber, (int)pageSize);
    }

    public static void validateSortByIfNonNull(Class<?> clazz, String sortByFieldName, ReflectionCache reflectionCache) {
        if (sortByFieldName == null) {
            return;
        }
        CachedEntityTypeInfo entityTypeInfo = reflectionCache.getEntitiesCache().get(clazz.getSimpleName());
        if (!entityTypeInfo.getSortKeys().contains(sortByFieldName)) {
            throw new IllegalArgumentException("Cannot sort by " + sortByFieldName + " as there is no such field in " + clazz.getName());
        }
    }

    public static String firstLowerCaseLetterOf(String str) {
        return str.substring(0, 1).toLowerCase();
    }

    public static ClassName getIdType(TypeElement entity, ProcessingEnvironment processingEnv) {
        for (Element element : entity.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || element.getAnnotation(Id.class) == null && element.getAnnotation(EmbeddedId.class) == null) continue;
            return (ClassName)ClassName.get((TypeMirror)element.asType());
        }
        VariableElement idField = DatafiStaticUtils.getPrimaryKeyJoinColumn(entity);
        if (idField != null) {
            return (ClassName)ClassName.get((TypeMirror)idField.asType());
        }
        processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "No id type found for entity " + entity.getSimpleName().toString(), entity);
        return null;
    }

    private static VariableElement getPrimaryKeyJoinColumn(TypeElement entity) {
        TypeElement superClass = (TypeElement)((DeclaredType)entity.getSuperclass()).asElement();
        if (superClass.getAnnotation(Entity.class) != null || superClass.getAnnotation(Table.class) != null) {
            PrimaryKeyJoinColumn primaryKeyJoinColumnAnnotation = entity.getAnnotation(PrimaryKeyJoinColumn.class);
            String primaryKeyJoinColumnName = primaryKeyJoinColumnAnnotation != null ? primaryKeyJoinColumnAnnotation.referencedColumnName() : superClass.getEnclosedElements().stream().filter(e -> e.getAnnotation(Id.class) != null || e.getAnnotation(EmbeddedId.class) != null).map(idField -> idField.getSimpleName().toString()).findFirst().orElse("id");
            return superClass.getEnclosedElements().stream().filter(elem -> elem.getKind().isField() && elem.getSimpleName().toString().equals(primaryKeyJoinColumnName)).map(idField -> (VariableElement)idField).findFirst().orElse(null);
        }
        return null;
    }

    public static String getBasePackage(RoundEnvironment roundEnvironment) {
        String commonPrefix = StringUtils.getCommonPrefix((String[])DatafiStaticUtils.getRootElementNames(roundEnvironment));
        return commonPrefix.equals("") ? "" : commonPrefix.substring(0, commonPrefix.lastIndexOf("."));
    }

    public static String pascalCasePackageName(String packageName) {
        packageName = packageName.substring(packageName.lastIndexOf(".") + 1);
        packageName = Character.toUpperCase(packageName.charAt(0)) + packageName.substring(1);
        while (packageName.contains("_")) {
            packageName = packageName.replaceFirst("_[a-z]", String.valueOf(Character.toUpperCase(packageName.charAt(packageName.indexOf("_") + 1))));
        }
        return packageName;
    }

    public static String[] getRootElementNames(RoundEnvironment roundEnvironment) {
        return (String[])roundEnvironment.getRootElements().stream().map(el -> el.asType().toString()).toArray(String[]::new);
    }

    public static List<EntityDalSpec> getEntityApiSpecs(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnv) {
        HashSet<Element> entities = new HashSet<Element>();
        entities.addAll(roundEnvironment.getElementsAnnotatedWith(Entity.class));
        entities.addAll(roundEnvironment.getElementsAnnotatedWith(Table.class));
        Map<TypeElement, TypeElement> extensionsMap = roundEnvironment.getElementsAnnotatedWith(EntityApiSpec.class).stream().collect(Collectors.toMap(Function.identity(), typeElement -> (TypeElement)processingEnv.getTypeUtils().asElement(typeElement.getSuperclass()))).entrySet().stream().filter(entry -> ((TypeElement)entry.getValue()).getAnnotation(Table.class) != null || ((TypeElement)entry.getValue()).getAnnotation(Entity.class) != null).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        entities.forEach(entity -> extensionsMap.putIfAbsent((TypeElement)entity, (TypeElement)null));
        HashMap<TypeElement, TypeElement> temp = new HashMap<TypeElement, TypeElement>();
        for (Map.Entry<TypeElement, TypeElement> typeElementTypeElementEntry : extensionsMap.entrySet()) {
            DatafiStaticUtils.extractReferencedEntities(typeElementTypeElementEntry.getKey(), processingEnv).forEach(entityReference -> temp.putIfAbsent((TypeElement)entityReference, (TypeElement)null));
        }
        temp.forEach(extensionsMap::putIfAbsent);
        return extensionsMap.entrySet().stream().map(entry -> new EntityDalSpec((TypeElement)entry.getKey(), (TypeElement)entry.getValue())).collect(Collectors.toList());
    }

    public static Set<TypeElement> extractReferencedEntities(TypeElement entity, ProcessingEnvironment processingEnv) {
        return DatafiStaticUtils.getFieldsOf(entity).stream().filter(DatafiStaticUtils::isEntityReference).map(field -> DatafiStaticUtils.entityReferenceTYpe(field, processingEnv)).collect(Collectors.toSet());
    }

    private static TypeElement entityReferenceTYpe(VariableElement field, ProcessingEnvironment processingEnv) {
        Element fieldType = processingEnv.getTypeUtils().asElement(field.asType());
        if (DatafiStaticUtils.isAnnotatedAs(field, OneToOne.class) || DatafiStaticUtils.isAnnotatedAs(field, ManyToOne.class)) {
            return (TypeElement)fieldType;
        }
        DeclaredType asDeclaredType = (DeclaredType)field.asType();
        return processingEnv.getElementUtils().getTypeElement(asDeclaredType.getTypeArguments().get(0).toString());
    }

    private static boolean isAnnotatedAs(Element element, Class<? extends Annotation> annotationType) {
        return element.getAnnotation(annotationType) != null;
    }

    private static boolean isEntityReference(VariableElement field) {
        return JPA_RELATIONS.stream().anyMatch(jpaAnnotation -> field.getAnnotation(jpaAnnotation) != null);
    }

    public static String camelCaseNameOf(Element element) {
        return DatafiStaticUtils.toCamelCase(element.getSimpleName().toString());
    }

    public static String simpleNameOf(Element element) {
        return element.getSimpleName().toString();
    }

    public static Map<TypeElement, Map<String, TypeName>> getEntitiesFieldsMap(Set<? extends TypeElement> entities) {
        HashMap<TypeElement, Map<String, TypeName>> result = new HashMap<TypeElement, Map<String, TypeName>>();
        for (TypeElement typeElement : entities) {
            HashMap<String, TypeName> entityFieldsMap = new HashMap<String, TypeName>();
            Set fields = typeElement.getEnclosedElements().stream().filter(e -> e.getKind().isField()).collect(Collectors.toSet());
            for (Element field : fields) {
                entityFieldsMap.put(field.getSimpleName().toString(), TypeName.get((TypeMirror)field.asType()));
            }
            result.put(typeElement, entityFieldsMap);
        }
        return result;
    }

    public static Set<? extends TypeElement> getEntitiesSet(RoundEnvironment roundEnvironment) {
        HashSet<Element> entities = new HashSet<Element>();
        entities.addAll(roundEnvironment.getElementsAnnotatedWith(Entity.class));
        entities.addAll(roundEnvironment.getElementsAnnotatedWith(Table.class));
        return Sets.newHashSet(entities);
    }

    public static boolean isDirectlyOrIndirectlyAnnotatedAs(Element element, Class<? extends Annotation> annotationType) {
        boolean isDirectlyAnnotated;
        boolean bl = isDirectlyAnnotated = element.getAnnotation(annotationType) != null;
        if (isDirectlyAnnotated) {
            return true;
        }
        return element.getAnnotationMirrors().stream().anyMatch(am -> am.getAnnotationType().asElement().getAnnotation(annotationType) != null);
    }

    public static Annotation getDirectOrIndirectAnnotation(Element element, Class<? extends Annotation> annotationType) {
        Annotation directAnnotation = element.getAnnotation(annotationType);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        return element.getAnnotationMirrors().stream().filter(am -> am.getAnnotationType().asElement().getAnnotation(annotationType) != null).map(am -> am.getAnnotationType().asElement().getAnnotation(annotationType)).findFirst().orElse(null);
    }

    public static String extractActualName(Object proxyInstance, String classNameKeyWord) {
        int endIndex;
        Class[] interfaces = ((Advised)proxyInstance).getProxiedInterfaces();
        String actualName = "";
        for (Class interface_ : interfaces) {
            if (!interface_.getSimpleName().contains(classNameKeyWord)) continue;
            actualName = interface_.getSimpleName();
            break;
        }
        return (endIndex = actualName.indexOf(classNameKeyWord)) != -1 ? actualName.substring(0, endIndex) : null;
    }

    public static <V> Map<String, V> toServicesMap(List<? extends V> asList, String classNameKeyWord) {
        return asList.stream().collect(Collectors.toMap(item -> DatafiStaticUtils.extractActualName(item, classNameKeyWord), item -> item));
    }

    public static <T> Object getId(T input, ReflectionCache reflectionCache) {
        T instance = DatafiStaticUtils.deProxify(input);
        return reflectionCache.getIdOf(instance.getClass().getSimpleName(), instance);
    }

    public static <T> T deProxify(Object possibleProxy) {
        Object result = possibleProxy;
        if (possibleProxy instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)possibleProxy;
            LazyInitializer initializer = hibernateProxy.getHibernateLazyInitializer();
            result = initializer.getImplementation();
        }
        return (T)result;
    }

    public static boolean isArchivable(TypeElement entity, ProcessingEnvironment processingEnv) {
        return DatafiStaticUtils.implementsInterface(entity, processingEnv.getElementUtils().getTypeElement(Archivable.class.getCanonicalName()).asType(), processingEnv);
    }

    public static boolean implementsInterface(TypeElement myTypeElement, TypeMirror desiredInterface, ProcessingEnvironment processingEnv) {
        return processingEnv.getTypeUtils().isAssignable(myTypeElement.asType(), desiredInterface);
    }

    public static boolean hasOneOfAnnotations(Element element, Class<? extends Annotation> ... annotationTypes) {
        return Arrays.stream(annotationTypes).anyMatch(type -> element.getAnnotation(type) != null);
    }

    public static boolean hasOneOfAnnotations(Class<?> clazz, Class<? extends Annotation> ... annotationTypes) {
        return Arrays.stream(annotationTypes).anyMatch(clazz::isAnnotationPresent);
    }

    public static boolean hasOneOfAnnotations(Field field, Class<? extends Annotation> ... annotationTypes) {
        return Arrays.stream(annotationTypes).anyMatch(field::isAnnotationPresent);
    }

    public static List<String> getModelPackageNames(List<EntityDalSpec> entitySpecs) {
        List qualifiedNames = entitySpecs.stream().map(entityDalSpec -> ((TypeElement)entityDalSpec.getElement()).getQualifiedName().toString()).sorted(String::compareTo).collect(Collectors.toList());
        String commonPrefix = StringUtils.getCommonPrefix((String[])((String[])qualifiedNames.stream().toArray(String[]::new)));
        if (commonPrefix.contains(".")) {
            commonPrefix = commonPrefix.substring(0, commonPrefix.lastIndexOf("."));
        }
        if (!commonPrefix.equals("")) {
            return Collections.singletonList(commonPrefix);
        }
        HashSet<String> currentGrouping = new HashSet<String>();
        HashSet<String> prefixes = new HashSet<String>();
        int qualifiedNamesSize = qualifiedNames.size();
        for (int i = 0; i < qualifiedNamesSize; ++i) {
            String newFinalPrefix;
            String name = (String)qualifiedNames.get(i);
            currentGrouping.add(name);
            String commonGroupPrefix = StringUtils.getCommonPrefix((String[])((String[])currentGrouping.stream().toArray(String[]::new)));
            if (commonGroupPrefix.equals("")) {
                currentGrouping.remove(name);
                --i;
                newFinalPrefix = StringUtils.getCommonPrefix((String[])((String[])currentGrouping.stream().toArray(String[]::new)));
                if (newFinalPrefix.endsWith(".")) {
                    newFinalPrefix = newFinalPrefix.substring(0, newFinalPrefix.lastIndexOf("."));
                }
                prefixes.add(newFinalPrefix);
                currentGrouping = new HashSet();
                continue;
            }
            if (i + 1 < qualifiedNamesSize || currentGrouping.isEmpty()) continue;
            newFinalPrefix = StringUtils.getCommonPrefix((String[])((String[])currentGrouping.stream().toArray(String[]::new)));
            if (newFinalPrefix.endsWith(".")) {
                newFinalPrefix = newFinalPrefix.substring(0, newFinalPrefix.lastIndexOf("."));
            }
            prefixes.add(newFinalPrefix);
        }
        return new ArrayList<String>(prefixes);
    }
}

