/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EnglishUtils {
    private static final Map<String, Object> irregularSingulars = new HashMap<String, Object>(100);
    private static final Map<String, Object> irregularPlurals = new HashMap<String, Object>(100);

    public static boolean isPlural(String word) {
        if (irregularPlurals.containsKey(word = word.toLowerCase())) {
            return true;
        }
        if (word.length() <= 1) {
            return false;
        }
        if (word.charAt(word.length() - 1) != 's') {
            return false;
        }
        if (irregularSingulars.containsKey(word)) {
            return false;
        }
        return word.length() < 2 || word.charAt(word.length() - 2) != 's';
    }

    public static boolean isSingular(String word) {
        if (irregularSingulars.containsKey(word = word.toLowerCase())) {
            return true;
        }
        if (irregularPlurals.containsKey(word)) {
            return false;
        }
        if (word.length() <= 0) {
            return false;
        }
        if (word.charAt(word.length() - 1) != 's') {
            return true;
        }
        return word.length() >= 2 && word.charAt(word.length() - 2) == 's';
    }

    public static String pluralOf(String word) {
        if (EnglishUtils.isPlural(word = word.toLowerCase())) {
            return word;
        }
        Object singularLookup = irregularSingulars.get(word);
        Object plural = null;
        if (singularLookup != null) {
            if (singularLookup instanceof ArrayList) {
                return (String)((ArrayList)singularLookup).get(0);
            }
            return (String)singularLookup;
        }
        int length = word.length();
        if (length <= 1) {
            return word + "'s";
        }
        char lastLetter = word.charAt(length - 1);
        char secondLast = word.charAt(length - 2);
        if ("sxzo".indexOf(lastLetter) >= 0 || lastLetter == 'h' && (secondLast == 's' || secondLast == 'c')) {
            return word + "es";
        }
        if (lastLetter == 'y') {
            if ("aeiou".indexOf(secondLast) >= 0) {
                return word + "s";
            }
            return word.substring(0, length - 1) + "ies";
        }
        return word + "s";
    }

    public static String singularOf(String word) {
        HashSet<Integer> uppercaseIndices = new HashSet<Integer>();
        for (int i = 0; i < word.length(); ++i) {
            if (Character.toUpperCase(word.charAt(i)) != word.charAt(i)) continue;
            uppercaseIndices.add(i);
        }
        if (EnglishUtils.isSingular(word = word.toLowerCase())) {
            return EnglishUtils.applyUppercaseIndices(uppercaseIndices, word);
        }
        Object pluralLookup = irregularPlurals.get(word);
        Object singular = null;
        if (pluralLookup != null) {
            if (pluralLookup instanceof ArrayList) {
                return EnglishUtils.applyUppercaseIndices(uppercaseIndices, (String)((ArrayList)pluralLookup).get(0));
            }
            return EnglishUtils.applyUppercaseIndices(uppercaseIndices, (String)pluralLookup);
        }
        int length = word.length();
        if (length <= 1) {
            return EnglishUtils.applyUppercaseIndices(uppercaseIndices, word);
        }
        char lastLetter = word.charAt(length - 1);
        if (lastLetter != 's') {
            return EnglishUtils.applyUppercaseIndices(uppercaseIndices, word);
        }
        char secondLast = word.charAt(length - 2);
        if (secondLast == '\'') {
            return EnglishUtils.applyUppercaseIndices(uppercaseIndices, word.substring(0, length - 2));
        }
        if (word.equalsIgnoreCase("gas")) {
            return EnglishUtils.applyUppercaseIndices(uppercaseIndices, word);
        }
        if (secondLast != 'e' || length <= 3) {
            return EnglishUtils.applyUppercaseIndices(uppercaseIndices, word.substring(0, length - 1));
        }
        char thirdLast = word.charAt(length - 3);
        if (thirdLast == 'i') {
            return EnglishUtils.applyUppercaseIndices(uppercaseIndices, word.substring(0, length - 3) + "y");
        }
        if (thirdLast == 'x') {
            return EnglishUtils.applyUppercaseIndices(uppercaseIndices, word.substring(0, length - 2));
        }
        if (length <= 4) {
            return EnglishUtils.applyUppercaseIndices(uppercaseIndices, word.substring(0, length - 1));
        }
        char fourthLast = word.charAt(length - 4);
        if (thirdLast == 'h' && (fourthLast == 'c' || fourthLast == 's')) {
            return EnglishUtils.applyUppercaseIndices(uppercaseIndices, word.substring(0, length - 2));
        }
        if (thirdLast == 's' && fourthLast == 's') {
            return EnglishUtils.applyUppercaseIndices(uppercaseIndices, word.substring(0, length - 2));
        }
        return EnglishUtils.applyUppercaseIndices(uppercaseIndices, word.substring(0, length - 1));
    }

    private static String applyUppercaseIndices(Set<Integer> indices, String word) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < word.length(); ++i) {
            if (indices.contains(i)) {
                builder.append(Character.toUpperCase(word.charAt(i)));
                continue;
            }
            builder.append(word.charAt(i));
        }
        return builder.toString();
    }

    static {
        irregularSingulars.put("ache", "aches");
        irregularSingulars.put("alumna", "alumnae");
        irregularSingulars.put("alumnus", "alumni");
        irregularSingulars.put("axis", "axes");
        irregularSingulars.put("bison", "bison");
        ArrayList<String> busses = new ArrayList<String>(2);
        busses.add("buses");
        busses.add("busses");
        irregularSingulars.put("bus", busses);
        irregularSingulars.put("calf", "calves");
        irregularSingulars.put("caribou", "caribou");
        irregularSingulars.put("child", "children");
        irregularSingulars.put("datum", "data");
        irregularSingulars.put("deer", "deer");
        ArrayList<String> dice = new ArrayList<String>(2);
        dice.add("dies");
        dice.add("dice");
        irregularSingulars.put("die", dice);
        irregularSingulars.put("elf", "elves");
        irregularSingulars.put("elk", "elk");
        irregularSingulars.put("fish", "fish");
        irregularSingulars.put("foot", "feet");
        irregularSingulars.put("gentleman", "gentlemen");
        irregularSingulars.put("gentlewoman", "gentlewomen");
        irregularSingulars.put("go", "goes");
        irregularSingulars.put("goose", "geese");
        irregularSingulars.put("grouse", "grouse");
        irregularSingulars.put("half", "halves");
        ArrayList<String> hoof = new ArrayList<String>(2);
        hoof.add("hooves");
        hoof.add("hoofs");
        irregularSingulars.put("hoof", hoof);
        irregularSingulars.put("knife", "knives");
        irregularSingulars.put("leaf", "leaves");
        irregularSingulars.put("life", "lives");
        irregularSingulars.put("louse", "lice");
        irregularSingulars.put("man", "men");
        irregularSingulars.put("money", "monies");
        irregularSingulars.put("moose", "moose");
        irregularSingulars.put("mouse", "mice");
        ArrayList<String> octopus = new ArrayList<String>(3);
        octopus.add("octopodes");
        octopus.add("octopi");
        octopus.add("octopuses");
        irregularSingulars.put("octopus", octopus);
        irregularSingulars.put("ox", "oxen");
        irregularSingulars.put("plus", "pluses");
        irregularSingulars.put("quail", "quail");
        irregularSingulars.put("reindeer", "reindeer");
        ArrayList<String> scarf = new ArrayList<String>(2);
        scarf.add("scarves");
        scarf.add("scarfs");
        irregularSingulars.put("scarf", scarf);
        irregularSingulars.put("self", "selves");
        irregularSingulars.put("sheaf", "sheaves");
        irregularSingulars.put("sheep", "sheep");
        irregularSingulars.put("shelf", "shelves");
        irregularSingulars.put("squid", "squid");
        irregularSingulars.put("thief", "thieves");
        irregularSingulars.put("tooth", "teeth");
        irregularSingulars.put("wharf", "wharves");
        irregularSingulars.put("wife", "wives");
        irregularSingulars.put("wolf", "wolves");
        irregularSingulars.put("woman", "women");
        irregularPlurals.put("aches", "ache");
        irregularPlurals.put("alumnae", "alumna");
        irregularPlurals.put("alumni", "alumnus");
        ArrayList<String> axes = new ArrayList<String>(2);
        axes.add("axe");
        axes.add("axis");
        irregularPlurals.put("axes", axes);
        irregularPlurals.put("bison", "bison");
        irregularPlurals.put("buses", "bus");
        irregularPlurals.put("busses", "bus");
        irregularPlurals.put("brethren", "brother");
        irregularPlurals.put("caches", "cache");
        irregularPlurals.put("calves", "calf");
        irregularPlurals.put("cargoes", "cargo");
        irregularPlurals.put("caribou", "caribou");
        irregularPlurals.put("children", "child");
        irregularPlurals.put("data", "datum");
        irregularPlurals.put("deer", "deer");
        irregularPlurals.put("dice", "die");
        irregularPlurals.put("dies", "die");
        irregularPlurals.put("dominoes", "domino");
        irregularPlurals.put("echoes", "echo");
        irregularPlurals.put("elves", "elf");
        irregularPlurals.put("elk", "elk");
        irregularPlurals.put("embargoes", "embargo");
        irregularPlurals.put("fish", "fish");
        irregularPlurals.put("feet", "foot");
        irregularPlurals.put("gentlemen", "gentleman");
        irregularPlurals.put("gentlewomen", "gentlewoman");
        irregularPlurals.put("geese", "goose");
        irregularPlurals.put("goes", "go");
        irregularPlurals.put("grottoes", "grotto");
        irregularPlurals.put("grouse", "grouse");
        irregularPlurals.put("halves", "half");
        irregularPlurals.put("hooves", "hoof");
        irregularPlurals.put("knives", "knife");
        irregularPlurals.put("leaves", "leaf");
        irregularPlurals.put("lives", "life");
        irregularPlurals.put("lice", "louse");
        irregularPlurals.put("men", "man");
        irregularPlurals.put("monies", "money");
        irregularPlurals.put("moose", "moose");
        irregularPlurals.put("mottoes", "motto");
        irregularPlurals.put("mice", "mouse");
        irregularPlurals.put("octopi", "octopus");
        irregularPlurals.put("octopodes", "octopus");
        irregularPlurals.put("octopuses", "octopus");
        irregularPlurals.put("oxen", "ox");
        irregularPlurals.put("pies", "pie");
        irregularPlurals.put("pluses", "plus");
        irregularPlurals.put("posses", "posse");
        irregularPlurals.put("potatoes", "potato");
        irregularPlurals.put("quail", "quail");
        irregularPlurals.put("reindeer", "reindeer");
        irregularPlurals.put("scarves", "scarf");
        irregularPlurals.put("sheaves", "sheaf");
        irregularPlurals.put("sheep", "sheep");
        irregularPlurals.put("shelves", "shelf");
        irregularPlurals.put("squid", "squid");
        irregularPlurals.put("teeth", "tooth");
        irregularPlurals.put("thieves", "thief");
        irregularPlurals.put("ties", "tie");
        irregularPlurals.put("tomatoes", "tomato");
        irregularPlurals.put("wharves", "wharf");
        irregularPlurals.put("wives", "wife");
        irregularPlurals.put("wolves", "wolf");
        irregularPlurals.put("women", "woman");
    }
}

