/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.code_generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dev.sanda.datafi.DatafiStaticUtils;
import dev.sanda.datafi.annotations.MainClass;
import dev.sanda.datafi.annotations.TransientModule;
import dev.sanda.datafi.code_generator.DaoAggregatorFactory;
import dev.sanda.datafi.code_generator.DaoFactory;
import dev.sanda.datafi.code_generator.DataManagerFactory;
import dev.sanda.datafi.code_generator.FreeTextSearchMethodsFactory;
import dev.sanda.datafi.code_generator.annotated_element_specs.EntityDalSpec;
import dev.sanda.datafi.code_generator.query.CustomSQLQueryFactory;
import dev.sanda.datafi.reflection.runtime_services.CollectionsTypeResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class AnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (!roundEnvironment.getElementsAnnotatedWith(TransientModule.class).isEmpty()) {
            return false;
        }
        List<EntityDalSpec> entitySpecs = DatafiStaticUtils.getEntityApiSpecs(roundEnvironment, this.processingEnv);
        if (entitySpecs.isEmpty()) {
            return false;
        }
        Map<TypeElement, List<MethodSpec>> customSqlQueriesMap = new CustomSQLQueryFactory(this.processingEnv).constructCustomQueries(entitySpecs);
        Map<TypeElement, MethodSpec> searchMethodsMap = new FreeTextSearchMethodsFactory(this.processingEnv).resolveFreeTextSearchMethods(entitySpecs);
        DaoFactory daoFactory = new DaoFactory(this.processingEnv);
        DataManagerFactory dataManagerFactory = new DataManagerFactory(this.processingEnv, DatafiStaticUtils.getBasePackage(roundEnvironment));
        entitySpecs.forEach(entityDalSpec -> {
            daoFactory.generateDao((EntityDalSpec)entityDalSpec, customSqlQueriesMap, searchMethodsMap);
            dataManagerFactory.addDataManager((EntityDalSpec)entityDalSpec);
        });
        dataManagerFactory.addBasePackageResolver(DatafiStaticUtils.getModelPackageNames(entitySpecs));
        dataManagerFactory.writeToFile();
        this.setComponentScan(entitySpecs, roundEnvironment);
        this.setEntityFieldCollectionTypeResolversBean(entitySpecs, roundEnvironment);
        DaoAggregatorFactory.generateDaoCollectorImpl(DatafiStaticUtils.getModelPackageNames(entitySpecs), this.processingEnv);
        return false;
    }

    private void setEntityFieldCollectionTypeResolversBean(List<EntityDalSpec> entityDalSpecs, RoundEnvironment env) {
        HashMap<String, ClassName> collectionsTypes = new HashMap<String, ClassName>();
        entityDalSpecs.forEach(entity -> DatafiStaticUtils.getFieldsOf((TypeElement)entity.getElement()).stream().filter(field -> DatafiStaticUtils.isCollectionField(field, this.processingEnv)).forEach(collectionField -> {
            String key = entity.getSimpleName() + "." + collectionField.getSimpleName().toString();
            ClassName value = ClassName.bestGuess((String)collectionField.asType().toString().replaceAll(".+<", "").replaceAll(">", ""));
            collectionsTypes.put(key, value);
        }));
        this.generateCollectionsTypesResolver(collectionsTypes, env);
    }

    private void generateCollectionsTypesResolver(Map<String, ClassName> collectionsTypes, RoundEnvironment env) {
        ParameterizedTypeName mapType = ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Class.class)});
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"collectionsTypesResolver").addAnnotation(Bean.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get(CollectionsTypeResolver.class));
        builder.addStatement("$T typeResolverMap = new $T()", new Object[]{mapType, mapType});
        collectionsTypes.forEach((key, type) -> builder.addStatement("typeResolverMap.put($S, $T.class)", new Object[]{key, type}));
        builder.addStatement("return new $T(typeResolverMap)", new Object[]{CollectionsTypeResolver.class});
        TypeSpec typeResolverMapFactory = TypeSpec.classBuilder((String)"TypeResolverMapFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Configuration.class).addMethod(builder.build()).build();
        try {
            JavaFile file = JavaFile.builder((String)DatafiStaticUtils.getBasePackage(env), (TypeSpec)typeResolverMapFactory).build();
            file.writeTo((Appendable)System.out);
            file.writeTo(this.processingEnv.getFiler());
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.toString());
        }
    }

    private void setComponentScan(List<EntityDalSpec> entityDalSpecs, RoundEnvironment roundEnv) {
        if (!entityDalSpecs.isEmpty()) {
            String className = ((TypeElement)entityDalSpecs.get(0).getElement()).getQualifiedName().toString();
            String simpleClassName = "SandaClasspathConfiguration";
            TypeSpec.Builder builder = TypeSpec.classBuilder((String)simpleClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Configuration.class).addAnnotation(AnnotationSpec.builder(ComponentScan.class).addMember("basePackages", "{$S}", new Object[]{"dev.sanda"}).build());
            DatafiStaticUtils.writeToJavaFile(simpleClassName, this.basePackageName(entityDalSpecs, roundEnv), builder, this.processingEnv, "configuration source file");
        }
    }

    private String basePackageName(List<EntityDalSpec> entityDalSpecs, RoundEnvironment roundEnvironment) {
        ArrayList<? extends Element> mainClass = new ArrayList<Element>(roundEnvironment.getElementsAnnotatedWith(SpringBootApplication.class));
        if (!mainClass.isEmpty()) {
            String name = mainClass.get(0).asType().toString();
            return name.substring(0, name.lastIndexOf("."));
        }
        mainClass = new ArrayList<Element>(roundEnvironment.getElementsAnnotatedWith(MainClass.class));
        if (!mainClass.isEmpty()) {
            String name = mainClass.get(0).asType().toString();
            return name.substring(0, name.lastIndexOf("."));
        }
        String[] rootElementNames = (String[])roundEnvironment.getRootElements().stream().map(e -> e.asType().toString()).toArray(String[]::new);
        String commonPrefix = StringUtils.getCommonPrefix((String[])rootElementNames);
        if (!commonPrefix.equals("")) {
            return commonPrefix.endsWith(".") ? commonPrefix.substring(0, commonPrefix.lastIndexOf(".")) : commonPrefix;
        }
        DatafiStaticUtils.logCompilationError(this.processingEnv, entityDalSpecs.get(0).getElement(), "It appears the current module shares no internal common package structure, and there is no main class clearly demarcated with @SpringBootApplication or @MainClass annotations. In order to enable the correct spring component scan settings the module must adhere to at least of the above.");
        return null;
    }
}

