/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.code_generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import dev.sanda.datafi.DatafiStaticUtils;
import dev.sanda.datafi.persistence.GenericDao;
import dev.sanda.datafi.service.DaoCollector;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.stereotype.Component;

public class DaoAggregatorFactory {
    public static void generateDaoCollectorImpl(List<String> packageNames, ProcessingEnvironment processingEnvironment) {
        AnnotationSpec.Builder componentScanBuilder = AnnotationSpec.builder(ComponentScan.class);
        AnnotationSpec.Builder entityScanBuilder = AnnotationSpec.builder(EntityScan.class);
        AnnotationSpec.Builder enableJpaReposBuilder = AnnotationSpec.builder(EnableJpaRepositories.class);
        String names = "{\"" + String.join((CharSequence)"\", \"", packageNames) + "\"}";
        componentScanBuilder.addMember("value", "$L", new Object[]{names});
        entityScanBuilder.addMember("value", "$L", new Object[]{names});
        enableJpaReposBuilder.addMember("value", "$L", new Object[]{names});
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"DaoCollectorImpl").addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(DaoCollector.class).addAnnotation(Component.class).addAnnotation(componentScanBuilder.build()).addAnnotation(entityScanBuilder.build()).addAnnotation(enableJpaReposBuilder.build()).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(GenericDao.class)}), (String)"daos", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Getter.class).addAnnotation(Autowired.class).build());
        DatafiStaticUtils.writeToJavaFile("DaoCollectorImpl", packageNames.get(0), builder, processingEnvironment, "Dao aggregator for data manager");
    }
}

