/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.code_generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dev.sanda.datafi.DatafiStaticUtils;
import dev.sanda.datafi.annotations.finders.FindAllBy;
import dev.sanda.datafi.annotations.finders.FindBy;
import dev.sanda.datafi.annotations.finders.FindByUnique;
import dev.sanda.datafi.code_generator.annotated_element_specs.EntityDalSpec;
import dev.sanda.datafi.code_generator.annotated_element_specs.FieldDalSpec;
import dev.sanda.datafi.persistence.GenericDao;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import lombok.NonNull;
import org.springframework.stereotype.Repository;

public class DaoFactory {
    @NonNull
    private ProcessingEnvironment processingEnv;

    protected void generateDao(EntityDalSpec entityDalSpec, Map<TypeElement, List<MethodSpec>> customSQLQueriesMap, Map<TypeElement, MethodSpec> freeTextSearchMethods) {
        String className = ((TypeElement)entityDalSpec.getElement()).getQualifiedName().toString();
        int lastDot = className.lastIndexOf(46);
        String packageName = className.substring(0, lastDot);
        String simpleClassName = className.substring(lastDot + 1);
        String repositoryName = simpleClassName + "Dao";
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)repositoryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Repository.class).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(GenericDao.class), (TypeName[])new TypeName[]{DatafiStaticUtils.getIdType((TypeElement)entityDalSpec.getElement(), this.processingEnv), ClassName.get((TypeElement)((TypeElement)entityDalSpec.getElement()))}));
        List<FieldDalSpec> annotatedFields = entityDalSpec.getFieldDalSpecs();
        if (annotatedFields != null) {
            annotatedFields.forEach(annotatedField -> this.handleAnnotatedField(entityDalSpec, builder, (FieldDalSpec)annotatedField));
        }
        if (customSQLQueriesMap.get(entityDalSpec.getElement()) != null) {
            customSQLQueriesMap.get(entityDalSpec.getElement()).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        }
        if (freeTextSearchMethods.get(entityDalSpec.getElement()) != null) {
            builder.addMethod(freeTextSearchMethods.get(entityDalSpec.getElement()));
        }
        DatafiStaticUtils.writeToJavaFile(entityDalSpec.getSimpleName(), packageName, builder, this.processingEnv, "JpaRepository");
    }

    private void handleAnnotatedField(EntityDalSpec entityDalSpec, TypeSpec.Builder builder, FieldDalSpec fieldDalSpec) {
        if (this.isFindBy(fieldDalSpec)) {
            this.handleFindBy(entityDalSpec, builder, fieldDalSpec);
        }
        if (this.isFindAllBy(fieldDalSpec)) {
            this.handleFindAllBy(entityDalSpec, builder, fieldDalSpec);
        }
        if (this.isFindByUnique(fieldDalSpec)) {
            this.handleFindByUnique(entityDalSpec, builder, fieldDalSpec);
        }
    }

    private boolean isFindByUnique(FieldDalSpec annotatedField) {
        return DatafiStaticUtils.isDirectlyOrIndirectlyAnnotatedAs(annotatedField.getElement(), FindByUnique.class) || annotatedField.hasAnnotation(FindByUnique.class);
    }

    private boolean isFindAllBy(FieldDalSpec annotatedField) {
        return DatafiStaticUtils.isDirectlyOrIndirectlyAnnotatedAs(annotatedField.getElement(), FindAllBy.class) || annotatedField.hasAnnotation(FindAllBy.class);
    }

    private boolean isFindBy(FieldDalSpec annotatedField) {
        return DatafiStaticUtils.isDirectlyOrIndirectlyAnnotatedAs(annotatedField.getElement(), FindBy.class) || annotatedField.hasAnnotation(FindBy.class);
    }

    private void handleFindByUnique(EntityDalSpec entityDalSpec, TypeSpec.Builder builder, FieldDalSpec annotatedField) {
        if (this.isFindBy(annotatedField)) {
            DatafiStaticUtils.logCompilationError(this.processingEnv, annotatedField.getElement(), "@FindBy and @FindByUnique cannot by definition be used together");
        } else if (!this.isUniqueColumn(annotatedField)) {
            DatafiStaticUtils.logCompilationError(this.processingEnv, annotatedField.getElement(), "In order to use @FindByUnique on a field, annotate the field as @Column(unique = true)");
        } else {
            builder.addMethod(MethodSpec.methodBuilder((String)("findBy" + DatafiStaticUtils.toPascalCase(annotatedField.getSimpleName().toString()))).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addParameter(ClassName.get((TypeMirror)((VariableElement)annotatedField.getElement()).asType()), annotatedField.getSimpleName().toString(), new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)((TypeElement)entityDalSpec.getElement()))})).build());
        }
    }

    private boolean isUniqueColumn(FieldDalSpec annotatedField) {
        return annotatedField.hasAnnotation(Column.class) && annotatedField.getAnnotation(Column.class).unique() || annotatedField.hasAnnotation(Id.class) || annotatedField.hasAnnotation(EmbeddedId.class);
    }

    private void handleFindAllBy(EntityDalSpec entityDalSpec, TypeSpec.Builder builder, FieldDalSpec annotatedField) {
        builder.addMethod(MethodSpec.methodBuilder((String)("findAllBy" + DatafiStaticUtils.toPascalCase(annotatedField.getSimpleName()) + "In")).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)((VariableElement)annotatedField.getElement()).asType())}), DatafiStaticUtils.toPlural(annotatedField.getSimpleName()), new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)((TypeElement)entityDalSpec.getElement()))})).build());
    }

    private void handleFindBy(EntityDalSpec entityDalSpec, TypeSpec.Builder builder, FieldDalSpec annotatedField) {
        builder.addMethod(MethodSpec.methodBuilder((String)("findBy" + DatafiStaticUtils.toPascalCase(annotatedField.getSimpleName()))).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addParameter(ClassName.get((TypeMirror)((VariableElement)annotatedField.getElement()).asType()), annotatedField.getSimpleName(), new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)((TypeElement)entityDalSpec.getElement()))})).build());
    }

    public DaoFactory(@NonNull ProcessingEnvironment processingEnv) {
        if (processingEnv == null) {
            throw new NullPointerException("processingEnv is marked non-null but is null");
        }
        this.processingEnv = processingEnv;
    }

    @NonNull
    public ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    public void setProcessingEnv(@NonNull ProcessingEnvironment processingEnv) {
        if (processingEnv == null) {
            throw new NullPointerException("processingEnv is marked non-null but is null");
        }
        this.processingEnv = processingEnv;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DaoFactory)) {
            return false;
        }
        DaoFactory other = (DaoFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProcessingEnvironment this$processingEnv = this.getProcessingEnv();
        ProcessingEnvironment other$processingEnv = other.getProcessingEnv();
        return !(this$processingEnv == null ? other$processingEnv != null : !this$processingEnv.equals(other$processingEnv));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DaoFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProcessingEnvironment $processingEnv = this.getProcessingEnv();
        result = result * 59 + ($processingEnv == null ? 43 : $processingEnv.hashCode());
        return result;
    }

    public String toString() {
        return "DaoFactory(processingEnv=" + this.getProcessingEnv() + ")";
    }
}

