/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.code_generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dev.sanda.datafi.DatafiStaticUtils;
import dev.sanda.datafi.code_generator.BasePackageResolver;
import dev.sanda.datafi.code_generator.annotated_element_specs.EntityDalSpec;
import dev.sanda.datafi.service.DataManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

public class DataManagerFactory {
    @NonNull
    private ProcessingEnvironment processingEnv;
    @NonNull
    private String basePackage;
    private TypeSpec.Builder dataManagersConfig = DataManagerFactory.initDataManagerConfig();
    private static final ClassName dataManagerType = ClassName.get(DataManager.class);

    public void addDataManager(EntityDalSpec entityDalSpec) {
        ClassName entityType = ClassName.get((TypeElement)((TypeElement)entityDalSpec.getElement()));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(DatafiStaticUtils.camelCaseNameOf(entityDalSpec.getElement()) + "DataManager")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Bean.class).returns((TypeName)ParameterizedTypeName.get((ClassName)dataManagerType, (TypeName[])new TypeName[]{entityType})).addStatement("return new $T($T.class)", new Object[]{dataManagerType, entityType});
        this.dataManagersConfig.addMethod(builder.build());
    }

    public void addBasePackageResolver(List<String> modelPackageNames) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"basePackageResolver").addAnnotation(Bean.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BasePackageResolver.class).addStatement("$T packageNames = new $T()", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class}), ParameterizedTypeName.get(ArrayList.class, (Type[])new Type[]{String.class})});
        modelPackageNames.forEach(name -> builder.addStatement("packageNames.add($S)", new Object[]{name}));
        this.dataManagersConfig.addMethod(builder.addStatement("return new $T($L)", new Object[]{BasePackageResolver.class, "packageNames"}).build());
    }

    private static TypeSpec.Builder initDataManagerConfig() {
        return TypeSpec.classBuilder((String)"DataManagersConfig").addAnnotation(Configuration.class).addMethod(MethodSpec.methodBuilder((String)"nullTypeDataManager").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Bean.class).addAnnotation(Primary.class).returns((TypeName)dataManagerType).addStatement("return new $T()", new Object[]{dataManagerType}).build());
    }

    public void writeToFile() {
        DatafiStaticUtils.writeToJavaFile("DataManagersConfig", this.basePackage, this.dataManagersConfig, this.processingEnv, "Data manager beans");
    }

    public DataManagerFactory(@NonNull ProcessingEnvironment processingEnv, @NonNull String basePackage) {
        if (processingEnv == null) {
            throw new NullPointerException("processingEnv is marked non-null but is null");
        }
        if (basePackage == null) {
            throw new NullPointerException("basePackage is marked non-null but is null");
        }
        this.processingEnv = processingEnv;
        this.basePackage = basePackage;
    }

    @NonNull
    public ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    @NonNull
    public String getBasePackage() {
        return this.basePackage;
    }

    public TypeSpec.Builder getDataManagersConfig() {
        return this.dataManagersConfig;
    }

    public void setProcessingEnv(@NonNull ProcessingEnvironment processingEnv) {
        if (processingEnv == null) {
            throw new NullPointerException("processingEnv is marked non-null but is null");
        }
        this.processingEnv = processingEnv;
    }

    public void setBasePackage(@NonNull String basePackage) {
        if (basePackage == null) {
            throw new NullPointerException("basePackage is marked non-null but is null");
        }
        this.basePackage = basePackage;
    }

    public void setDataManagersConfig(TypeSpec.Builder dataManagersConfig) {
        this.dataManagersConfig = dataManagersConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataManagerFactory)) {
            return false;
        }
        DataManagerFactory other = (DataManagerFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProcessingEnvironment this$processingEnv = this.getProcessingEnv();
        ProcessingEnvironment other$processingEnv = other.getProcessingEnv();
        if (this$processingEnv == null ? other$processingEnv != null : !this$processingEnv.equals(other$processingEnv)) {
            return false;
        }
        String this$basePackage = this.getBasePackage();
        String other$basePackage = other.getBasePackage();
        if (this$basePackage == null ? other$basePackage != null : !this$basePackage.equals(other$basePackage)) {
            return false;
        }
        TypeSpec.Builder this$dataManagersConfig = this.getDataManagersConfig();
        TypeSpec.Builder other$dataManagersConfig = other.getDataManagersConfig();
        return !(this$dataManagersConfig == null ? other$dataManagersConfig != null : !this$dataManagersConfig.equals(other$dataManagersConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataManagerFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProcessingEnvironment $processingEnv = this.getProcessingEnv();
        result = result * 59 + ($processingEnv == null ? 43 : $processingEnv.hashCode());
        String $basePackage = this.getBasePackage();
        result = result * 59 + ($basePackage == null ? 43 : $basePackage.hashCode());
        TypeSpec.Builder $dataManagersConfig = this.getDataManagersConfig();
        result = result * 59 + ($dataManagersConfig == null ? 43 : $dataManagersConfig.hashCode());
        return result;
    }

    public String toString() {
        return "DataManagerFactory(processingEnv=" + this.getProcessingEnv() + ", basePackage=" + this.getBasePackage() + ", dataManagersConfig=" + this.getDataManagersConfig() + ")";
    }
}

