/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.code_generator;

import dev.sanda.datafi.DatafiStaticUtils;
import dev.sanda.datafi.annotations.finders.FindAllBy;
import dev.sanda.datafi.annotations.finders.FindBy;
import dev.sanda.datafi.annotations.finders.FindByUnique;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import lombok.NonNull;

public class FindByFieldsResolver {
    @NonNull
    private ProcessingEnvironment processingEnv;

    public Map<TypeElement, List<VariableElement>> annotatedFieldsMap(Set<? extends TypeElement> entities) {
        HashMap<TypeElement, List<VariableElement>> result = new HashMap<TypeElement, List<VariableElement>>();
        for (TypeElement typeElement : entities) {
            ArrayList annotatedFields = new ArrayList();
            typeElement.getEnclosedElements().stream().filter(e -> e.getKind().isField()).forEach(field -> {
                if (this.hasFindByAnnotation((Element)field)) {
                    annotatedFields.add((VariableElement)field);
                }
            });
            if (annotatedFields.isEmpty()) continue;
            result.put(typeElement, annotatedFields);
        }
        return result;
    }

    private boolean hasFindByAnnotation(Element element) {
        return DatafiStaticUtils.isDirectlyOrIndirectlyAnnotatedAs(element, FindBy.class) || DatafiStaticUtils.isDirectlyOrIndirectlyAnnotatedAs(element, FindAllBy.class) || DatafiStaticUtils.isDirectlyOrIndirectlyAnnotatedAs(element, FindByUnique.class);
    }

    public FindByFieldsResolver(@NonNull ProcessingEnvironment processingEnv) {
        if (processingEnv == null) {
            throw new NullPointerException("processingEnv is marked non-null but is null");
        }
        this.processingEnv = processingEnv;
    }
}

