/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.code_generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dev.sanda.datafi.DatafiStaticUtils;
import dev.sanda.datafi.annotations.free_text_search.WithFreeTextSearchByFields;
import dev.sanda.datafi.code_generator.annotated_element_specs.AnnotatedElementSpec;
import dev.sanda.datafi.code_generator.annotated_element_specs.EntityDalSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import lombok.NonNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public class FreeTextSearchMethodsFactory {
    @NonNull
    private ProcessingEnvironment processingEnv;
    private Map<TypeMirror, TypeElement> typeMirrorTypeElementMap;

    protected Map<TypeElement, MethodSpec> resolveFreeTextSearchMethods(List<EntityDalSpec> entityDalSpecs) {
        HashMap<TypeElement, MethodSpec> result = new HashMap<TypeElement, MethodSpec>();
        this.typeMirrorTypeElementMap = entityDalSpecs.stream().map(AnnotatedElementSpec::getElement).collect(Collectors.toMap(Element::asType, entity -> entity));
        entityDalSpecs.stream().filter(entityDalSpec -> entityDalSpec.getAnnotation(WithFreeTextSearchByFields.class) != null).collect(Collectors.toSet()).forEach(entityDavSpecWithFreeTextSearchFields -> {
            List<String> searchFieldNames = Arrays.asList(entityDavSpecWithFreeTextSearchFields.getAnnotation(WithFreeTextSearchByFields.class).value());
            if (!searchFieldNames.isEmpty()) {
                MethodSpec freeTextSearchMethod = this.generateFreeTextSearchMethod((EntityDalSpec)entityDavSpecWithFreeTextSearchFields, searchFieldNames);
                result.put((TypeElement)entityDavSpecWithFreeTextSearchFields.getElement(), freeTextSearchMethod);
            }
        });
        return result;
    }

    private MethodSpec generateFreeTextSearchMethod(EntityDalSpec entityDalSpec, List<String> searchFieldNames) {
        String entityName = entityDalSpec.getSimpleName();
        String methodName = "freeTextSearch";
        ParameterSpec argument = ParameterSpec.builder(String.class, (String)"searchTerm", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(Param.class).addMember("value", "$S", new Object[]{"searchTerm"}).build()).build();
        String freeTextSearchQuery = FreeTextSearchMethodsFactory.freeTextSearchQuery(entityName, searchFieldNames, DatafiStaticUtils.isArchivable((TypeElement)entityDalSpec.getElement(), this.processingEnv), false);
        return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addParameter(argument).addParameter(Pageable.class, "paginator", new Modifier[0]).addAnnotation(AnnotationSpec.builder(Query.class).addMember("value", "$S", new Object[]{freeTextSearchQuery}).build()).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Page.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)((TypeElement)entityDalSpec.getElement()))})).build();
    }

    public static String freeTextSearchQuery(String entityName, List<String> searchFieldNames, boolean isArchivable, boolean selectCount) {
        String placeHolder = DatafiStaticUtils.firstLowerCaseLetterOf(entityName);
        String selectionPrefix = selectCount ? "SELECT COUNT(" + placeHolder + ") FROM " + entityName + " " + placeHolder : "SELECT " + placeHolder + " FROM " + entityName + " " + placeHolder;
        StringBuilder result = new StringBuilder(selectionPrefix);
        boolean isFirst = true;
        for (String fieldName : searchFieldNames) {
            String conditionPrefix = isFirst ? " WHERE" : " OR";
            isFirst = false;
            String condition = " lower(" + placeHolder + "." + fieldName + ") LIKE lower(concat('%', :searchTerm, '%'))";
            result.append(conditionPrefix);
            result.append(condition);
        }
        if (isArchivable) {
            result.append(" AND ").append(placeHolder).append(".isArchived = false");
        }
        return result.toString();
    }

    public FreeTextSearchMethodsFactory(@NonNull ProcessingEnvironment processingEnv) {
        if (processingEnv == null) {
            throw new NullPointerException("processingEnv is marked non-null but is null");
        }
        this.processingEnv = processingEnv;
    }

    @NonNull
    public ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    public Map<TypeMirror, TypeElement> getTypeMirrorTypeElementMap() {
        return this.typeMirrorTypeElementMap;
    }

    public void setProcessingEnv(@NonNull ProcessingEnvironment processingEnv) {
        if (processingEnv == null) {
            throw new NullPointerException("processingEnv is marked non-null but is null");
        }
        this.processingEnv = processingEnv;
    }

    public void setTypeMirrorTypeElementMap(Map<TypeMirror, TypeElement> typeMirrorTypeElementMap) {
        this.typeMirrorTypeElementMap = typeMirrorTypeElementMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FreeTextSearchMethodsFactory)) {
            return false;
        }
        FreeTextSearchMethodsFactory other = (FreeTextSearchMethodsFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProcessingEnvironment this$processingEnv = this.getProcessingEnv();
        ProcessingEnvironment other$processingEnv = other.getProcessingEnv();
        if (this$processingEnv == null ? other$processingEnv != null : !this$processingEnv.equals(other$processingEnv)) {
            return false;
        }
        Map<TypeMirror, TypeElement> this$typeMirrorTypeElementMap = this.getTypeMirrorTypeElementMap();
        Map<TypeMirror, TypeElement> other$typeMirrorTypeElementMap = other.getTypeMirrorTypeElementMap();
        return !(this$typeMirrorTypeElementMap == null ? other$typeMirrorTypeElementMap != null : !((Object)this$typeMirrorTypeElementMap).equals(other$typeMirrorTypeElementMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FreeTextSearchMethodsFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProcessingEnvironment $processingEnv = this.getProcessingEnv();
        result = result * 59 + ($processingEnv == null ? 43 : $processingEnv.hashCode());
        Map<TypeMirror, TypeElement> $typeMirrorTypeElementMap = this.getTypeMirrorTypeElementMap();
        result = result * 59 + ($typeMirrorTypeElementMap == null ? 43 : ((Object)$typeMirrorTypeElementMap).hashCode());
        return result;
    }

    public String toString() {
        return "FreeTextSearchMethodsFactory(processingEnv=" + this.getProcessingEnv() + ", typeMirrorTypeElementMap=" + this.getTypeMirrorTypeElementMap() + ")";
    }
}

