/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.code_generator.annotated_element_specs;

import dev.sanda.datafi.DatafiStaticUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;

public abstract class AnnotatedElementSpec<T extends Element> {
    protected T element;
    protected String simpleName;
    protected Map<Class<? extends Annotation>, List<Annotation>> annotations = new HashMap<Class<? extends Annotation>, List<Annotation>>();

    public AnnotatedElementSpec(T element) {
        this.element = element;
        this.simpleName = element.getSimpleName().toString();
        this.addAnnotations((Element)element);
    }

    protected void addAnnotations(Element element) {
        for (Class targetAnnotation : this.targetAnnotations()) {
            Annotation[] annotationsByTargetType = element.getAnnotationsByType(targetAnnotation);
            if (annotationsByTargetType.length > 0) {
                this.annotations.put(targetAnnotation, Arrays.asList(annotationsByTargetType));
                continue;
            }
            if (!DatafiStaticUtils.isDirectlyOrIndirectlyAnnotatedAs(element, targetAnnotation)) continue;
            Annotation annotation = DatafiStaticUtils.getDirectOrIndirectAnnotation(element, targetAnnotation);
            this.annotations.put(targetAnnotation, Collections.singletonList(annotation));
        }
    }

    protected abstract <A extends Annotation> Class<A>[] targetAnnotations();

    public <A extends Annotation> List<A> getAnnotationsByType(Class<A> annotationType) {
        return this.annotations.containsKey(annotationType) ? this.annotations.get(annotationType) : new ArrayList();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)(this.annotations.containsKey(annotationType) ? this.annotations.get(annotationType).get(0) : null);
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    public T getElement() {
        return this.element;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public Map<Class<? extends Annotation>, List<Annotation>> getAnnotations() {
        return this.annotations;
    }
}

