/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.code_generator.annotated_element_specs;

import com.squareup.javapoet.TypeName;
import dev.sanda.datafi.DatafiStaticUtils;
import dev.sanda.datafi.annotations.attributes.NonApiUpdatables;
import dev.sanda.datafi.annotations.free_text_search.WithFreeTextSearchByFields;
import dev.sanda.datafi.annotations.query.WithNativeQuery;
import dev.sanda.datafi.annotations.query.WithQuery;
import dev.sanda.datafi.annotations.query.WithQueryScripts;
import dev.sanda.datafi.code_generator.annotated_element_specs.AnnotatedElementSpec;
import dev.sanda.datafi.code_generator.annotated_element_specs.FieldDalSpec;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class EntityDalSpec
extends AnnotatedElementSpec<TypeElement> {
    private List<FieldDalSpec> fieldDalSpecs;

    public Map<String, TypeName> getEntityFieldTypes() {
        return this.fieldDalSpecs.stream().collect(Collectors.toMap(fieldDalSpec -> fieldDalSpec.simpleName, fieldDalSpec -> TypeName.get((TypeMirror)((VariableElement)fieldDalSpec.element).asType())));
    }

    public EntityDalSpec(TypeElement entity, TypeElement entityApiSpec) {
        super(entity);
        if (entityApiSpec != null) {
            this.addAnnotations(entityApiSpec);
        }
        this.setFieldSpecs(entityApiSpec);
    }

    private void setFieldSpecs(TypeElement entityApiSpec) {
        this.fieldDalSpecs = new ArrayList<FieldDalSpec>();
        List<VariableElement> entityFields = DatafiStaticUtils.getFieldsOf((TypeElement)this.element);
        List<ExecutableElement> apiSpecGetters = DatafiStaticUtils.getGettersOf(entityApiSpec);
        Map gettersByFieldNames = apiSpecGetters.stream().collect(Collectors.toMap(getter -> getter.getSimpleName().toString().replaceFirst("get", ""), Function.identity()));
        entityFields.forEach(field -> {
            ExecutableElement getter = (ExecutableElement)gettersByFieldNames.get(DatafiStaticUtils.toPascalCase(field.getSimpleName().toString()));
            if (getter != null) {
                this.fieldDalSpecs.add(new FieldDalSpec((VariableElement)field, getter));
            } else {
                this.fieldDalSpecs.add(new FieldDalSpec((VariableElement)field));
            }
        });
    }

    @Override
    protected <A extends Annotation> Class<A>[] targetAnnotations() {
        return new Class[]{NonApiUpdatables.class, WithFreeTextSearchByFields.class, WithNativeQuery.class, WithQuery.class, WithQueryScripts.class};
    }

    public List<FieldDalSpec> getFieldDalSpecs() {
        return this.fieldDalSpecs;
    }
}

