/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.code_generator.query;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dev.sanda.datafi.code_generator.query.ReturnPlurality;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.springframework.data.repository.query.Param;

public class CustomSQLQuery {
    private TypeElement annotatedEntity;
    private String name;
    private String sql;
    private boolean isNative = false;
    private LinkedHashMap<String, TypeName> args = new LinkedHashMap();
    private ReturnPlurality returnPlurality;

    public TypeName returnSignature() {
        TypeName returnType = this.isDtoReturnType() ? this.resolveDtoType() : ClassName.get((TypeElement)this.annotatedEntity);
        switch (this.returnPlurality) {
            case SINGLE: {
                return returnType;
            }
            case BATCH: {
                return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{returnType});
            }
        }
        return null;
    }

    private TypeName resolveDtoType() {
        String dtoName = this.sql.split(" ")[2];
        String canonicalDtoClassName = dtoName.substring(0, dtoName.indexOf("("));
        return ClassName.bestGuess((String)canonicalDtoClassName);
    }

    private boolean isDtoReturnType() {
        return this.sql.toUpperCase().matches("^SELECT NEW [A-Z][A-Z0-9_]*(\\.[A-Z0-9_]+)+[0-9A-Z_].+");
    }

    public List<ParameterSpec> parameterSpecs() {
        return this.args.entrySet().stream().map(this::queryParam).collect(Collectors.toList());
    }

    private ParameterSpec queryParam(Map.Entry<String, TypeName> arg) {
        return ParameterSpec.builder((TypeName)arg.getValue(), (String)arg.getKey(), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(Param.class).addMember("value", "$S", new Object[]{arg.getKey()}).build()).build();
    }

    public TypeElement getAnnotatedEntity() {
        return this.annotatedEntity;
    }

    public String getName() {
        return this.name;
    }

    public String getSql() {
        return this.sql;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public LinkedHashMap<String, TypeName> getArgs() {
        return this.args;
    }

    public ReturnPlurality getReturnPlurality() {
        return this.returnPlurality;
    }

    public void setAnnotatedEntity(TypeElement annotatedEntity) {
        this.annotatedEntity = annotatedEntity;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setNative(boolean isNative) {
        this.isNative = isNative;
    }

    public void setArgs(LinkedHashMap<String, TypeName> args) {
        this.args = args;
    }

    public void setReturnPlurality(ReturnPlurality returnPlurality) {
        this.returnPlurality = returnPlurality;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomSQLQuery)) {
            return false;
        }
        CustomSQLQuery other = (CustomSQLQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNative() != other.isNative()) {
            return false;
        }
        TypeElement this$annotatedEntity = this.getAnnotatedEntity();
        TypeElement other$annotatedEntity = other.getAnnotatedEntity();
        if (this$annotatedEntity == null ? other$annotatedEntity != null : !this$annotatedEntity.equals(other$annotatedEntity)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        LinkedHashMap<String, TypeName> this$args = this.getArgs();
        LinkedHashMap<String, TypeName> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        ReturnPlurality this$returnPlurality = this.getReturnPlurality();
        ReturnPlurality other$returnPlurality = other.getReturnPlurality();
        return !(this$returnPlurality == null ? other$returnPlurality != null : !((Object)((Object)this$returnPlurality)).equals((Object)other$returnPlurality));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomSQLQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNative() ? 79 : 97);
        TypeElement $annotatedEntity = this.getAnnotatedEntity();
        result = result * 59 + ($annotatedEntity == null ? 43 : $annotatedEntity.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        LinkedHashMap<String, TypeName> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        ReturnPlurality $returnPlurality = this.getReturnPlurality();
        result = result * 59 + ($returnPlurality == null ? 43 : ((Object)((Object)$returnPlurality)).hashCode());
        return result;
    }

    public String toString() {
        return "CustomSQLQuery(annotatedEntity=" + this.getAnnotatedEntity() + ", name=" + this.getName() + ", sql=" + this.getSql() + ", isNative=" + this.isNative() + ", args=" + this.getArgs() + ", returnPlurality=" + (Object)((Object)this.getReturnPlurality()) + ")";
    }
}

