/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.code_generator.query;

import com.google.common.collect.Maps;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dev.sanda.datafi.annotations.query.WithNativeQuery;
import dev.sanda.datafi.annotations.query.WithNativeQueryScripts;
import dev.sanda.datafi.annotations.query.WithQuery;
import dev.sanda.datafi.annotations.query.WithQueryScripts;
import dev.sanda.datafi.code_generator.annotated_element_specs.EntityDalSpec;
import dev.sanda.datafi.code_generator.query.CustomSQLQuery;
import dev.sanda.datafi.code_generator.query.ReturnPlurality;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import lombok.NonNull;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.jpa.repository.Query;
import org.springframework.util.FileCopyUtils;

public class CustomSQLQueryFactory {
    @NonNull
    private final ProcessingEnvironment env;

    public Map<TypeElement, List<MethodSpec>> constructCustomQueries(List<EntityDalSpec> entityDalSpecs) {
        HashMap<TypeElement, List<MethodSpec>> customQueriesMap = new HashMap<TypeElement, List<MethodSpec>>();
        for (EntityDalSpec entitySpec : entityDalSpecs) {
            List<CustomSQLQuery> customQueries = this.getCustomSQLQueries(entitySpec);
            ArrayList<MethodSpec> customQueriesMethodSpecs = new ArrayList<MethodSpec>();
            for (CustomSQLQuery query : customQueries) {
                customQueriesMethodSpecs.add(this.generateCustomQueryMethod(query));
            }
            customQueriesMap.put((TypeElement)entitySpec.getElement(), customQueriesMethodSpecs);
        }
        return customQueriesMap;
    }

    private MethodSpec generateCustomQueryMethod(CustomSQLQuery query) {
        AnnotationSpec.Builder queryAnnotationBuilder = AnnotationSpec.builder(Query.class).addMember("value", "$S", new Object[]{query.getSql()});
        if (query.isNative()) {
            queryAnnotationBuilder.addMember("nativeQuery", "$L", new Object[]{true});
        }
        return MethodSpec.methodBuilder((String)query.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(queryAnnotationBuilder.build()).addParameters(query.parameterSpecs()).returns(query.returnSignature()).build();
    }

    private List<CustomSQLQuery> getCustomSQLQueries(EntityDalSpec entityDalSpec) {
        List<WithQuery> individualQueries = entityDalSpec.getAnnotationsByType(WithQuery.class);
        List<WithNativeQuery> individualNativeQueries = entityDalSpec.getAnnotationsByType(WithNativeQuery.class);
        WithQueryScripts queryScripts = entityDalSpec.getAnnotation(WithQueryScripts.class);
        WithNativeQueryScripts nativeQueryScripts = entityDalSpec.getAnnotation(WithNativeQueryScripts.class);
        ArrayList<CustomSQLQuery> customSQLQueries = new ArrayList<CustomSQLQuery>();
        if (!individualQueries.isEmpty()) {
            for (WithQuery withQuery : individualQueries) {
                customSQLQueries.add(this.parseQuery(withQuery.name(), withQuery.jpql(), entityDalSpec));
            }
        }
        if (individualNativeQueries != null) {
            for (WithNativeQuery withNativeQuery : individualNativeQueries) {
                customSQLQueries.add(this.parseIndividualNativeQuery(withNativeQuery.name(), withNativeQuery.sql(), entityDalSpec));
            }
        }
        if (queryScripts != null) {
            for (Iterator<Annotation> iterator : queryScripts.value()) {
                customSQLQueries.add(this.parseQueryScript((String)((Object)iterator), entityDalSpec));
            }
        }
        if (nativeQueryScripts != null) {
            for (Iterator<Annotation> iterator : nativeQueryScripts.value()) {
                customSQLQueries.add(this.parseQueryScript((String)((Object)iterator), entityDalSpec));
            }
        }
        return customSQLQueries;
    }

    private CustomSQLQuery parseQueryScript(String path, EntityDalSpec entityDalSpec) {
        ClassPathResource resource = new ClassPathResource(path);
        String name = this.formatAndValidateName(Objects.requireNonNull(resource.getFilename()));
        String sql = this.sqlResourceToString(resource.getPath());
        boolean nativeQuery = this.determineIfIsNativeQuery(path);
        CustomSQLQuery result = this.parseQuery(name, sql, entityDalSpec);
        result.setNative(nativeQuery);
        return result;
    }

    private boolean determineIfIsNativeQuery(String path) {
        if (path.endsWith(".sql")) {
            return true;
        }
        if (path.endsWith(".jpql")) {
            return false;
        }
        CustomSQLQueryFactory.compilationFailureWithMessage(String.format("Invalid query script path: %s; Paths must end with either a .sql or a .jpql suffix", path), this.env);
        return false;
    }

    private CustomSQLQuery parseIndividualNativeQuery(String name, String sql, EntityDalSpec entityDalSpec) {
        CustomSQLQuery customSQLQuery = this.parseQuery(name, sql, entityDalSpec);
        customSQLQuery.setNative(true);
        return customSQLQuery;
    }

    private CustomSQLQuery parseQuery(String name, String sql, EntityDalSpec entity) {
        CustomSQLQuery customSQLQuery = new CustomSQLQuery();
        customSQLQuery.setAnnotatedEntity((TypeElement)entity.getElement());
        customSQLQuery.setName(this.formatAndValidateName(name));
        String sqlString = this.parseSqlString(sql, customSQLQuery.getArgs(), entity);
        customSQLQuery.setSql(sqlString);
        customSQLQuery.setReturnPlurality(this.determineSQLReturnSignature(sqlString));
        return customSQLQuery;
    }

    private ReturnPlurality determineSQLReturnSignature(String sqlString) {
        String[] sql = sqlString.toUpperCase().split(" ");
        boolean isUnique = (sql[sql.length - 2] + " " + sql[sql.length - 1]).equals("LIMIT 1") || sql[0].equals("INSERT") || sql[0].equals("REPLACE");
        return isUnique ? ReturnPlurality.SINGLE : ReturnPlurality.BATCH;
    }

    private String parseSqlString(String sql, LinkedHashMap<String, TypeName> args, EntityDalSpec entity) {
        String lineSeparator = System.getProperty("line.separator");
        String formattedSqlString = sql.replaceAll(lineSeparator, " ").replaceAll("\\s+", " ").trim();
        String[] lexemes = formattedSqlString.split(" ");
        StringBuilder finalSql = new StringBuilder();
        for (String lexeme : lexemes) {
            Map.Entry<String, TypeName> arg = this.parseLexemeForArg(lexeme, args, entity.getEntityFieldTypes());
            if (arg != null) {
                args.putIfAbsent(arg.getKey(), arg.getValue());
                finalSql.append(" :").append(arg.getKey());
                continue;
            }
            finalSql.append(" ").append(lexeme);
        }
        return finalSql.toString().trim();
    }

    private Map.Entry<String, TypeName> parseLexemeForArg(String lexeme, Map<String, TypeName> argsSoFar, Map<String, TypeName> entityFields) {
        TypeName argType;
        if (!lexeme.contains(":")) {
            return null;
        }
        if (lexeme.contains(":::")) {
            CustomSQLQueryFactory.compilationFailureWithMessage(lexeme + " contains more than two colons, must be either two or one for valid arg syntax.", this.env);
        }
        String argName = lexeme.substring(lexeme.lastIndexOf(":") + 1).replaceAll("'", "");
        if (lexeme.contains("::")) {
            String typeNameString;
            if (argsSoFar.containsKey(argName)) {
                CustomSQLQueryFactory.compilationFailureWithMessage("sql argument name collision: " + argName, this.env);
            }
            if ((argType = this.resolvePrimitiveType(typeNameString = lexeme.substring(0, lexeme.indexOf(":")))) == null) {
                CustomSQLQueryFactory.compilationFailureWithMessage("cannot resolve type " + typeNameString + " for sql argument " + argName, this.env);
            }
        } else {
            argType = entityFields.get(argName);
            if (argType == null) {
                argType = argsSoFar.get(argName);
            }
            if (argType == null) {
                CustomSQLQueryFactory.compilationFailureWithMessage(lexeme + " is invalid syntax; must either specify type with double colon syntax or reference primitive field of annotated entity.", this.env);
            }
        }
        return Maps.immutableEntry((Object)argName, (Object)argType);
    }

    private TypeName resolvePrimitiveType(String typeNameString) {
        Class argClazz;
        boolean isList = typeNameString.endsWith("[]");
        if (isList) {
            typeNameString = typeNameString.substring(0, typeNameString.indexOf("["));
        }
        switch (typeNameString) {
            case "byte": 
            case "Byte": {
                argClazz = Byte.class;
                break;
            }
            case "short": 
            case "Short": {
                argClazz = Short.class;
                break;
            }
            case "int": 
            case "Integer": {
                argClazz = Integer.class;
                break;
            }
            case "long": 
            case "Long": {
                argClazz = Long.class;
                break;
            }
            case "float": 
            case "Float": {
                argClazz = Float.class;
                break;
            }
            case "double": 
            case "Double": {
                argClazz = Double.class;
                break;
            }
            case "boolean": 
            case "Boolean": {
                argClazz = Boolean.class;
                break;
            }
            case "char": 
            case "Character": {
                argClazz = Character.class;
                break;
            }
            case "String": {
                argClazz = String.class;
                break;
            }
            default: {
                return null;
            }
        }
        if (isList) {
            return ParameterizedTypeName.get(List.class, (Type[])new Type[]{argClazz});
        }
        return TypeName.get(argClazz);
    }

    private String formatAndValidateName(String name) {
        if (name.contains("/")) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        if ((name = name.trim()).endsWith(".sql")) {
            name = name.substring(0, name.indexOf(".sql"));
        }
        if (name.endsWith(".jpql")) {
            name = name.substring(0, name.indexOf(".jpql"));
        }
        if (!CustomSQLQueryFactory.isValidJavaIdentifier(name)) {
            CustomSQLQueryFactory.compilationFailureWithMessage(CustomSQLQueryFactory.invalidNameMessage(name), this.env);
        }
        return name;
    }

    private static void compilationFailureWithMessage(String message, ProcessingEnvironment env) {
        env.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    public static boolean isValidJavaIdentifier(String s) {
        if (s.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String invalidNameMessage(String name) {
        return name + " is not a valid java identifier. please verify that all names given to custom sql queries are valid java identifiers.";
    }

    private static Map<String, TypeName> resolveFieldTypesOf(TypeElement typeElement) {
        HashMap<String, TypeName> result = new HashMap<String, TypeName>();
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getKind().isField()) continue;
            result.put(element.getSimpleName().toString(), ClassName.get((TypeMirror)element.asType()));
        }
        return result;
    }

    private String sqlResourceToString(String resourcePath) {
        try {
            FileObject sqlFileObject = this.env.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", resourcePath);
            InputStream sqlFileStream = sqlFileObject.openInputStream();
            String raw = FileCopyUtils.copyToString((Reader)new InputStreamReader(sqlFileStream));
            Pattern commentPattern = Pattern.compile("(?:/\\*[^;]*?\\*/)|(?:--[^;]*?$)", 40);
            return commentPattern.matcher(raw).replaceAll("");
        }
        catch (IOException e) {
            CustomSQLQueryFactory.compilationFailureWithMessage(e.toString(), this.env);
            return null;
        }
    }

    public CustomSQLQueryFactory(@NonNull ProcessingEnvironment env) {
        if (env == null) {
            throw new NullPointerException("env is marked non-null but is null");
        }
        this.env = env;
    }
}

