/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.persistence;

import dev.sanda.datafi.annotations.attributes.NonApiUpdatable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.Version;
import lombok.NonNull;

@MappedSuperclass
public abstract class BasePersistableEntity<TID>
implements Serializable {
    @EmbeddedId
    @NonApiUpdatable
    @Column(name="id", unique=true, nullable=false, updatable=false)
    @NonNull
    protected TID id;
    @NonApiUpdatable
    private Boolean isFirstPersist = true;
    @Version
    @NonApiUpdatable
    private Long version = 0L;

    @PrePersist
    public void init() {
        if (this.isFirstPersist.booleanValue()) {
            this.initId();
            this.customFirstTimeInit();
            this.isFirstPersist = false;
        }
    }

    protected void customFirstTimeInit() {
    }

    public abstract void initId();

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePersistableEntity)) {
            return false;
        }
        BasePersistableEntity other = (BasePersistableEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isFirstPersist = this.getIsFirstPersist();
        Boolean other$isFirstPersist = other.getIsFirstPersist();
        if (this$isFirstPersist == null ? other$isFirstPersist != null : !((Object)this$isFirstPersist).equals(other$isFirstPersist)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TID this$id = this.getId();
        TID other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasePersistableEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isFirstPersist = this.getIsFirstPersist();
        result = result * 59 + ($isFirstPersist == null ? 43 : ((Object)$isFirstPersist).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public BasePersistableEntity(@NonNull TID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    public BasePersistableEntity() {
    }

    @NonNull
    public TID getId() {
        return this.id;
    }

    public Boolean getIsFirstPersist() {
        return this.isFirstPersist;
    }

    public Long getVersion() {
        return this.version;
    }
}

