/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.persistence;

import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Enumeration;

public class SequenceGenerator {
    private static final int TOTAL_BITS = 64;
    private static final int EPOCH_BITS = 42;
    private static final int NODE_ID_BITS = 10;
    private static final int SEQUENCE_BITS = 12;
    private static final int maxNodeId = (int)(Math.pow(2.0, 10.0) - 1.0);
    private static final int maxSequence = (int)(Math.pow(2.0, 12.0) - 1.0);
    private static final long CUSTOM_EPOCH = 1420070400000L;
    private final int nodeId;
    private long lastTimestamp = -1L;
    private long sequence = 0L;

    public SequenceGenerator(int nodeId) {
        if (nodeId < 0 || nodeId > maxNodeId) {
            throw new IllegalArgumentException(String.format("NodeId must be between %d and %d", 0, maxNodeId));
        }
        this.nodeId = nodeId;
    }

    public SequenceGenerator() {
        this.nodeId = this.createNodeId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextId() {
        long currentTimestamp = SequenceGenerator.timestamp();
        SequenceGenerator sequenceGenerator = this;
        synchronized (sequenceGenerator) {
            if (currentTimestamp < this.lastTimestamp) {
                throw new IllegalStateException("Invalid System Clock!");
            }
            if (currentTimestamp == this.lastTimestamp) {
                this.sequence = this.sequence + 1L & (long)maxSequence;
                if (this.sequence == 0L) {
                    currentTimestamp = this.waitNextMillis(currentTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = currentTimestamp;
        }
        long id = currentTimestamp << 22;
        id |= (long)(this.nodeId << 12);
        return id |= this.sequence;
    }

    private static long timestamp() {
        return Instant.now().toEpochMilli() - 1420070400000L;
    }

    private long waitNextMillis(long currentTimestamp) {
        while (currentTimestamp == this.lastTimestamp) {
            currentTimestamp = SequenceGenerator.timestamp();
        }
        return currentTimestamp;
    }

    private int createNodeId() {
        int nodeId;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] mac = networkInterface.getHardwareAddress();
                if (mac == null) continue;
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X", mac[i]));
                }
            }
            nodeId = sb.toString().hashCode();
        }
        catch (Exception ex) {
            nodeId = new SecureRandom().nextInt();
        }
        return nodeId &= maxNodeId;
    }
}

