/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.reflection.cached_type_info;

import dev.sanda.datafi.DatafiStaticUtils;
import dev.sanda.datafi.annotations.attributes.NonApiUpdatable;
import dev.sanda.datafi.annotations.attributes.NonApiUpdatables;
import dev.sanda.datafi.annotations.attributes.NonNullable;
import dev.sanda.datafi.persistence.Archivable;
import dev.sanda.datafi.reflection.cached_type_info.CachedElementCollectionField;
import dev.sanda.datafi.reflection.cached_type_info.CachedEntityField;
import dev.sanda.datafi.reflection.cached_type_info.CachedMapElementCollectionField;
import dev.sanda.datafi.reflection.relationship_synchronization.EntityRelationshipSyncronizer;
import dev.sanda.datafi.reflection.runtime_services.ReflectionCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;

public class CachedEntityTypeInfo {
    private Field idField;
    private Map<String, Field> backpointers;
    private Map<String, CachedElementCollectionField> elementCollections;
    private Map<String, CachedMapElementCollectionField> mapElementCollections;
    private EntityRelationshipSyncronizer relationshipSyncronizer;
    private Class<?> clazz;
    private Object defaultInstance;
    private Map<String, CachedEntityField> fields;
    private HashSet<String> sortKeys;
    private List<Field> cascadeUpdatableFields;
    private Map<String, Method> publicMethods;
    private List<String> searchFields;
    private boolean isArchivable = false;

    public CachedEntityTypeInfo(Class<?> clazz, Collection<Field> fields, Collection<Method> publicMethods, EntityRelationshipSyncronizer relationshipSyncronizer) {
        this.relationshipSyncronizer = relationshipSyncronizer;
        this.sortKeys = new HashSet();
        this.elementCollections = new HashMap<String, CachedElementCollectionField>();
        this.backpointers = new HashMap<String, Field>();
        HashSet blacklistedBackpointers = new HashSet();
        this.mapElementCollections = new HashMap<String, CachedMapElementCollectionField>();
        this.clazz = clazz;
        if (Archivable.class.isAssignableFrom(clazz)) {
            this.isArchivable = true;
        }
        this.fields = new HashMap<String, CachedEntityField>();
        fields.forEach(field -> {
            field.setAccessible(true);
            boolean isCollectionOrMap = this.isCollectionOrMap((Field)field);
            boolean isNonApiUpdatable = this.isNonApiUpdatable((Field)field);
            boolean isNonNullable = this.isNonNullableField((Field)field);
            String fieldName = field.getName();
            if (this.isEmbeddedOrForeignKey((Field)field)) {
                this.addNestedSortKeys((Field)field, fieldName + ".", new Stack());
            }
            this.fields.put(fieldName, new CachedEntityField((Field)field, isCollectionOrMap, isNonApiUpdatable, isNonNullable));
            this.sortKeys.add(fieldName);
            if (field.isAnnotationPresent(Id.class) || field.isAnnotationPresent(EmbeddedId.class)) {
                this.idField = field;
            }
            if (field.isAnnotationPresent(ElementCollection.class)) {
                Class<?> fieldType = field.getType();
                if (Map.class.isAssignableFrom(fieldType)) {
                    this.mapElementCollections.put(fieldName, new CachedMapElementCollectionField((Field)field));
                } else if (Collection.class.isAssignableFrom(fieldType)) {
                    this.elementCollections.put(fieldName, new CachedElementCollectionField((Field)field));
                }
            }
            if (field.isAnnotationPresent(ManyToOne.class) && !blacklistedBackpointers.contains(field.getType())) {
                Class<?> fieldClazz = field.getType();
                String fieldClazzName = fieldClazz.getSimpleName();
                if (this.backpointers.containsKey(fieldClazzName)) {
                    this.backpointers.remove(fieldClazzName);
                    blacklistedBackpointers.add(fieldClazz);
                } else {
                    this.backpointers.put(fieldClazzName, (Field)field);
                }
            }
        });
        this.publicMethods = new HashMap<String, Method>();
        publicMethods.forEach(publicMethod -> this.publicMethods.put(publicMethod.getName(), (Method)publicMethod));
        this.defaultInstance = CachedEntityTypeInfo.genDefaultInstance(clazz);
        this.setCascadeUpdatableFields();
    }

    private boolean isEmbeddedOrForeignKey(Field field) {
        return DatafiStaticUtils.hasOneOfAnnotations(field, EmbeddedId.class, Embedded.class, ManyToOne.class, OneToOne.class);
    }

    public String toFlatJson(Object instance) {
        StringBuilder builder = new StringBuilder("{");
        this.fields.entrySet().stream().filter(entry -> ((CachedEntityField)entry.getValue()).getJsonValue(instance) != null && !((CachedEntityField)entry.getValue()).isCollectionOrMap()).map(entry -> "\"" + (String)entry.getKey() + "\": " + ((CachedEntityField)entry.getValue()).getJsonValue(instance).toString()).forEach(jsonKeyValuePair -> builder.append((String)jsonKeyValuePair).append(","));
        builder.setLength(builder.length() - 1);
        builder.append("}");
        return builder.toString();
    }

    private boolean isCollectionOrMap(Field field) {
        return Iterable.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType());
    }

    private void addNestedSortKeys(Field currentRoot, String currentPrefix, Stack<Class<?>> typesSoFar) {
        Class<?> currentRootType = currentRoot.getType();
        if (typesSoFar.contains(currentRootType)) {
            return;
        }
        typesSoFar.push(currentRootType);
        ReflectionCache.getClassFields(currentRootType).forEach(field -> {
            if (this.isEmbeddedOrForeignKey((Field)field)) {
                this.addNestedSortKeys((Field)field, currentPrefix + field.getName() + ".", typesSoFar);
            }
            String fieldName = currentPrefix + field.getName();
            this.sortKeys.add(fieldName);
        });
        typesSoFar.pop();
    }

    private boolean isNonApiUpdatable(Field field) {
        return field.isAnnotationPresent(NonApiUpdatable.class) || this.isInNonCascadeUpdatables(field) || field.isAnnotationPresent(Id.class) || field.isAnnotationPresent(EmbeddedId.class) || Iterable.class.isAssignableFrom(field.getType()) || field.isAnnotationPresent(ElementCollection.class) || field.isAnnotationPresent(CollectionTable.class) || field.getType().equals(Map.class);
    }

    private boolean isInNonCascadeUpdatables(Field field) {
        NonApiUpdatables nonApiUpdatables = this.clazz.getAnnotation(NonApiUpdatables.class);
        if (nonApiUpdatables != null) {
            for (String fieldName : nonApiUpdatables.value()) {
                if (!fieldName.equals(field.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNonNullableField(Field field) {
        return field.isAnnotationPresent(NonNullable.class) || field.isAnnotationPresent(Column.class) && !field.getAnnotation(Column.class).nullable() || field.isAnnotationPresent(OneToOne.class) && !field.getAnnotation(OneToOne.class).optional() || field.isAnnotationPresent(ManyToOne.class) && !field.getAnnotation(ManyToOne.class).optional();
    }

    public static Object genDefaultInstance(Class<?> clazz) {
        Constructor<?>[] cons = clazz.getDeclaredConstructors();
        try {
            for (Constructor<?> constructor : cons) {
                if (constructor.getParameterCount() != 0) continue;
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            throw new RuntimeException("No default constructor found for " + clazz.getSimpleName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setCascadeUpdatableFields() {
        this.cascadeUpdatableFields = new ArrayList<Field>();
        this.fields.values().forEach(_field -> {
            if (!_field.isNonApiUpdatable()) {
                this.cascadeUpdatableFields.add(_field.getField());
            }
        });
    }

    public Object getId(Object instance) {
        try {
            return this.idField.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void addAllToElementCollection(String fieldName, Object instance, Collection<Object> toAdd) {
    }

    public Field getIdField() {
        return this.idField;
    }

    public Map<String, Field> getBackpointers() {
        return this.backpointers;
    }

    public Map<String, CachedElementCollectionField> getElementCollections() {
        return this.elementCollections;
    }

    public Map<String, CachedMapElementCollectionField> getMapElementCollections() {
        return this.mapElementCollections;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Object getDefaultInstance() {
        return this.defaultInstance;
    }

    public Map<String, CachedEntityField> getFields() {
        return this.fields;
    }

    public HashSet<String> getSortKeys() {
        return this.sortKeys;
    }

    public List<Field> getCascadeUpdatableFields() {
        return this.cascadeUpdatableFields;
    }

    public Map<String, Method> getPublicMethods() {
        return this.publicMethods;
    }

    public List<String> getSearchFields() {
        return this.searchFields;
    }

    public boolean isArchivable() {
        return this.isArchivable;
    }

    public EntityRelationshipSyncronizer getRelationshipSyncronizer() {
        return this.relationshipSyncronizer;
    }
}

