/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.reflection.relationship_synchronization;

import dev.sanda.datafi.DatafiStaticUtils;
import dev.sanda.datafi.annotations.attributes.AutoSynchronized;
import dev.sanda.datafi.reflection.cached_type_info.CachedEntityTypeInfo;
import dev.sanda.datafi.reflection.relationship_synchronization.BackpointerType;
import dev.sanda.datafi.reflection.runtime_services.CollectionsTypeResolver;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRelationshipSyncronizer {
    private static final Logger log = LoggerFactory.getLogger(EntityRelationshipSyncronizer.class);
    private Class clazz;
    private Class apiSpec;
    private CollectionsTypeResolver collectionsTypeResolver;
    private Map<String, Map<String, Field>> manyToOneBackpointers;
    private Map<String, Map<String, Field>> manyToManyBackpointers;
    private Map<String, Map<String, Field>> oneToManyBackpointers;
    private Map<String, Map<String, Field>> oneToOneBackpointers;
    Map<String, Method> apiSpecGettersByFieldName;

    public boolean trySetBackpointer(Field sourceField, Object thisInstance, Object toPointTo) {
        try {
            BackpointerType backpointerType = this.resolveBackpointerType(sourceField);
            boolean success = false;
            String fieldTypeName = toPointTo.getClass().getSimpleName();
            switch (Objects.requireNonNull(backpointerType)) {
                case ONE_TO_MANY: {
                    if (!this.oneToManyBackpointers.containsKey(fieldTypeName)) break;
                    Field targetField = this.getTargetField(sourceField, fieldTypeName, this.oneToManyBackpointers);
                    Collection targetFieldValue = this.getOrInstantiateCollection(targetField, thisInstance);
                    targetFieldValue.add(toPointTo);
                    success = true;
                    break;
                }
                case MANY_TO_MANY: {
                    if (!this.manyToManyBackpointers.containsKey(fieldTypeName)) break;
                    Field targetField = this.getTargetField(sourceField, fieldTypeName, this.manyToManyBackpointers);
                    Collection targetFieldValue = this.getOrInstantiateCollection(targetField, thisInstance);
                    targetFieldValue.add(toPointTo);
                    success = true;
                    break;
                }
                case MANY_TO_ONE: {
                    if (!this.manyToOneBackpointers.containsKey(fieldTypeName)) break;
                    Field targetField = this.getTargetField(sourceField, fieldTypeName, this.manyToOneBackpointers);
                    targetField.set(thisInstance, toPointTo);
                    success = true;
                }
                case ONE_TO_ONE: {
                    if (!this.oneToOneBackpointers.containsKey(fieldTypeName)) break;
                    Field targetField = this.getTargetField(sourceField, fieldTypeName, this.oneToOneBackpointers);
                    targetField.set(thisInstance, toPointTo);
                    success = true;
                }
            }
            return success;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private BackpointerType resolveBackpointerType(Field sourceField) {
        if (sourceField.isAnnotationPresent(ManyToOne.class)) {
            return BackpointerType.ONE_TO_MANY;
        }
        if (sourceField.isAnnotationPresent(OneToMany.class)) {
            return BackpointerType.MANY_TO_ONE;
        }
        if (sourceField.isAnnotationPresent(ManyToMany.class)) {
            return BackpointerType.MANY_TO_MANY;
        }
        if (sourceField.isAnnotationPresent(OneToOne.class)) {
            return BackpointerType.ONE_TO_ONE;
        }
        throw new RuntimeException("This code in EntityRelationshipsSyncronizer.resolveBackpointerType should never have been reached... Congratulations.");
    }

    public EntityRelationshipSyncronizer(Class clazz, Class<?> apiSpec, CollectionsTypeResolver collectionsTypeResolver) {
        this.clazz = clazz;
        this.apiSpec = apiSpec;
        this.collectionsTypeResolver = collectionsTypeResolver;
        this.manyToOneBackpointers = new HashMap<String, Map<String, Field>>();
        this.manyToManyBackpointers = new HashMap<String, Map<String, Field>>();
        this.oneToManyBackpointers = new HashMap<String, Map<String, Field>>();
        this.oneToOneBackpointers = new HashMap<String, Map<String, Field>>();
        this.apiSpecGettersByFieldName = new HashMap<String, Method>();
        this.populateBackpointerMaps();
    }

    private void populateBackpointerMaps() {
        HashSet<String> blackListedManyToOneBackpointers = new HashSet<String>();
        HashSet<String> blackListedManyToManyBackpointers = new HashSet<String>();
        HashSet<String> blackListedOneToManyBackpointers = new HashSet<String>();
        HashSet<String> blackListedOneToOneBackpointers = new HashSet<String>();
        for (Map.Entry<Field, String> entry : this.getFieldsMap().entrySet()) {
            Field field = entry.getKey();
            if (field.isAnnotationPresent(ManyToOne.class)) {
                this.setBackpointerForAnnotationType(field, entry.getValue(), ManyToOne.class, blackListedManyToOneBackpointers, this.manyToOneBackpointers);
                continue;
            }
            if (field.isAnnotationPresent(ManyToMany.class)) {
                this.setBackpointerForAnnotationType(field, entry.getValue(), ManyToMany.class, blackListedManyToManyBackpointers, this.manyToManyBackpointers);
                continue;
            }
            if (field.isAnnotationPresent(OneToMany.class)) {
                this.setBackpointerForAnnotationType(field, entry.getValue(), OneToMany.class, blackListedOneToManyBackpointers, this.oneToManyBackpointers);
                continue;
            }
            if (!field.isAnnotationPresent(OneToOne.class)) continue;
            this.setBackpointerForAnnotationType(field, entry.getValue(), OneToOne.class, blackListedOneToOneBackpointers, this.oneToOneBackpointers);
        }
    }

    private Map<Field, String> getFieldsMap() {
        Map fieldsByPascalCaseName = Arrays.stream(this.clazz.getDeclaredFields()).collect(Collectors.toMap(field -> DatafiStaticUtils.toPascalCase(field.getName()), Function.identity()));
        if (this.apiSpec == null) {
            return Arrays.stream(this.clazz.getDeclaredFields()).filter(field -> !this.isIrrelevantField((Field)field)).collect(Collectors.toMap(Function.identity(), field -> this.isExplicitlyScoped((Field)field, null) ? field.getAnnotation(AutoSynchronized.class).referencedBy() : ""));
        }
        this.apiSpecGettersByFieldName = Arrays.stream(this.apiSpec.getDeclaredMethods()).filter(method -> method.getName().startsWith("get") && fieldsByPascalCaseName.containsKey(method.getName().replaceFirst("get", ""))).collect(Collectors.toMap(method -> ((Field)fieldsByPascalCaseName.get(method.getName().replaceFirst("get", ""))).getName(), Function.identity()));
        return Arrays.stream(this.clazz.getDeclaredFields()).filter(field -> !this.isIrrelevantField((Field)field, this.apiSpecGettersByFieldName.get(field.getName()))).collect(Collectors.toMap(Function.identity(), field -> this.isExplicitlyScoped((Field)field, this.apiSpecGettersByFieldName.get(field.getName())) ? this.getAnnotationInstance((Field)field, this.apiSpecGettersByFieldName.get(field.getName())).referencedBy() : ""));
    }

    private boolean isIrrelevantField(Field field) {
        return this.isIrrelevantField(field, null);
    }

    private boolean isIrrelevantField(Field field, Method apiSpecGetter) {
        return Map.class.isAssignableFrom(field.getType()) || !field.isAnnotationPresent(AutoSynchronized.class) && !field.getDeclaringClass().isAnnotationPresent(AutoSynchronized.class) && (apiSpecGetter == null || !apiSpecGetter.isAnnotationPresent(AutoSynchronized.class)) && (apiSpecGetter == null || !apiSpecGetter.getDeclaringClass().isAnnotationPresent(AutoSynchronized.class));
    }

    private void setBackpointerForAnnotationType(Field field, String toField, Class annotationType, Set<String> blacklist, Map<String, Map<String, Field>> backpointers) {
        String typeName = this.resolveFieldTypeName(field);
        if (field.isAnnotationPresent(annotationType) && !blacklist.contains(typeName)) {
            if (backpointers.containsKey(typeName) && !this.isExplicitlyScoped(field, this.apiSpecGettersByFieldName.get(field.getName()))) {
                throw new RuntimeException("Entity of type " + this.clazz.getSimpleName() + " contains multiple instances of @AutoSynchronized annotation on fields: \"" + field.getName() + "\" and \"" + backpointers.get(typeName).entrySet().iterator().next().getValue().getName() + "\" for same referenced type \"" + typeName + "\".If this is intentional, be sure to set the 'referencedBy' parameter on each annotation instance so as to remove unresolvable ambiguity as to which field the @AutoSynchronized annotation instances are each respectively intended to be referring to.");
            }
            field.setAccessible(true);
            if (!backpointers.containsKey(typeName)) {
                backpointers.put(typeName, new HashMap());
            }
            backpointers.get(typeName).put(toField, field);
        }
    }

    private boolean isExplicitlyScoped(Field field, Method apiSpecGetter) {
        AutoSynchronized annotationInstance = this.getAnnotationInstance(field, apiSpecGetter);
        return annotationInstance != null && !annotationInstance.referencedBy().equals("");
    }

    private AutoSynchronized getAnnotationInstance(Field field, Method apiSpecGetter) {
        if (apiSpecGetter != null) {
            return apiSpecGetter.isAnnotationPresent(AutoSynchronized.class) ? apiSpecGetter.getAnnotation(AutoSynchronized.class) : field.getAnnotation(AutoSynchronized.class);
        }
        return field.getAnnotation(AutoSynchronized.class);
    }

    private Field getTargetField(Field sourceField, String fieldTypeName, Map<String, Map<String, Field>> backpointersMap) {
        return backpointersMap.size() == 1 ? backpointersMap.get(fieldTypeName).entrySet().iterator().next().getValue() : backpointersMap.get(fieldTypeName).get(sourceField.getName());
    }

    private String resolveFieldTypeName(Field field) {
        return this.resolveFieldType(field).getSimpleName();
    }

    private Class resolveFieldType(Field field) {
        Class<?> type = field.getType();
        if (!Collection.class.isAssignableFrom(type)) {
            return type;
        }
        return this.collectionsTypeResolver.resolveFor(this.clazz.getSimpleName() + "." + field.getName());
    }

    private Collection getOrInstantiateCollection(Field targetField, Object thisInstance) throws IllegalAccessException {
        Object rawValue = targetField.get(thisInstance);
        return rawValue != null ? (Collection)rawValue : this.instantiateCollection(targetField, thisInstance);
    }

    private Collection instantiateCollection(Field field, Object thisInstance) throws IllegalAccessException {
        Class<?> collectionType = field.getType();
        AbstractCollection resultValue = null;
        if (Modifier.isInterface(collectionType.getModifiers())) {
            if (collectionType.equals(Collection.class)) {
                resultValue = new HashSet();
            } else if (collectionType.equals(Set.class)) {
                resultValue = new HashSet();
            } else if (collectionType.equals(List.class)) {
                resultValue = new ArrayList();
            } else if (collectionType.equals(Queue.class)) {
                resultValue = new LinkedList();
            } else if (collectionType.equals(Deque.class)) {
                resultValue = new ArrayDeque();
            }
        } else {
            resultValue = (HashSet)CachedEntityTypeInfo.genDefaultInstance(collectionType);
        }
        field.set(thisInstance, resultValue);
        return (Collection)field.get(thisInstance);
    }

    public Class getClazz() {
        return this.clazz;
    }

    public Class getApiSpec() {
        return this.apiSpec;
    }

    public CollectionsTypeResolver getCollectionsTypeResolver() {
        return this.collectionsTypeResolver;
    }

    public Map<String, Map<String, Field>> getManyToOneBackpointers() {
        return this.manyToOneBackpointers;
    }

    public Map<String, Map<String, Field>> getManyToManyBackpointers() {
        return this.manyToManyBackpointers;
    }

    public Map<String, Map<String, Field>> getOneToManyBackpointers() {
        return this.oneToManyBackpointers;
    }

    public Map<String, Map<String, Field>> getOneToOneBackpointers() {
        return this.oneToOneBackpointers;
    }

    public Map<String, Method> getApiSpecGettersByFieldName() {
        return this.apiSpecGettersByFieldName;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public void setApiSpec(Class apiSpec) {
        this.apiSpec = apiSpec;
    }

    public void setCollectionsTypeResolver(CollectionsTypeResolver collectionsTypeResolver) {
        this.collectionsTypeResolver = collectionsTypeResolver;
    }

    public void setManyToOneBackpointers(Map<String, Map<String, Field>> manyToOneBackpointers) {
        this.manyToOneBackpointers = manyToOneBackpointers;
    }

    public void setManyToManyBackpointers(Map<String, Map<String, Field>> manyToManyBackpointers) {
        this.manyToManyBackpointers = manyToManyBackpointers;
    }

    public void setOneToManyBackpointers(Map<String, Map<String, Field>> oneToManyBackpointers) {
        this.oneToManyBackpointers = oneToManyBackpointers;
    }

    public void setOneToOneBackpointers(Map<String, Map<String, Field>> oneToOneBackpointers) {
        this.oneToOneBackpointers = oneToOneBackpointers;
    }

    public void setApiSpecGettersByFieldName(Map<String, Method> apiSpecGettersByFieldName) {
        this.apiSpecGettersByFieldName = apiSpecGettersByFieldName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityRelationshipSyncronizer)) {
            return false;
        }
        EntityRelationshipSyncronizer other = (EntityRelationshipSyncronizer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class this$clazz = this.getClazz();
        Class other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        Class this$apiSpec = this.getApiSpec();
        Class other$apiSpec = other.getApiSpec();
        if (this$apiSpec == null ? other$apiSpec != null : !this$apiSpec.equals(other$apiSpec)) {
            return false;
        }
        CollectionsTypeResolver this$collectionsTypeResolver = this.getCollectionsTypeResolver();
        CollectionsTypeResolver other$collectionsTypeResolver = other.getCollectionsTypeResolver();
        if (this$collectionsTypeResolver == null ? other$collectionsTypeResolver != null : !this$collectionsTypeResolver.equals(other$collectionsTypeResolver)) {
            return false;
        }
        Map<String, Map<String, Field>> this$manyToOneBackpointers = this.getManyToOneBackpointers();
        Map<String, Map<String, Field>> other$manyToOneBackpointers = other.getManyToOneBackpointers();
        if (this$manyToOneBackpointers == null ? other$manyToOneBackpointers != null : !((Object)this$manyToOneBackpointers).equals(other$manyToOneBackpointers)) {
            return false;
        }
        Map<String, Map<String, Field>> this$manyToManyBackpointers = this.getManyToManyBackpointers();
        Map<String, Map<String, Field>> other$manyToManyBackpointers = other.getManyToManyBackpointers();
        if (this$manyToManyBackpointers == null ? other$manyToManyBackpointers != null : !((Object)this$manyToManyBackpointers).equals(other$manyToManyBackpointers)) {
            return false;
        }
        Map<String, Map<String, Field>> this$oneToManyBackpointers = this.getOneToManyBackpointers();
        Map<String, Map<String, Field>> other$oneToManyBackpointers = other.getOneToManyBackpointers();
        if (this$oneToManyBackpointers == null ? other$oneToManyBackpointers != null : !((Object)this$oneToManyBackpointers).equals(other$oneToManyBackpointers)) {
            return false;
        }
        Map<String, Map<String, Field>> this$oneToOneBackpointers = this.getOneToOneBackpointers();
        Map<String, Map<String, Field>> other$oneToOneBackpointers = other.getOneToOneBackpointers();
        if (this$oneToOneBackpointers == null ? other$oneToOneBackpointers != null : !((Object)this$oneToOneBackpointers).equals(other$oneToOneBackpointers)) {
            return false;
        }
        Map<String, Method> this$apiSpecGettersByFieldName = this.getApiSpecGettersByFieldName();
        Map<String, Method> other$apiSpecGettersByFieldName = other.getApiSpecGettersByFieldName();
        return !(this$apiSpecGettersByFieldName == null ? other$apiSpecGettersByFieldName != null : !((Object)this$apiSpecGettersByFieldName).equals(other$apiSpecGettersByFieldName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityRelationshipSyncronizer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        Class $apiSpec = this.getApiSpec();
        result = result * 59 + ($apiSpec == null ? 43 : $apiSpec.hashCode());
        CollectionsTypeResolver $collectionsTypeResolver = this.getCollectionsTypeResolver();
        result = result * 59 + ($collectionsTypeResolver == null ? 43 : $collectionsTypeResolver.hashCode());
        Map<String, Map<String, Field>> $manyToOneBackpointers = this.getManyToOneBackpointers();
        result = result * 59 + ($manyToOneBackpointers == null ? 43 : ((Object)$manyToOneBackpointers).hashCode());
        Map<String, Map<String, Field>> $manyToManyBackpointers = this.getManyToManyBackpointers();
        result = result * 59 + ($manyToManyBackpointers == null ? 43 : ((Object)$manyToManyBackpointers).hashCode());
        Map<String, Map<String, Field>> $oneToManyBackpointers = this.getOneToManyBackpointers();
        result = result * 59 + ($oneToManyBackpointers == null ? 43 : ((Object)$oneToManyBackpointers).hashCode());
        Map<String, Map<String, Field>> $oneToOneBackpointers = this.getOneToOneBackpointers();
        result = result * 59 + ($oneToOneBackpointers == null ? 43 : ((Object)$oneToOneBackpointers).hashCode());
        Map<String, Method> $apiSpecGettersByFieldName = this.getApiSpecGettersByFieldName();
        result = result * 59 + ($apiSpecGettersByFieldName == null ? 43 : ((Object)$apiSpecGettersByFieldName).hashCode());
        return result;
    }

    public String toString() {
        return "EntityRelationshipSyncronizer(clazz=" + this.getClazz() + ", apiSpec=" + this.getApiSpec() + ", collectionsTypeResolver=" + this.getCollectionsTypeResolver() + ", manyToOneBackpointers=" + this.getManyToOneBackpointers() + ", manyToManyBackpointers=" + this.getManyToManyBackpointers() + ", oneToManyBackpointers=" + this.getOneToManyBackpointers() + ", oneToOneBackpointers=" + this.getOneToOneBackpointers() + ", apiSpecGettersByFieldName=" + this.getApiSpecGettersByFieldName() + ")";
    }
}

