/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.reflection.runtime_services;

import dev.sanda.datafi.reflection.cached_type_info.CachedEntityTypeInfo;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.stereotype.Component;

@Component
public class CollectionInstantiator {
    private final Reflections javaUtils = new Reflections("java.util", new Scanner[0]);
    private final Map<Class<? extends Collection>, List<Class<? extends Collection>>> collectionTypes = new HashMap<Class<? extends Collection>, List<Class<? extends Collection>>>();
    private final Map<Map.Entry<Class<?>, Class<?>>, Class<?>> cache = new HashMap();

    @PostConstruct
    private void init() {
        Set allCollectionTypes = this.javaUtils.getSubTypesOf(Collection.class);
        Collection collectionInterfaces = allCollectionTypes.stream().filter(Class::isInterface).collect(Collectors.toList());
        Collection collectionImplementations = allCollectionTypes.stream().filter(type -> !type.isInterface()).collect(Collectors.toList());
        for (Class collectionInterface : collectionInterfaces) {
            this.collectionTypes.put(collectionInterface, new ArrayList());
            for (Class collectionImplementation : collectionImplementations) {
                if (!collectionInterface.isAssignableFrom(collectionImplementation)) continue;
                this.collectionTypes.get(collectionInterface).add(collectionImplementation);
            }
        }
    }

    public Collection instantiateCollection(Class<?> collectionType) {
        if (Modifier.isInterface(collectionType.getModifiers())) {
            if (collectionType.equals(Collection.class)) {
                return new HashSet();
            }
            if (collectionType.equals(Set.class)) {
                return new HashSet();
            }
            if (collectionType.equals(List.class)) {
                return new ArrayList();
            }
            if (collectionType.equals(Queue.class)) {
                return new LinkedList();
            }
            if (collectionType.equals(Deque.class)) {
                return new ArrayDeque();
            }
        }
        return (Collection)CachedEntityTypeInfo.genDefaultInstance(collectionType);
    }
}

