/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.reflection.runtime_services;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.sanda.datafi.DatafiStaticUtils;
import dev.sanda.datafi.annotations.EntityApiSpec;
import dev.sanda.datafi.code_generator.BasePackageResolver;
import dev.sanda.datafi.reflection.cached_type_info.CachedEntityTypeInfo;
import dev.sanda.datafi.reflection.relationship_synchronization.EntityRelationshipSyncronizer;
import dev.sanda.datafi.reflection.runtime_services.CollectionsTypeResolver;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.NonNull;
import org.reflections.Reflections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReflectionCache {
    private Reflections reflections;
    private Map<String, CachedEntityTypeInfo> entitiesCache;
    private Map<Map.Entry<String, Class<?>[]>, Method> resolversCache;
    @Autowired
    private CollectionsTypeResolver collectionsTypeResolver;
    @Autowired
    private BasePackageResolver basePackageResolver;

    @PostConstruct
    private void init() {
        this.reflections = new Reflections(new Object[]{this.basePackageResolver.getBasePackages()});
        this.entitiesCache = new HashMap<String, CachedEntityTypeInfo>();
        this.resolversCache = new HashMap<Map.Entry<String, Class<?>[]>, Method>();
        Set<Class<?>> dataModelEntityTypes = this.getAnnotatedEntities();
        Map<Class<?>, Class<?>> dataModelEntityTypeApiSpecs = this.getAnnotatedEntityTypeApiSpecs();
        for (Class<?> currentType : dataModelEntityTypes) {
            if (!this.isPersistableEntity(currentType)) continue;
            this.entitiesCache.put(currentType.getSimpleName(), new CachedEntityTypeInfo(currentType, ReflectionCache.getClassFields(currentType), this.getPublicMethodsOf(currentType), new EntityRelationshipSyncronizer(currentType, dataModelEntityTypeApiSpecs.get(currentType), this.collectionsTypeResolver)));
        }
    }

    private boolean isPersistableEntity(Class<?> currentType) {
        return currentType.isAnnotationPresent(Table.class) || currentType.isAnnotationPresent(Entity.class);
    }

    private Set<Class<?>> getAnnotatedEntities() {
        Set entities = this.reflections.getTypesAnnotatedWith(Entity.class);
        entities.addAll(this.reflections.getTypesAnnotatedWith(Table.class));
        entities = Sets.newHashSet((Iterable)entities);
        return entities;
    }

    private Map<Class<?>, Class<?>> getAnnotatedEntityTypeApiSpecs() {
        return this.reflections.getTypesAnnotatedWith(EntityApiSpec.class).stream().filter(clazz -> DatafiStaticUtils.hasOneOfAnnotations(clazz.getSuperclass(), Entity.class, Table.class)).collect(Collectors.toMap(Class::getSuperclass, Function.identity()));
    }

    private Collection<Method> getPublicMethodsOf(@NonNull Class<?> startClass) {
        if (startClass == null) {
            throw new NullPointerException("startClass is marked non-null but is null");
        }
        ArrayList currentClassMethods = Lists.newArrayList((Object[])startClass.getMethods());
        Class<?> parentClass = startClass.getSuperclass();
        if (parentClass != null) {
            List parentClassFields = (List)this.getPublicMethodsOf(parentClass);
            currentClassMethods.addAll(parentClassFields);
        }
        return currentClassMethods;
    }

    public static Collection<Field> getClassFields(@NonNull Class<?> startClass) {
        if (startClass == null) {
            throw new NullPointerException("startClass is marked non-null but is null");
        }
        ArrayList currentClassFields = Lists.newArrayList((Object[])startClass.getDeclaredFields());
        Class<?> parentClass = startClass.getSuperclass();
        if (parentClass != null) {
            List parentClassFields = (List)ReflectionCache.getClassFields(parentClass);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    public Object getIdOf(String clazzName, Object instance) {
        return this.entitiesCache.get(clazzName).getId(instance);
    }

    public Map<String, CachedEntityTypeInfo> getEntitiesCache() {
        return this.entitiesCache;
    }

    public Map<Map.Entry<String, Class<?>[]>, Method> getResolversCache() {
        return this.resolversCache;
    }
}

