/*
 * Decompiled with CFR 0.152.
 */
package dev.sanda.datafi.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.sanda.datafi.DatafiStaticUtils;
import dev.sanda.datafi.dto.FreeTextSearchPageRequest;
import dev.sanda.datafi.persistence.Archivable;
import dev.sanda.datafi.persistence.GenericDao;
import dev.sanda.datafi.reflection.cached_type_info.CachedEntityTypeInfo;
import dev.sanda.datafi.reflection.runtime_services.ReflectionCache;
import dev.sanda.datafi.service.DaoCollector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import lombok.NonNull;
import org.apache.commons.collections4.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DataManager<T> {
    private static final Logger log = LoggerFactory.getLogger(DataManager.class);
    @Autowired
    private EntityManager entityManager;
    @NonNull
    private Class<T> clazz;
    private String clazzSimpleName;
    private String clazzSimpleNamePlural;
    private String idTypeSimpleName;
    private CachedEntityTypeInfo cachedEntityTypeInfo;
    @Autowired
    protected ReflectionCache reflectionCache;
    @Value(value="#{new Boolean('${datafi.logging-enabled:true}')}")
    private Boolean loggingEnabled;
    private Map<String, GenericDao> daoMap;
    private GenericDao dao;
    @Autowired
    private DaoCollector daoCollector;

    public void setType(Class<T> clazz) {
        this.clazz = clazz;
        this.setClazzSimpleName(clazz);
        this.dao = this.daoMap.get(this.clazzSimpleName);
        this.cachedEntityTypeInfo = this.reflectionCache.getEntitiesCache().get(this.clazzSimpleName);
    }

    @PostConstruct
    private void init() {
        this.setClazzSimpleName(this.clazz);
        log.trace("Running @PostConstruct init method for DataManager<{}>", (Object)this.clazzSimpleName);
        this.daoMap = DatafiStaticUtils.toServicesMap(this.daoCollector.getDaos(), "Dao");
        if (this.clazz != null) {
            this.setType(this.clazz);
        }
    }

    private void setClazzSimpleName(Class<T> clazz) {
        this.clazzSimpleName = this.clazz != null ? this.clazz.getSimpleName() : "Object";
        this.clazzSimpleNamePlural = DatafiStaticUtils.toPlural(this.clazzSimpleName);
        this.idTypeSimpleName = this.clazz != null ? this.reflectionCache.getEntitiesCache().get(this.clazzSimpleName).getIdField().getType().getSimpleName() : "Object";
    }

    private void logTrace(String method, String msg, Object ... args) {
        if (!this.loggingEnabled.booleanValue()) {
            return;
        }
        log.trace("DataManager<{}>." + method + " " + msg, (Object)this.clazzSimpleName, (Object)args);
    }

    private void logInfo(String method, String msg, Object ... args) {
        if (!this.loggingEnabled.booleanValue()) {
            return;
        }
        log.info("DataManager<{}>." + method + " " + msg, (Object)this.clazzSimpleName, (Object)args);
    }

    private void logError(String method, String msg, Object ... args) {
        if (!this.loggingEnabled.booleanValue()) {
            return;
        }
        log.error("DataManager<{}>." + method + " " + msg, (Object)this.clazzSimpleName, (Object)args);
    }

    public List<T> findAll() {
        List all = this.dao.findAll();
        this.logInfo("findAll()", "fetched {} {}", all.size(), this.clazzSimpleNamePlural);
        return all;
    }

    public EntityManager entityManager() {
        return this.entityManager;
    }

    public List<T> findAll(Sort sort) {
        List all = this.dao.findAll(sort);
        this.logInfo("findAll(Sort sort)", "fetched {} {}, sorted by {}", all.size(), this.clazzSimpleNamePlural, sort.toString());
        return all;
    }

    public Page findAll(Pageable pageable) {
        Page all = this.dao.findAll(pageable);
        this.logInfo("findAll(Pageable pageable)", "fetched {} {}, in {} pages", all.getTotalElements(), this.clazzSimpleNamePlural, all.getTotalPages());
        return all;
    }

    public List<T> findAllById(Iterable<?> iterable) {
        List allById = this.dao.findAllById(iterable);
        this.logInfo("findAllById(Iterable<{}> iterable)", "fetched {} {} by id", this.idTypeSimpleName, allById.size(), this.clazzSimpleNamePlural);
        return allById;
    }

    public long count() {
        long count = this.dao.count();
        this.logInfo("count()", "counted a total of {} {}", count, this.clazzSimpleNamePlural);
        return count;
    }

    public void deleteById(Object id) {
        this.dao.deleteById(id);
        this.logInfo("deleteById({} id)", "deleted {} by id {}", this.idTypeSimpleName, this.clazzSimpleName, id);
    }

    public void delete(T t) {
        this.dao.delete(t);
        this.logInfo("delete({} {})", "deleted {} with id {}", this.clazzSimpleName, DatafiStaticUtils.toCamelCase(this.clazzSimpleName), this.clazzSimpleName, this.reflectionCache.getEntitiesCache().get(this.clazzSimpleName).getId(t));
    }

    public void deleteAll(Iterable<? extends T> iterable) {
        this.dao.deleteAll(iterable);
        this.logInfo("deleteAll(Iterable<{}> iterable)", "deleted {} {}", this.clazzSimpleName, Lists.newArrayList(iterable).size(), this.clazzSimpleNamePlural);
    }

    public void deleteAll() {
        long count = this.count();
        this.dao.deleteAll();
        this.logInfo("deleteAll()", "deleted all {} {}", count, this.clazzSimpleNamePlural);
    }

    public <S extends T> S save(S s) {
        Object saved = this.dao.save(s);
        this.logInfo("save({} {})", "saved {}: {}", this.clazzSimpleName, DatafiStaticUtils.toCamelCase(this.clazzSimpleName), this.clazzSimpleName, s.toString());
        return (S)saved;
    }

    public <S extends T> List<S> saveAll(Iterable<S> iterable) {
        List list = this.dao.saveAll(iterable);
        this.logInfo("saveAll(Iterable<{}> iterable)", "saved {} {}", this.clazzSimpleName, list.size(), this.clazzSimpleNamePlural);
        return list;
    }

    public <S extends T> List<S> saveAllAndFlush(Iterable<S> iterable) {
        List list = this.dao.saveAll(iterable);
        this.dao.flush();
        this.logInfo("saveAll(Iterable<{}> iterable)", "saved {} {}", this.clazzSimpleName, list.size(), this.clazzSimpleNamePlural);
        return list;
    }

    public Optional<T> findById(Object id) {
        Optional o = this.dao.findById(id);
        this.logInfo("findById({} id)", o.isPresent() ? "fetched {} by id {}" : "could not find {} by id {}", this.idTypeSimpleName, this.clazzSimpleName, id);
        return o;
    }

    public boolean existsById(Object id) {
        boolean exists = this.dao.existsById(id);
        this.logInfo("existsById({} id)", exists ? "validated existence of {} by id {}" : "determined non-existence of {} by id {}", this.idTypeSimpleName, this.clazzSimpleName, id);
        return exists;
    }

    public void flush() {
        this.dao.flush();
        this.logTrace("flush()", "flushed JpaRepository persistence context", new Object[0]);
    }

    public <S extends T> S saveAndFlush(S s) {
        Object saved = this.dao.saveAndFlush(s);
        this.logInfo("saveAndFlush({} {})", "saved and flushed {}: {}", this.clazzSimpleName, DatafiStaticUtils.toCamelCase(this.clazzSimpleName), this.clazzSimpleName, s.toString());
        return (S)saved;
    }

    public void deleteInBatch(Iterable<T> iterable) {
        this.dao.deleteInBatch(iterable);
        this.logInfo("deleteInBatch(Iterable<{}> iterable)", "deleted batch of {} {}", this.clazzSimpleName, IterableUtils.size(iterable), this.clazzSimpleNamePlural);
    }

    public void deleteAllInBatch() {
        this.dao.deleteAllInBatch();
        this.logInfo("deleteAllInBatch()", "deleted all {}", this.clazzSimpleNamePlural);
    }

    public T getOne(Object id) {
        Object fetched = this.dao.getOne(id);
        this.logInfo("getOne({} id)", "fetched one {} by id {}", this.idTypeSimpleName, this.clazzSimpleName, id.toString());
        return (T)fetched;
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        Optional fetched = this.dao.findOne(example);
        this.logInfo("findOne(Example<{}> example)", fetched.isPresent() ? "fetched one {} by provided example" : "could not find {} by provided example", this.clazzSimpleName, this.clazzSimpleName);
        return fetched;
    }

    public <S extends T> List<S> findAll(Example<S> example) {
        List all = this.dao.findAll(example);
        this.logInfo("findAll(Example<{}> example)", "found all {} by provided example", this.clazzSimpleName);
        return all;
    }

    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        List all = this.dao.findAll(example, sort);
        this.logInfo("findAll(Example<{}> example)", "found all {} {} by provided example, sorted by {}", this.clazzSimpleName, all.size(), this.clazzSimpleNamePlural, sort.toString());
        return all;
    }

    public <S extends T> Page findAll(Example<S> example, Pageable pageable) {
        Page all = this.dao.findAll(example, pageable);
        this.logInfo("findAll(Example<{}> example)", "found all {} {} by provided example, in {} page(s)", this.clazzSimpleName, all.getTotalElements(), this.clazzSimpleNamePlural, all.getTotalPages());
        return all;
    }

    public <S extends T> long count(Example<S> example) {
        long count = this.dao.count(example);
        this.logInfo("count(Example<{}> example)", "counted {} {} by provided example", this.clazzSimpleName, count, this.clazzSimpleNamePlural);
        return count;
    }

    public <S extends T> boolean exists(Example<S> example) {
        boolean exists = this.dao.exists(example);
        this.logInfo("exists(Example<{}> example)", exists ? "validated existence of {} by provided example" : "determined non-existence of {} by provided example", this.clazzSimpleName, this.clazzSimpleName);
        return exists;
    }

    public List<T> findBy(String attributeName, Object attributeValue) {
        try {
            Class<?> attributeValueClass = attributeValue.getClass();
            Class[] params = new Class[]{attributeValueClass};
            String resolverName = "findBy" + DatafiStaticUtils.toPascalCase(attributeName);
            Method methodToInvoke = this.getMethodToInvoke(resolverName, params, this.dao);
            List result = (List)methodToInvoke.invoke((Object)this.dao, attributeValue);
            this.logInfo("findBy(String attributeName, {} attributeValue)", "found {} {} by field {} with matching value of {}", attributeValueClass.getSimpleName(), result.size(), this.clazzSimpleNamePlural, attributeValue.toString());
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<T> findByUnique(String attributeName, Object attributeValue) {
        try {
            Class<?> attributeValueClass = attributeValue.getClass();
            Class[] params = new Class[]{attributeValueClass};
            String resolverName = "findBy" + DatafiStaticUtils.toPascalCase(attributeName);
            Method methodToInvoke = this.getMethodToInvoke(resolverName, params, this.dao);
            Optional result = (Optional)methodToInvoke.invoke((Object)this.dao, attributeValue);
            this.logInfo("findByUnique(String attributeName, {} attributeValue)", result.isPresent() ? "found {} by field {} with matching value of {}" : "could not find {} by field {} with matching value of {}", attributeValueClass.getSimpleName(), this.clazzSimpleName, attributeName, attributeValue.toString());
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<T> findAllBy(String attributeName, Object[] attributeValues) {
        try {
            Class[] params = new Class[]{List.class};
            String resolverName = "findAllBy" + DatafiStaticUtils.toPascalCase(attributeName) + "In";
            Method methodToInvoke = this.getMethodToInvoke(resolverName, params, this.dao);
            List<Object> attributeValuesAsList = Arrays.asList(attributeValues);
            List result = (List)methodToInvoke.invoke((Object)this.dao, attributeValuesAsList);
            this.logInfo("findAllBy(String attributeName, Object[] attributeValues)", "found {} {} by provided attribute values: {}", result.size(), this.clazzSimpleNamePlural, Arrays.toString(attributeValues));
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<T> findOne(Specification<T> specification) {
        Optional result = this.dao.findOne(specification);
        this.logInfo("findOne(Specification<{}> specification)", result.isPresent() ? "found one {} by provided specification" : "could not find {} by provided specification", this.clazzSimpleName);
        return result;
    }

    public List<T> findAll(Specification<T> specification) {
        List all = this.dao.findAll(specification);
        this.logInfo("findAll(Specification<{}> specification)", "found {} {} by provided specification", this.clazzSimpleName, all.size(), this.clazzSimpleNamePlural);
        return all;
    }

    public Page findAll(Specification<T> specification, Pageable pageable) {
        Page all = this.dao.findAll(specification, pageable);
        this.logInfo("findAll(Specification<{}> specification, Pageable pageable)", "found {} {} by provided specification in {} pages", this.clazzSimpleName, all.getTotalElements(), this.clazzSimpleNamePlural, all.getTotalPages());
        return all;
    }

    public List<T> findAll(Specification<T> specification, Sort sort) {
        List all = this.dao.findAll(specification, sort);
        this.logInfo("findAll(Specification<{}> specification, Sort sort)", "found {} {} by provided specification, sorted by {}", this.clazzSimpleName, all.size(), this.clazzSimpleNamePlural, sort.toString());
        return all;
    }

    public long count(Specification<T> specification) {
        long count = this.dao.count(specification);
        this.logInfo("count(Specification<{}> specification)", "counted {} {} by provided specfication", this.clazzSimpleName, count, this.clazzSimpleNamePlural);
        return count;
    }

    public <TResult> TResult callQuery(String queryName, Object ... args) {
        try {
            Class[] params = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                params[i] = args[i].getClass();
            }
            Method methodToInvoke = this.getMethodToInvoke(queryName, params, this.dao);
            Object result = methodToInvoke.invoke((Object)this.dao, args);
            this.logInfo("callQuery(String queryName, Object... args)", Collection.class.isAssignableFrom(result.getClass()) ? String.format("fetched %d records from database with query '%s'", ((Collection)result).size(), queryName) : String.format("fetched %s from database with query '%s'", result.getClass().getSimpleName(), queryName), new Object[0]);
            return (TResult)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T cascadeUpdate(T toUpdate, T source) {
        Object updated = this.cascadeUpdateImpl(toUpdate, source);
        this.logInfo("cascadeUpdate({} toUpdate, {} source)", "cascade updated {}", this.clazzSimpleName, this.clazzSimpleName, this.clazzSimpleName);
        return (T)updated;
    }

    public <HasTs> List<T> createAndAddNewToCollectionIn(HasTs toAddTo, String fieldName, List<T> toAdd) {
        String toAddToClazzName = toAddTo.getClass().getSimpleName();
        GenericDao toAddDao = this.dao;
        GenericDao toAddToDao = this.daoMap.get(toAddToClazzName);
        toAddTo = toAddToDao.findById(this.reflectionCache.getEntitiesCache().get(toAddToClazzName).getId(toAddTo)).orElse(null);
        if (toAddTo == null) {
            throw new IllegalArgumentException("Could not find an entity with the given id");
        }
        Method existingCollectionGetter = this.getMethodToInvoke("get" + DatafiStaticUtils.toPascalCase(fieldName), toAddTo);
        Collection existingCollection = (Collection)this.invoke(existingCollectionGetter, toAddTo, new Object[0]);
        existingCollection.addAll(toAdd);
        Method existingCollectionSetter = this.getMethodToInvoke("set" + DatafiStaticUtils.toPascalCase(fieldName), toAddTo);
        this.invoke(existingCollectionSetter, toAddTo, existingCollection);
        toAddToDao.save(toAddTo);
        toAddDao.saveAll(toAdd);
        this.logInfo("createAndAddNewToCollectionIn({} toAddTo, String fieldName, List<{}> toAdd)", "created {} {} and associated them with {} by id: {}", toAddToClazzName, this.clazzSimpleName, toAdd.size(), this.clazzSimpleNamePlural, toAddToClazzName, this.reflectionCache.getIdOf(toAddToClazzName, toAddTo));
        return toAdd;
    }

    public <HasTs> List<T> associateExistingWithCollectionIn(HasTs toAssociateWith, String fieldName, List<T> toAssociate) {
        GenericDao toAssociateDao = this.dao;
        String toAssociateWithClazzName = toAssociateWith.getClass().getSimpleName();
        GenericDao toAssociateWithDao = this.daoMap.get(toAssociateWithClazzName);
        toAssociate = toAssociateDao.findAllById(DatafiStaticUtils.getIdList(toAssociate, this.reflectionCache));
        toAssociateWith = toAssociateWithDao.findById(this.reflectionCache.getEntitiesCache().get(toAssociateWithClazzName).getId(toAssociateWith)).orElse(null);
        if (toAssociateWith == null) {
            throw new IllegalArgumentException("Could not find an entity with the given id");
        }
        Method existingCollectionGetter = this.getMethodToInvoke("get" + DatafiStaticUtils.toPascalCase(fieldName), toAssociateWith);
        Collection existingCollection = (Collection)this.invoke(existingCollectionGetter, toAssociateWith, new Object[0]);
        existingCollection.addAll(toAssociate);
        Method existingCollectionSetter = this.getMethodToInvoke("set" + DatafiStaticUtils.toPascalCase(fieldName), toAssociateWith);
        this.invoke(existingCollectionSetter, toAssociateWith, existingCollection);
        toAssociateWithDao.save(toAssociateWith);
        this.logInfo("associateExistingWithCollectionIn({} toAssociateWith, String fieldName, List<{}> toAssociate)", "associated {} {} with {} by id: {}", toAssociateWithClazzName, this.clazzSimpleName, toAssociate.size(), this.clazzSimpleNamePlural, toAssociateWithClazzName, this.reflectionCache.getIdOf(toAssociateWithClazzName, toAssociateWith));
        return toAssociate;
    }

    public List<T> cascadeUpdateCollection(Collection<T> toUpdate, Collection<T> updated) {
        Map<Object, Object> updatedEntitiesMap = updated.stream().collect(Collectors.toMap(updatedObj -> DatafiStaticUtils.getId(updatedObj, this.reflectionCache), updatedObj -> updatedObj));
        for (T entityToUpdate : toUpdate) {
            Object updatedEntity = updatedEntitiesMap.get(DatafiStaticUtils.getId(entityToUpdate, this.reflectionCache));
            this.cascadeUpdateImpl(entityToUpdate, updatedEntity);
        }
        this.logInfo("cascadeUpdateCollection(Iterable<{}> toUpdate, Iterable<{}> updated)", "cascade updated collection of {}", this.clazzSimpleName, this.clazzSimpleName, this.clazzSimpleNamePlural);
        return this.dao.saveAll(toUpdate);
    }

    private Object cascadeUpdateImpl(Object toUpdate, Object source) {
        Class<?> currentClazz = toUpdate.getClass();
        String currentClazzName = currentClazz.getSimpleName();
        this.logInfo("cascadeUpdateImpl({} toUpdate, {} source)", "cascade updating {}", currentClazzName, currentClazzName, currentClazzName);
        List<Field> fieldsToUpdate = this.reflectionCache.getEntitiesCache().get(currentClazz.getSimpleName()).getCascadeUpdatableFields();
        for (Field currentField : fieldsToUpdate) {
            try {
                currentField.setAccessible(true);
                Object sourceFieldValue = currentField.get(source);
                if (sourceFieldValue == null) continue;
                if (this.isForeignKey(currentField, toUpdate)) {
                    Object targetFieldToUpdateValue = currentField.get(toUpdate);
                    this.cascadeUpdateImpl(targetFieldToUpdateValue, sourceFieldValue);
                    this.reflectionCache.getEntitiesCache().get(currentField.getType().getSimpleName()).getRelationshipSyncronizer().trySetBackpointer(currentField, targetFieldToUpdateValue, toUpdate);
                    continue;
                }
                if (this.isForeignKeyCollection(currentField)) continue;
                currentField.set(toUpdate, sourceFieldValue);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.daoMap.get(currentClazz.getSimpleName()).save(toUpdate);
    }

    private boolean isForeignKeyCollection(Field f) {
        f.setAccessible(true);
        return f.isAnnotationPresent(OneToMany.class) || f.isAnnotationPresent(ManyToMany.class);
    }

    private boolean isForeignKey(Field currentField, Object owner) {
        try {
            boolean isForeignKey;
            currentField.setAccessible(true);
            boolean bl = isForeignKey = currentField.isAnnotationPresent(OneToOne.class) || currentField.isAnnotationPresent(ManyToOne.class);
            if (isForeignKey) {
                if (currentField.get(owner) == null) {
                    currentField.set(owner, this.defaultInstanceOf(currentField.getType()));
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object defaultInstanceOf(Class<?> type) {
        return this.reflectionCache.getEntitiesCache().get(type.getSimpleName()).getDefaultInstance();
    }

    private Method getMethodToInvoke(String resolverName, Object instance) {
        return this.getMethodToInvoke(resolverName, new Class[0], instance);
    }

    private Method getMethodToInvoke(String resolverName, Class<?>[] params, Object instance) {
        Method methodToInvoke = this.reflectionCache.getResolversCache().get(Maps.immutableEntry((Object)resolverName, params));
        if (methodToInvoke == null) {
            try {
                methodToInvoke = params.length > 0 ? instance.getClass().getMethod(resolverName, params) : instance.getClass().getMethod(resolverName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.reflectionCache.getResolversCache().put(Maps.immutableEntry((Object)resolverName, params), methodToInvoke);
        }
        return methodToInvoke;
    }

    private Object invoke(Method method, Object instance, Object ... args) {
        try {
            if (args.length > 0) {
                return method.invoke(instance, args);
            }
            return method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public dev.sanda.datafi.dto.Page<T> freeTextSearchBy(FreeTextSearchPageRequest request) {
        return this.freeTextSearchBy(request, -1L);
    }

    public dev.sanda.datafi.dto.Page<T> freeTextSearchBy(FreeTextSearchPageRequest request, long totalCount) {
        try {
            if (request.getSearchTerm() == null || request.getSearchTerm().equals("")) {
                throw new IllegalArgumentException("Illegal attempt to search for " + this.clazzSimpleNamePlural + " with null or blank string");
            }
            DatafiStaticUtils.validateSortByIfNonNull(this.clazz, request.getSortBy(), this.reflectionCache);
            PageRequest paginator = DatafiStaticUtils.generatePageRequest(request, totalCount);
            Method methodToInvoke = this.getMethodToInvoke("freeTextSearch", new Class[]{String.class, Pageable.class}, this.dao);
            Page result = (Page)methodToInvoke.invoke((Object)this.dao, request.getSearchTerm(), paginator);
            this.logInfo("freeTextSearchBy(String searchTerm)", "found {} {} by searchTerm '{}'", result.getTotalElements(), this.clazzSimpleNamePlural, request.getSearchTerm());
            return new dev.sanda.datafi.dto.Page(result);
        }
        catch (Exception e) {
            this.logError("freeTextSearchBy(String searchTerm, int offset, int limit, String sortBy, Sort.Direction sortDirection)", e.toString(), new Object[0]);
            throw new RuntimeException(e);
        }
    }

    public <A extends Archivable> A archive(A input) {
        Object id = this.cachedEntityTypeInfo.getId(input);
        String simpleName = input.getClass().getSimpleName();
        Object toArchive = this.findById(id).orElse(null);
        if (toArchive == null) {
            DatafiStaticUtils.throwEntityNotFoundException(simpleName, id);
        }
        ((Archivable)toArchive).setIsArchived(true);
        Archivable saved = this.save(toArchive);
        this.logInfo("archive({} input)", "archived {} with id {}", this.clazzSimpleName, this.clazzSimpleName, id.toString());
        return (A)saved;
    }

    public <A extends Archivable> A deArchive(A input) {
        Object id = this.cachedEntityTypeInfo.getId(input);
        String simpleName = input.getClass().getSimpleName();
        Object toDeArchive = this.findById(id).orElse(null);
        if (toDeArchive == null) {
            DatafiStaticUtils.throwEntityNotFoundException(simpleName, id);
        }
        ((Archivable)toDeArchive).setIsArchived(false);
        Archivable saved = this.save(toDeArchive);
        this.logInfo("deArchive({} input)", "de-archived {} with id {}", this.clazzSimpleName, this.clazzSimpleName, id.toString());
        return (A)saved;
    }

    public <A extends Archivable> List<A> archiveCollection(Collection<A> input) {
        List<Object> ids = DatafiStaticUtils.getIdList(input, this.reflectionCache);
        List<Object> toArchive = this.findAllById(ids);
        toArchive.forEach(item -> ((Archivable)item).setIsArchived(true));
        List<T> saved = this.saveAll(toArchive);
        this.logInfo("archiveCollection(Collection<{}> input)", "archived {} {}", this.clazzSimpleName, saved.size(), this.clazzSimpleNamePlural);
        return saved;
    }

    public <A extends Archivable> List<A> deArchiveCollection(Collection<A> input) {
        List<Object> ids = DatafiStaticUtils.getIdList(input, this.reflectionCache);
        List<Object> toDeArchive = this.findAllById(ids);
        toDeArchive.forEach(item -> ((Archivable)item).setIsArchived(false));
        List<T> saved = this.saveAll(toDeArchive);
        this.logInfo("deArchiveCollection(Collection<{}> input)", "de-archived {} {}", this.clazzSimpleName, saved.size(), this.clazzSimpleNamePlural);
        return saved;
    }

    public DataManager() {
    }

    public DataManager(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        this.clazz = clazz;
    }

    @NonNull
    public Class<T> getClazz() {
        return this.clazz;
    }

    public String getClazzSimpleName() {
        return this.clazzSimpleName;
    }

    public void setLoggingEnabled(Boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }
}

