/*
 *  Copyright (c) 2021 Sergey Komlach aka Salat-Cx65; Original project: https://github.com/Salat-Cx65/AdvancedBiometricPromptCompat
 *  All rights reserved.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

package dev.skomlach.common.misc

import android.app.Activity
import android.content.Context
import android.os.Build
import android.view.View
import android.view.Window

fun isActivityFinished(context: Context?): Boolean {
    if (context == null) return true
    return if (context is Activity) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            context.isDestroyed || context.isFinishing
        } else {
            context.isFinishing
        }
    } else false
}

fun hasWindowFocus(w: Activity?): Boolean {
    return !isActivityFinished(w) && hasWindowFocus(w?.window)
}

fun hasWindowFocus(w: Window?): Boolean {
    if (w == null)
        return false
    return w.findViewById<View>(Window.ID_ANDROID_CONTENT).hasWindowFocus()
}