/*
 * Decompiled with CFR 0.152.
 */
package dev.spiralmoon.maplestory.api;

import com.google.gson.Gson;
import dev.spiralmoon.maplestory.api.LatestApiUpdateTimeOption;
import dev.spiralmoon.maplestory.api.MapleStoryApiErrorBody;
import dev.spiralmoon.maplestory.api.MapleStoryApiErrorCode;
import dev.spiralmoon.maplestory.api.MapleStoryApiException;
import dev.spiralmoon.maplestory.api.callback.FailureCallback;
import dev.spiralmoon.maplestory.api.callback.SuccessCallback;
import dev.spiralmoon.maplestory.api.dto.InspectionInfoDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterAbilityDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterAndroidCashItemEquipmentDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterAndroidEquipmentDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterBasicDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterBeautyEquipmentDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterDojangDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterHexaMatrixDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterHexaMatrixStatDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterHyperStatDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterItemEquipmentDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterLinkSkillDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterPetEquipmentDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterPopularityDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterPropensityDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterSetEffectDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterSkillDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterStatDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterSymbolEquipmentDTO;
import dev.spiralmoon.maplestory.api.dto.character.CharacterVMatrixDTO;
import dev.spiralmoon.maplestory.api.dto.guild.GuildBasicDTO;
import dev.spiralmoon.maplestory.api.dto.guild.GuildDTO;
import dev.spiralmoon.maplestory.api.dto.history.CubeHistoryResponseDTO;
import dev.spiralmoon.maplestory.api.dto.history.StarforceHistoryResponseDTO;
import dev.spiralmoon.maplestory.api.dto.ranking.AchievementRankingResponseDTO;
import dev.spiralmoon.maplestory.api.dto.ranking.DojangRankingResponseDTO;
import dev.spiralmoon.maplestory.api.dto.ranking.GuildRankingResponseDTO;
import dev.spiralmoon.maplestory.api.dto.ranking.OverallRankingResponseDTO;
import dev.spiralmoon.maplestory.api.dto.ranking.TheSeedRankingResponseDTO;
import dev.spiralmoon.maplestory.api.dto.ranking.UnionRankingResponseDTO;
import dev.spiralmoon.maplestory.api.dto.union.UnionDTO;
import dev.spiralmoon.maplestory.api.dto.union.UnionRaiderDTO;
import dev.spiralmoon.maplestory.api.template.CharacterApi;
import dev.spiralmoon.maplestory.api.template.CubeApi;
import dev.spiralmoon.maplestory.api.template.GuildApi;
import dev.spiralmoon.maplestory.api.template.InspectionInfoApi;
import dev.spiralmoon.maplestory.api.template.RankingApi;
import dev.spiralmoon.maplestory.api.template.StarforceApi;
import dev.spiralmoon.maplestory.api.template.UnionApi;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class MapleStoryApi {
    private final String apiKey;
    private static final String BASE_URL = "https://open.api.nexon.com/";
    private long timeout;

    public MapleStoryApi(String apiKey) {
        this.apiKey = apiKey;
        this.timeout = 5000L;
    }

    public CharacterDTO getCharacter(@NonNull String characterName) throws IOException {
        if (characterName == null) {
            throw new NullPointerException("characterName is marked non-null but is null");
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterDTO> call = characterApi.getCharacter(this.apiKey, characterName);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterDTO)response.body();
    }

    public void getCharacterAsync(@NonNull String characterName, final SuccessCallback<CharacterDTO> onSuccess, final FailureCallback onFailure) {
        if (characterName == null) {
            throw new NullPointerException("characterName is marked non-null but is null");
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterDTO> call = characterApi.getCharacter(this.apiKey, characterName);
        call.enqueue((Callback)new Callback<CharacterDTO>(){

            public void onResponse(Call<CharacterDTO> call, Response<CharacterDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterBasicDTO getCharacterBasic(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterBasic(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterBasicDTO getCharacterBasic(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterBasicDTO> call = characterApi.getCharacterBasic(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterBasicDTO)response.body();
    }

    public void getCharacterBasicAsync(@NonNull String ocid, SuccessCallback<CharacterBasicDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterBasicAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterBasicAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterBasicDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterBasicDTO> call = characterApi.getCharacterBasic(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterBasicDTO>(){

            public void onResponse(Call<CharacterBasicDTO> call, Response<CharacterBasicDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterBasicDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterPopularityDTO getCharacterPopularity(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterPopularity(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterPopularityDTO getCharacterPopularity(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterPopularityDTO> call = characterApi.getCharacterPopularity(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterPopularityDTO)response.body();
    }

    public void getCharacterPopularityAsync(@NonNull String ocid, SuccessCallback<CharacterPopularityDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterPopularityAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterPopularityAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterPopularityDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterPopularityDTO> call = characterApi.getCharacterPopularity(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterPopularityDTO>(){

            public void onResponse(Call<CharacterPopularityDTO> call, Response<CharacterPopularityDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterPopularityDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterStatDTO getCharacterStat(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterStat(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterStatDTO getCharacterStat(@NonNull String ocid, LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterStatDTO> call = characterApi.getCharacterStat(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterStatDTO)response.body();
    }

    public void getCharacterStatAsync(@NonNull String ocid, SuccessCallback<CharacterStatDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterStatAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterStatAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterStatDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterStatDTO> call = characterApi.getCharacterStat(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterStatDTO>(){

            public void onResponse(Call<CharacterStatDTO> call, Response<CharacterStatDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterStatDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterHyperStatDTO getCharacterHyperStat(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterHyperStat(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterHyperStatDTO getCharacterHyperStat(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterHyperStatDTO> call = characterApi.getCharacterHyperStat(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterHyperStatDTO)response.body();
    }

    public void getCharacterHyperStatAsync(@NonNull String ocid, SuccessCallback<CharacterHyperStatDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterHyperStatAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterHyperStatAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterHyperStatDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterHyperStatDTO> call = characterApi.getCharacterHyperStat(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterHyperStatDTO>(){

            public void onResponse(Call<CharacterHyperStatDTO> call, Response<CharacterHyperStatDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterHyperStatDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterPropensityDTO getCharacterPropensity(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterPropensity(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterPropensityDTO getCharacterPropensity(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterPropensityDTO> call = characterApi.getCharacterPropensity(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterPropensityDTO)response.body();
    }

    public void getCharacterPropensityAsync(@NonNull String ocid, SuccessCallback<CharacterPropensityDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterPropensityAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterPropensityAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterPropensityDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterPropensityDTO> call = characterApi.getCharacterPropensity(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterPropensityDTO>(){

            public void onResponse(Call<CharacterPropensityDTO> call, Response<CharacterPropensityDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterPropensityDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterAbilityDTO getCharacterAbility(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterAbility(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterAbilityDTO getCharacterAbility(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterAbilityDTO> call = characterApi.getCharacterAbility(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterAbilityDTO)response.body();
    }

    public void getCharacterAbilityAsync(@NonNull String ocid, SuccessCallback<CharacterAbilityDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterAbilityAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterAbilityAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterAbilityDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterAbilityDTO> call = characterApi.getCharacterAbility(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterAbilityDTO>(){

            public void onResponse(Call<CharacterAbilityDTO> call, Response<CharacterAbilityDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterAbilityDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterItemEquipmentDTO getCharacterItemEquipment(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterItemEquipment(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterItemEquipmentDTO getCharacterItemEquipment(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterItemEquipmentDTO> call = characterApi.getCharacterItemEquipment(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterItemEquipmentDTO)response.body();
    }

    public void getCharacterItemEquipmentAsync(@NonNull String ocid, SuccessCallback<CharacterItemEquipmentDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterItemEquipmentAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterItemEquipmentAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterItemEquipmentDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterItemEquipmentDTO> call = characterApi.getCharacterItemEquipment(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterItemEquipmentDTO>(){

            public void onResponse(Call<CharacterItemEquipmentDTO> call, Response<CharacterItemEquipmentDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterItemEquipmentDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterAndroidCashItemEquipmentDTO getCharacterCashItemEquipment(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterCashItemEquipment(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterAndroidCashItemEquipmentDTO getCharacterCashItemEquipment(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterAndroidCashItemEquipmentDTO> call = characterApi.getCharacterCashItemEquipment(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterAndroidCashItemEquipmentDTO)response.body();
    }

    public void getCharacterCashItemEquipmentAsync(@NonNull String ocid, SuccessCallback<CharacterAndroidCashItemEquipmentDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterCashItemEquipmentAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterCashItemEquipmentAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterAndroidCashItemEquipmentDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterAndroidCashItemEquipmentDTO> call = characterApi.getCharacterCashItemEquipment(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterAndroidCashItemEquipmentDTO>(){

            public void onResponse(Call<CharacterAndroidCashItemEquipmentDTO> call, Response<CharacterAndroidCashItemEquipmentDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterAndroidCashItemEquipmentDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterSymbolEquipmentDTO getCharacterSymbolEquipment(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterSymbolEquipment(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterSymbolEquipmentDTO getCharacterSymbolEquipment(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterSymbolEquipmentDTO> call = characterApi.getCharacterSymbolEquipment(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterSymbolEquipmentDTO)response.body();
    }

    public void getCharacterSymbolEquipmentAsync(@NonNull String ocid, SuccessCallback<CharacterSymbolEquipmentDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterSymbolEquipmentAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterSymbolEquipmentAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterSymbolEquipmentDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterSymbolEquipmentDTO> call = characterApi.getCharacterSymbolEquipment(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterSymbolEquipmentDTO>(){

            public void onResponse(Call<CharacterSymbolEquipmentDTO> call, Response<CharacterSymbolEquipmentDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterSymbolEquipmentDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterSetEffectDTO getCharacterSetEffectAsync(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterSetEffectAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterSetEffectDTO getCharacterSetEffectAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterSetEffectDTO> call = characterApi.getCharacterSetEffect(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterSetEffectDTO)response.body();
    }

    public void getCharacterSetEffectAsync(@NonNull String ocid, SuccessCallback<CharacterSetEffectDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterSetEffectAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterSetEffectAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterSetEffectDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterSetEffectDTO> call = characterApi.getCharacterSetEffect(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterSetEffectDTO>(){

            public void onResponse(Call<CharacterSetEffectDTO> call, Response<CharacterSetEffectDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterSetEffectDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterBeautyEquipmentDTO getCharacterBeautyEquipment(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterBeautyEquipment(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterBeautyEquipmentDTO getCharacterBeautyEquipment(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterBeautyEquipmentDTO> call = characterApi.getCharacterBeautyEquipment(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterBeautyEquipmentDTO)response.body();
    }

    public void getCharacterBeautyEquipmentAsync(@NonNull String ocid, SuccessCallback<CharacterBeautyEquipmentDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterBeautyEquipmentAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterBeautyEquipmentAsync(@NonNull String ocid, LocalDateTime localDateTime, final SuccessCallback<CharacterBeautyEquipmentDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterBeautyEquipmentDTO> call = characterApi.getCharacterBeautyEquipment(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterBeautyEquipmentDTO>(){

            public void onResponse(Call<CharacterBeautyEquipmentDTO> call, Response<CharacterBeautyEquipmentDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterBeautyEquipmentDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterAndroidEquipmentDTO getCharacterAndroidEquipment(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterAndroidEquipment(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterAndroidEquipmentDTO getCharacterAndroidEquipment(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterAndroidEquipmentDTO> call = characterApi.getCharacterAndroidEquipment(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterAndroidEquipmentDTO)response.body();
    }

    public void getCharacterAndroidEquipmentAsync(@NonNull String ocid, SuccessCallback<CharacterAndroidEquipmentDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterAndroidEquipmentAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterAndroidEquipmentAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterAndroidEquipmentDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterAndroidEquipmentDTO> call = characterApi.getCharacterAndroidEquipment(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterAndroidEquipmentDTO>(){

            public void onResponse(Call<CharacterAndroidEquipmentDTO> call, Response<CharacterAndroidEquipmentDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterAndroidEquipmentDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterPetEquipmentDTO getCharacterPetEquipment(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterPetEquipment(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterPetEquipmentDTO getCharacterPetEquipment(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterPetEquipmentDTO> call = characterApi.getCharacterPetEquipment(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterPetEquipmentDTO)response.body();
    }

    public void getCharacterPetEquipmentAsync(@NonNull String ocid, SuccessCallback<CharacterPetEquipmentDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterPetEquipmentAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterPetEquipmentAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterPetEquipmentDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterPetEquipmentDTO> call = characterApi.getCharacterPetEquipment(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterPetEquipmentDTO>(){

            public void onResponse(Call<CharacterPetEquipmentDTO> call, Response<CharacterPetEquipmentDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterPetEquipmentDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterSkillDTO getCharacterSkill(@NonNull String ocid, @NonNull String characterSkillGrade) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (characterSkillGrade == null) {
            throw new NullPointerException("characterSkillGrade is marked non-null but is null");
        }
        return this.getCharacterSkill(ocid, characterSkillGrade, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterSkillDTO getCharacterSkill(@NonNull String ocid, @NonNull String characterSkillGrade, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (characterSkillGrade == null) {
            throw new NullPointerException("characterSkillGrade is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterSkillDTO> call = characterApi.getCharacterSkill(this.apiKey, ocid, date, characterSkillGrade);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterSkillDTO)response.body();
    }

    public void getCharacterSkillAsync(@NonNull String ocid, @NonNull String characterSkillGrade, SuccessCallback<CharacterSkillDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (characterSkillGrade == null) {
            throw new NullPointerException("characterSkillGrade is marked non-null but is null");
        }
        this.getCharacterSkillAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), characterSkillGrade, onSuccess, onFailure);
    }

    public void getCharacterSkillAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, String characterSkillGrade, final SuccessCallback<CharacterSkillDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterSkillDTO> call = characterApi.getCharacterSkill(this.apiKey, ocid, date, characterSkillGrade);
        call.enqueue((Callback)new Callback<CharacterSkillDTO>(){

            public void onResponse(Call<CharacterSkillDTO> call, Response<CharacterSkillDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterSkillDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterLinkSkillDTO getCharacterLinkSkill(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterLinkSkill(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterLinkSkillDTO getCharacterLinkSkill(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterLinkSkillDTO> call = characterApi.getCharacterLinkSkill(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterLinkSkillDTO)response.body();
    }

    public void getCharacterLinkSkillAsync(@NonNull String ocid, SuccessCallback<CharacterLinkSkillDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterLinkSkillAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterLinkSkillAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterLinkSkillDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterLinkSkillDTO> call = characterApi.getCharacterLinkSkill(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterLinkSkillDTO>(){

            public void onResponse(Call<CharacterLinkSkillDTO> call, Response<CharacterLinkSkillDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterLinkSkillDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterVMatrixDTO getCharacterVMatrix(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterVMatrix(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterVMatrixDTO getCharacterVMatrix(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterVMatrixDTO> call = characterApi.getCharacterVMatrix(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterVMatrixDTO)response.body();
    }

    public void getCharacterVMatrixAsync(@NonNull String ocid, SuccessCallback<CharacterVMatrixDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterVMatrixAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterVMatrixAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterVMatrixDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterVMatrixDTO> call = characterApi.getCharacterVMatrix(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterVMatrixDTO>(){

            public void onResponse(Call<CharacterVMatrixDTO> call, Response<CharacterVMatrixDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterVMatrixDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterHexaMatrixDTO getCharacterHexaMatrix(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterHexaMatrix(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterHexaMatrixDTO getCharacterHexaMatrix(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterHexaMatrixDTO> call = characterApi.getCharacterHexaMatrix(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterHexaMatrixDTO)response.body();
    }

    public void getCharacterHexaMatrixAsync(@NonNull String ocid, SuccessCallback<CharacterHexaMatrixDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterHexaMatrixAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterHexaMatrixAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterHexaMatrixDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterHexaMatrixDTO> call = characterApi.getCharacterHexaMatrix(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterHexaMatrixDTO>(){

            public void onResponse(Call<CharacterHexaMatrixDTO> call, Response<CharacterHexaMatrixDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterHexaMatrixDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterHexaMatrixStatDTO getCharacterHexaMatrixStat(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterHexaMatrixStat(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterHexaMatrixStatDTO getCharacterHexaMatrixStat(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterHexaMatrixStatDTO> call = characterApi.getCharacterHexaMatrixStat(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterHexaMatrixStatDTO)response.body();
    }

    public void getCharacterHexaMatrixStatAsync(@NonNull String ocid, SuccessCallback<CharacterHexaMatrixStatDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterHexaMatrixStatAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterHexaMatrixStatAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<CharacterHexaMatrixStatDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterHexaMatrixStatDTO> call = characterApi.getCharacterHexaMatrixStat(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterHexaMatrixStatDTO>(){

            public void onResponse(Call<CharacterHexaMatrixStatDTO> call, Response<CharacterHexaMatrixStatDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterHexaMatrixStatDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CharacterDojangDTO getCharacterDojang(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getCharacterDojang(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public CharacterDojangDTO getCharacterDojang(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterDojangDTO> call = characterApi.getCharacterDojang(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CharacterDojangDTO)response.body();
    }

    public void getCharacterDojangAsync(@NonNull String ocid, SuccessCallback<CharacterDojangDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getCharacterDojangAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getCharacterDojangAsync(@NonNull String ocid, LocalDateTime localDateTime, final SuccessCallback<CharacterDojangDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CharacterApi characterApi = (CharacterApi)retrofit.create(CharacterApi.class);
        Call<CharacterDojangDTO> call = characterApi.getCharacterDojang(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<CharacterDojangDTO>(){

            public void onResponse(Call<CharacterDojangDTO> call, Response<CharacterDojangDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CharacterDojangDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public UnionDTO getUnion(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getUnion(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public UnionDTO getUnion(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        UnionApi unionApi = (UnionApi)retrofit.create(UnionApi.class);
        Call<UnionDTO> call = unionApi.getUnion(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (UnionDTO)response.body();
    }

    public void getUnionAsync(@NonNull String ocid, SuccessCallback<UnionDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getUnionAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getUnionAsync(@NonNull String ocid, LocalDateTime localDateTime, final SuccessCallback<UnionDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        UnionApi unionApi = (UnionApi)retrofit.create(UnionApi.class);
        Call<UnionDTO> call = unionApi.getUnion(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<UnionDTO>(){

            public void onResponse(Call<UnionDTO> call, Response<UnionDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<UnionDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public UnionRaiderDTO getUnionRaider(@NonNull String ocid) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        return this.getUnionRaider(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public UnionRaiderDTO getUnionRaider(@NonNull String ocid, @NonNull LocalDateTime localDateTime) throws IOException {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        UnionApi unionApi = (UnionApi)retrofit.create(UnionApi.class);
        Call<UnionRaiderDTO> call = unionApi.getUnionRaider(this.apiKey, ocid, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (UnionRaiderDTO)response.body();
    }

    public void getUnionRaiderAsync(@NonNull String ocid, SuccessCallback<UnionRaiderDTO> onSuccess, FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        this.getUnionRaiderAsync(ocid, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getUnionRaiderAsync(@NonNull String ocid, @NonNull LocalDateTime localDateTime, final SuccessCallback<UnionRaiderDTO> onSuccess, final FailureCallback onFailure) {
        if (ocid == null) {
            throw new NullPointerException("ocid is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        UnionApi unionApi = (UnionApi)retrofit.create(UnionApi.class);
        Call<UnionRaiderDTO> call = unionApi.getUnionRaider(this.apiKey, ocid, date);
        call.enqueue((Callback)new Callback<UnionRaiderDTO>(){

            public void onResponse(Call<UnionRaiderDTO> call, Response<UnionRaiderDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<UnionRaiderDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public GuildDTO getGuild(@NonNull String guildName, @NonNull String worldName) throws IOException {
        if (guildName == null) {
            throw new NullPointerException("guildName is marked non-null but is null");
        }
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        GuildApi guildApi = (GuildApi)retrofit.create(GuildApi.class);
        Call<GuildDTO> call = guildApi.getGuild(this.apiKey, guildName, worldName);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (GuildDTO)response.body();
    }

    public void getGuildAsync(@NonNull String guildName, @NonNull String worldName, final SuccessCallback<GuildDTO> onSuccess, final FailureCallback onFailure) {
        if (guildName == null) {
            throw new NullPointerException("guildName is marked non-null but is null");
        }
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        GuildApi guildApi = (GuildApi)retrofit.create(GuildApi.class);
        Call<GuildDTO> call = guildApi.getGuild(this.apiKey, guildName, worldName);
        call.enqueue((Callback)new Callback<GuildDTO>(){

            public void onResponse(Call<GuildDTO> call, Response<GuildDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<GuildDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public GuildBasicDTO getGuildBasic(@NonNull String oguildId) throws IOException {
        if (oguildId == null) {
            throw new NullPointerException("oguildId is marked non-null but is null");
        }
        return this.getGuildBasic(oguildId, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)));
    }

    public GuildBasicDTO getGuildBasic(@NonNull String oguildId, @NonNull LocalDateTime localDateTime) throws IOException {
        if (oguildId == null) {
            throw new NullPointerException("oguildId is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        GuildApi guildApi = (GuildApi)retrofit.create(GuildApi.class);
        Call<GuildBasicDTO> call = guildApi.getGuildBasic(this.apiKey, oguildId, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (GuildBasicDTO)response.body();
    }

    public void getGuildBasicAsync(@NonNull String oguildId, SuccessCallback<GuildBasicDTO> onSuccess, FailureCallback onFailure) {
        if (oguildId == null) {
            throw new NullPointerException("oguildId is marked non-null but is null");
        }
        this.getGuildBasicAsync(oguildId, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(1, 0, 1)), onSuccess, onFailure);
    }

    public void getGuildBasicAsync(@NonNull String oguildId, @NonNull LocalDateTime localDateTime, final SuccessCallback<GuildBasicDTO> onSuccess, final FailureCallback onFailure) {
        if (oguildId == null) {
            throw new NullPointerException("oguildId is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 21), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        GuildApi guildApi = (GuildApi)retrofit.create(GuildApi.class);
        Call<GuildBasicDTO> call = guildApi.getGuildBasic(this.apiKey, oguildId, date);
        call.enqueue((Callback)new Callback<GuildBasicDTO>(){

            public void onResponse(Call<GuildBasicDTO> call, Response<GuildBasicDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<GuildBasicDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public StarforceHistoryResponseDTO getStarforceHistory(int count) throws IOException {
        return this.getStarforceHistory(count, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(0, 0, 0)));
    }

    public void getStarforceHistoryAsync(int count, SuccessCallback<StarforceHistoryResponseDTO> onSuccess, FailureCallback onFailure) {
        this.getStarforceHistoryAsync(count, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(0, 0, 0)), onSuccess, onFailure);
    }

    public StarforceHistoryResponseDTO getStarforceHistory(int count, @NonNull LocalDateTime localDateTime) throws IOException {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 27), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        StarforceApi starforceApi = (StarforceApi)retrofit.create(StarforceApi.class);
        Call<StarforceHistoryResponseDTO> call = starforceApi.getStarforceHistoryByDate(this.apiKey, count, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (StarforceHistoryResponseDTO)response.body();
    }

    public void getStarforceHistoryAsync(int count, @NonNull LocalDateTime localDateTime, final SuccessCallback<StarforceHistoryResponseDTO> onSuccess, final FailureCallback onFailure) {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 27), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        StarforceApi starforceApi = (StarforceApi)retrofit.create(StarforceApi.class);
        Call<StarforceHistoryResponseDTO> call = starforceApi.getStarforceHistoryByDate(this.apiKey, count, date);
        call.enqueue((Callback)new Callback<StarforceHistoryResponseDTO>(){

            public void onResponse(Call<StarforceHistoryResponseDTO> call, Response<StarforceHistoryResponseDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<StarforceHistoryResponseDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public StarforceHistoryResponseDTO getStarforceHistory(int count, @NonNull String cursor) throws IOException {
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        StarforceApi starforceApi = (StarforceApi)retrofit.create(StarforceApi.class);
        Call<StarforceHistoryResponseDTO> call = starforceApi.getStarforceHistoryByCursor(this.apiKey, count, cursor);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (StarforceHistoryResponseDTO)response.body();
    }

    public void getStarforceHistoryAsync(int count, @NonNull String cursor, final SuccessCallback<StarforceHistoryResponseDTO> onSuccess, final FailureCallback onFailure) {
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        StarforceApi starforceApi = (StarforceApi)retrofit.create(StarforceApi.class);
        Call<StarforceHistoryResponseDTO> call = starforceApi.getStarforceHistoryByCursor(this.apiKey, count, cursor);
        call.enqueue((Callback)new Callback<StarforceHistoryResponseDTO>(){

            public void onResponse(Call<StarforceHistoryResponseDTO> call, Response<StarforceHistoryResponseDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<StarforceHistoryResponseDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CubeHistoryResponseDTO getCubeHistory(int count) throws IOException {
        return this.getCubeHistory(count, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(4, 0, 1)));
    }

    public void getCubeHistoryAsync(int count, SuccessCallback<CubeHistoryResponseDTO> onSuccess, FailureCallback onFailure) {
        this.getCubeHistoryAsync(count, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(4, 0, 1)), onSuccess, onFailure);
    }

    public CubeHistoryResponseDTO getCubeHistory(int count, @NonNull LocalDateTime localDateTime) throws IOException {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2022, 11, 25), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CubeApi cubeApi = (CubeApi)retrofit.create(CubeApi.class);
        Call<CubeHistoryResponseDTO> call = cubeApi.getCubeHistoryByDate(this.apiKey, count, date);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CubeHistoryResponseDTO)response.body();
    }

    public void getCubeHistoryAsync(int count, @NonNull LocalDateTime localDateTime, final SuccessCallback<CubeHistoryResponseDTO> onSuccess, final FailureCallback onFailure) {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2022, 11, 25), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CubeApi cubeApi = (CubeApi)retrofit.create(CubeApi.class);
        Call<CubeHistoryResponseDTO> call = cubeApi.getCubeHistoryByDate(this.apiKey, count, date);
        call.enqueue((Callback)new Callback<CubeHistoryResponseDTO>(){

            public void onResponse(Call<CubeHistoryResponseDTO> call, Response<CubeHistoryResponseDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CubeHistoryResponseDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public CubeHistoryResponseDTO getCubeHistory(int count, @NonNull String cursor) throws IOException {
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CubeApi cubeApi = (CubeApi)retrofit.create(CubeApi.class);
        Call<CubeHistoryResponseDTO> call = cubeApi.getCubeHistoryByCursor(this.apiKey, count, cursor);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (CubeHistoryResponseDTO)response.body();
    }

    public void getCubeHistoryAsync(int count, @NonNull String cursor, final SuccessCallback<CubeHistoryResponseDTO> onSuccess, final FailureCallback onFailure) {
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        CubeApi cubeApi = (CubeApi)retrofit.create(CubeApi.class);
        Call<CubeHistoryResponseDTO> call = cubeApi.getCubeHistoryByCursor(this.apiKey, count, cursor);
        call.enqueue((Callback)new Callback<CubeHistoryResponseDTO>(){

            public void onResponse(Call<CubeHistoryResponseDTO> call, Response<CubeHistoryResponseDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<CubeHistoryResponseDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public OverallRankingResponseDTO getOverallRanking(String worldName, Integer worldType, String characterClass, String ocid, Integer page) throws IOException {
        return this.getOverallRanking(worldName, worldType, characterClass, ocid, page, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(8, 30, 0)));
    }

    public OverallRankingResponseDTO getOverallRanking(String worldName, Integer worldType, String characterClass, String ocid, Integer page, @NonNull LocalDateTime localDateTime) throws IOException {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 22), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        RankingApi rankingApi = (RankingApi)retrofit.create(RankingApi.class);
        Call<OverallRankingResponseDTO> call = rankingApi.getOverallRanking(this.apiKey, date, worldName, worldType, characterClass, ocid, page);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (OverallRankingResponseDTO)response.body();
    }

    public void getOverallRankingAsync(String worldName, Integer worldType, String characterClass, String ocid, Integer page, SuccessCallback<OverallRankingResponseDTO> onSuccess, FailureCallback onFailure) {
        this.getOverallRankingAsync(worldName, worldType, characterClass, ocid, page, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(8, 30, 0)), onSuccess, onFailure);
    }

    public void getOverallRankingAsync(String worldName, Integer worldType, String characterClass, String ocid, Integer page, @NonNull LocalDateTime localDateTime, final SuccessCallback<OverallRankingResponseDTO> onSuccess, final FailureCallback onFailure) {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 22), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        RankingApi rankingApi = (RankingApi)retrofit.create(RankingApi.class);
        Call<OverallRankingResponseDTO> call = rankingApi.getOverallRanking(this.apiKey, date, worldName, worldType, characterClass, ocid, page);
        call.enqueue((Callback)new Callback<OverallRankingResponseDTO>(){

            public void onResponse(Call<OverallRankingResponseDTO> call, Response<OverallRankingResponseDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<OverallRankingResponseDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public UnionRankingResponseDTO getUnionRanking(String worldName, String ocid, Integer page) throws IOException {
        return this.getUnionRanking(worldName, ocid, page, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(8, 30, 0)));
    }

    public UnionRankingResponseDTO getUnionRanking(String worldName, String ocid, Integer page, @NonNull LocalDateTime localDateTime) throws IOException {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 22), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        RankingApi rankingApi = (RankingApi)retrofit.create(RankingApi.class);
        Call<UnionRankingResponseDTO> call = rankingApi.getUnionRanking(this.apiKey, date, worldName, ocid, page);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (UnionRankingResponseDTO)response.body();
    }

    public void getUnionRankingAsync(String worldName, String ocid, Integer page, SuccessCallback<UnionRankingResponseDTO> onSuccess, FailureCallback onFailure) {
        this.getUnionRankingAsync(worldName, ocid, page, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(8, 30, 0)), onSuccess, onFailure);
    }

    public void getUnionRankingAsync(String worldName, String ocid, Integer page, LocalDateTime localDateTime, final SuccessCallback<UnionRankingResponseDTO> onSuccess, final FailureCallback onFailure) {
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 22), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        RankingApi rankingApi = (RankingApi)retrofit.create(RankingApi.class);
        Call<UnionRankingResponseDTO> call = rankingApi.getUnionRanking(this.apiKey, date, worldName, ocid, page);
        call.enqueue((Callback)new Callback<UnionRankingResponseDTO>(){

            public void onResponse(Call<UnionRankingResponseDTO> call, Response<UnionRankingResponseDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<UnionRankingResponseDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public GuildRankingResponseDTO getGuildRanking(String worldName, int rankingType, String guildName, Integer page) throws IOException {
        return this.getGuildRanking(worldName, rankingType, guildName, page, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(8, 30, 0)));
    }

    public GuildRankingResponseDTO getGuildRanking(String worldName, int rankingType, String guildName, Integer page, @NonNull LocalDateTime localDateTime) throws IOException {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 22), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        RankingApi rankingApi = (RankingApi)retrofit.create(RankingApi.class);
        Call<GuildRankingResponseDTO> call = rankingApi.getGuildRanking(this.apiKey, date, worldName, rankingType, guildName, page);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (GuildRankingResponseDTO)response.body();
    }

    public void getGuildRankingAsync(String worldName, int rankingType, String guildName, Integer page, SuccessCallback<GuildRankingResponseDTO> onSuccess, FailureCallback onFailure) {
        this.getGuildRankingAsync(worldName, rankingType, guildName, page, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(8, 30, 0)), onSuccess, onFailure);
    }

    public void getGuildRankingAsync(String worldName, int rankingType, String guildName, Integer page, @NonNull LocalDateTime localDateTime, final SuccessCallback<GuildRankingResponseDTO> onSuccess, final FailureCallback onFailure) {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 22), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        RankingApi rankingApi = (RankingApi)retrofit.create(RankingApi.class);
        Call<GuildRankingResponseDTO> call = rankingApi.getGuildRanking(this.apiKey, date, worldName, rankingType, guildName, page);
        call.enqueue((Callback)new Callback<GuildRankingResponseDTO>(){

            public void onResponse(Call<GuildRankingResponseDTO> call, Response<GuildRankingResponseDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<GuildRankingResponseDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public DojangRankingResponseDTO getDojangRanking(String worldName, int difficulty, String characterClass, String ocid, Integer page) throws IOException {
        return this.getDojangRanking(worldName, difficulty, characterClass, ocid, page, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(8, 30, 0)));
    }

    public DojangRankingResponseDTO getDojangRanking(String worldName, int difficulty, String characterClass, String ocid, Integer page, @NonNull LocalDateTime localDateTime) throws IOException {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 22), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        RankingApi rankingApi = (RankingApi)retrofit.create(RankingApi.class);
        Call<DojangRankingResponseDTO> call = rankingApi.getDojangRanking(this.apiKey, date, worldName, difficulty, characterClass, ocid, page);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (DojangRankingResponseDTO)response.body();
    }

    public void getDojangRankingAsync(String worldName, int difficulty, String characterClass, String ocid, Integer page, SuccessCallback<DojangRankingResponseDTO> onSuccess, FailureCallback onFailure) {
        this.getDojangRankingAsync(worldName, difficulty, characterClass, ocid, page, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(8, 30, 0)), onSuccess, onFailure);
    }

    public void getDojangRankingAsync(String worldName, int difficulty, String characterClass, String ocid, Integer page, @NonNull LocalDateTime localDateTime, final SuccessCallback<DojangRankingResponseDTO> onSuccess, final FailureCallback onFailure) {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 22), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        RankingApi rankingApi = (RankingApi)retrofit.create(RankingApi.class);
        Call<DojangRankingResponseDTO> call = rankingApi.getDojangRanking(this.apiKey, date, worldName, difficulty, characterClass, ocid, page);
        call.enqueue((Callback)new Callback<DojangRankingResponseDTO>(){

            public void onResponse(Call<DojangRankingResponseDTO> call, Response<DojangRankingResponseDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<DojangRankingResponseDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public TheSeedRankingResponseDTO getTheSeedRanking(String worldName, String ocid, Integer page) throws IOException {
        return this.getTheSeedRanking(worldName, ocid, page, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(8, 30, 0)));
    }

    public TheSeedRankingResponseDTO getTheSeedRanking(String worldName, String ocid, Integer page, LocalDateTime localDateTime) throws IOException {
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 22), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        RankingApi rankingApi = (RankingApi)retrofit.create(RankingApi.class);
        return (TheSeedRankingResponseDTO)rankingApi.getTheSeedRanking(this.apiKey, date, worldName, ocid, page).execute().body();
    }

    public void getTheSeedRankingAsync(String worldName, String ocid, Integer page, SuccessCallback<TheSeedRankingResponseDTO> onSuccess, FailureCallback onFailure) {
        this.getTheSeedRankingAsync(worldName, ocid, page, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(8, 30, 0)), onSuccess, onFailure);
    }

    public void getTheSeedRankingAsync(String worldName, String ocid, Integer page, @NonNull LocalDateTime localDateTime, final SuccessCallback<TheSeedRankingResponseDTO> onSuccess, final FailureCallback onFailure) {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 22), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        RankingApi rankingApi = (RankingApi)retrofit.create(RankingApi.class);
        Call<TheSeedRankingResponseDTO> call = rankingApi.getTheSeedRanking(this.apiKey, date, worldName, ocid, page);
        call.enqueue((Callback)new Callback<TheSeedRankingResponseDTO>(){

            public void onResponse(Call<TheSeedRankingResponseDTO> call, Response<TheSeedRankingResponseDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<TheSeedRankingResponseDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public AchievementRankingResponseDTO getAchievementRanking(String ocid, Integer page) throws IOException {
        return this.getAchievementRanking(ocid, page, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(8, 30, 0)));
    }

    public AchievementRankingResponseDTO getAchievementRanking(String ocid, Integer page, @NonNull LocalDateTime localDateTime) throws IOException {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 22), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        RankingApi rankingApi = (RankingApi)retrofit.create(RankingApi.class);
        Call<AchievementRankingResponseDTO> call = rankingApi.getAchievementRanking(this.apiKey, date, ocid, page);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw MapleStoryApi.parseError(response);
        }
        return (AchievementRankingResponseDTO)response.body();
    }

    public void getAchievementRankingAsync(String ocid, Integer page, SuccessCallback<AchievementRankingResponseDTO> onSuccess, FailureCallback onFailure) {
        this.getAchievementRankingAsync(ocid, page, MapleStoryApi.getProperDefaultDateTime(new LatestApiUpdateTimeOption(8, 30, 0)), onSuccess, onFailure);
    }

    public void getAchievementRankingAsync(String ocid, Integer page, @NonNull LocalDateTime localDateTime, final SuccessCallback<AchievementRankingResponseDTO> onSuccess, final FailureCallback onFailure) {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        String date = MapleStoryApi.toDateString(MapleStoryApi.minDate(2023, 12, 22), localDateTime);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.buildClient()).build();
        RankingApi rankingApi = (RankingApi)retrofit.create(RankingApi.class);
        Call<AchievementRankingResponseDTO> call = rankingApi.getAchievementRanking(this.apiKey, date, ocid, page);
        call.enqueue((Callback)new Callback<AchievementRankingResponseDTO>(){

            public void onResponse(Call<AchievementRankingResponseDTO> call, Response<AchievementRankingResponseDTO> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(response.body());
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<AchievementRankingResponseDTO> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    public InspectionInfoDTO getInspectionInfo() throws IOException {
        String baseUrl = "https://api.maplestory.nexon.com/";
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.maplestory.nexon.com/").addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).client(this.buildClient()).build();
        String soapEnvelop = "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n  <soap:Body>\n    <GetInspectionInfo xmlns=\"https://api.maplestory.nexon.com/soap/\" />\n  </soap:Body>\n</soap:Envelope>";
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"text/xml; charset=utf-8"), (String)"<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n  <soap:Body>\n    <GetInspectionInfo xmlns=\"https://api.maplestory.nexon.com/soap/\" />\n  </soap:Body>\n</soap:Envelope>");
        InspectionInfoApi inspectionInfoApi = (InspectionInfoApi)retrofit.create(InspectionInfoApi.class);
        Call<String> call = inspectionInfoApi.getInspectionInfo(body);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw new MapleStoryApiException(MapleStoryApiErrorCode.OPENAPI00003, "Bad Request");
        }
        return new InspectionInfoDTO((String)response.body());
    }

    public void getInspectionInfo(final SuccessCallback<InspectionInfoDTO> onSuccess, final FailureCallback onFailure) {
        String baseUrl = "https://api.maplestory.nexon.com/";
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.maplestory.nexon.com/").addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).client(this.buildClient()).build();
        String soapEnvelop = "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n  <soap:Body>\n    <GetInspectionInfo xmlns=\"https://api.maplestory.nexon.com/soap/\" />\n  </soap:Body>\n</soap:Envelope>";
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"text/xml; charset=utf-8"), (String)"<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n  <soap:Body>\n    <GetInspectionInfo xmlns=\"https://api.maplestory.nexon.com/soap/\" />\n  </soap:Body>\n</soap:Envelope>");
        InspectionInfoApi inspectionInfoApi = (InspectionInfoApi)retrofit.create(InspectionInfoApi.class);
        Call<String> call = inspectionInfoApi.getInspectionInfo(body);
        call.enqueue((Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                if (response.isSuccessful()) {
                    if (onSuccess != null) {
                        onSuccess.callback(new InspectionInfoDTO((String)response.body()));
                    }
                } else if (onFailure != null) {
                    onFailure.callback(MapleStoryApi.parseError(response));
                }
            }

            public void onFailure(Call<String> call, Throwable t) {
                if (onFailure != null) {
                    onFailure.callback(t);
                }
            }
        });
    }

    private OkHttpClient buildClient() {
        return new OkHttpClient.Builder().readTimeout(this.timeout, TimeUnit.MILLISECONDS).connectTimeout(this.timeout, TimeUnit.MILLISECONDS).build();
    }

    private static MapleStoryApiException parseError(Response<?> response) throws IOException {
        Gson gson = new Gson();
        MapleStoryApiErrorBody error = (MapleStoryApiErrorBody)gson.fromJson(response.errorBody().string(), MapleStoryApiErrorBody.class);
        return new MapleStoryApiException(error);
    }

    private static LocalDateTime minDate(int year, int month, int day) {
        return LocalDateTime.of(year, month, day, 0, 0, 0, 0);
    }

    private static LocalDateTime getProperDefaultDateTime(LatestApiUpdateTimeOption option) {
        LocalDateTime updateDate;
        int hour = option.getHour();
        int minute = option.getMinute();
        Integer dateOffset = option.getDateOffset();
        LocalDateTime kstNow = LocalDateTime.now(ZoneId.of("Asia/Seoul"));
        LocalDateTime adjustedDateTime = kstNow.isAfter(updateDate = LocalDateTime.now(ZoneId.of("Asia/Seoul")).withHour(hour).withMinute(minute)) ? kstNow : kstNow.minusDays(1L);
        return adjustedDateTime.minusDays(dateOffset != null ? (long)dateOffset.intValue() : 0L);
    }

    private static String toDateString(@NonNull LocalDateTime minDate, @NonNull LocalDateTime date) {
        if (minDate == null) {
            throw new NullPointerException("minDate is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        int minYear = minDate.getYear();
        int minMonth = minDate.getMonthValue();
        int minDay = minDate.getDayOfMonth();
        int year = date.getYear();
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        if (year < minYear || year == minYear && month < minMonth || year == minYear && month == minMonth && day < minDay) {
            throw new IllegalArgumentException(String.format("You can only retrieve data after %d-%02d-%02d.", minYear, minMonth, minDay));
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String yyyyMMdd = date.format(formatter);
        return yyyyMMdd;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

