/*
 * Decompiled with CFR 0.152.
 */
package dev.spiralmoon.maplestory.api;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import lombok.NonNull;

public class Utils {
    public static LocalDateTime toLocalDateTime(@NonNull String date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        String[] patterns = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSX", "yyyy-MM-dd'T'HH:mmXXX", "yyyy-MM-dd"};
        LocalDateTime kstDateTime = null;
        for (String pattern : patterns) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
                if (pattern.equals("yyyy-MM-dd")) {
                    LocalDate localDate = LocalDate.parse(date, formatter);
                    kstDateTime = localDate.atStartOfDay().atZone(ZoneId.of("Asia/Seoul")).toLocalDateTime();
                    break;
                }
                kstDateTime = LocalDateTime.parse(date, formatter).atZone(ZoneId.of("Asia/Seoul")).toLocalDateTime();
                break;
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return kstDateTime;
    }
}

