/*
 * Decompiled with CFR 0.152.
 */
package dev.stratospheric.cdk;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Environment;
import software.amazon.awscdk.core.IConstruct;
import software.amazon.awscdk.core.Tags;
import software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetConfiguration;
import software.amazon.awscdk.services.ec2.SubnetType;
import software.amazon.awscdk.services.ec2.Vpc;
import software.amazon.awscdk.services.ecs.Cluster;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetGroupsProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCertificate;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.awscdk.services.ssm.StringParameter;

public class Network
extends Construct {
    private static final String PARAMETER_VPC_ID = "vpcId";
    private static final String PARAMETER_HTTP_LISTENER = "httpListenerArn";
    private static final String PARAMETER_HTTPS_LISTENER = "httpsListenerArn";
    private static final String PARAMETER_LOADBALANCER_SECURITY_GROUP_ID = "loadBalancerSecurityGroupId";
    private static final String PARAMETER_ECS_CLUSTER_NAME = "ecsClusterName";
    private static final String PARAMETER_ISOLATED_SUBNET_ONE = "isolatedSubnetIdOne";
    private static final String PARAMETER_ISOLATED_SUBNET_TWO = "isolatedSubnetIdTwo";
    private static final String PARAMETER_PUBLIC_SUBNET_ONE = "publicSubnetIdOne";
    private static final String PARAMETER_PUBLIC_SUBNET_TWO = "publicSubnetIdTwo";
    private static final String PARAMETER_AVAILABILITY_ZONE_ONE = "availabilityZoneOne";
    private static final String PARAMETER_AVAILABILITY_ZONE_TWO = "availabilityZoneTwo";
    private final IVpc vpc;
    private final String environmentName;
    private final ICluster ecsCluster;
    private IApplicationListener httpListener;
    private IApplicationListener httpsListener;
    private ISecurityGroup loadbalancerSecurityGroup;
    private IApplicationLoadBalancer loadBalancer;

    public Network(Construct scope, String id, Environment environment, String environmentName, NetworkInputParameters networkInputParameters) {
        super((software.constructs.Construct)scope, id);
        this.environmentName = environmentName;
        this.vpc = this.createVpc(environmentName);
        this.ecsCluster = Cluster.Builder.create((software.constructs.Construct)this, (String)"cluster").vpc(this.vpc).clusterName(this.prefixWithEnvironmentName("ecsCluster")).build();
        this.createLoadBalancer(this.vpc, networkInputParameters.getSslCertificateArn());
        Tags.of((IConstruct)this).add("environment", environmentName);
    }

    public static NetworkOutputParameters getOutputParametersFromParameterStore(Construct scope, String environmentName) {
        return new NetworkOutputParameters(Network.getVpcIdFromParameterStore(scope, environmentName), Network.getHttpListenerArnFromParameterStore(scope, environmentName), Network.getHttpsListenerArnFromParameterStore(scope, environmentName), Network.getLoadbalancerSecurityGroupIdFromParameterStore(scope, environmentName), Network.getEcsClusterNameFromParameterStore(scope, environmentName), Network.getIsolatedSubnetsFromParameterStore(scope, environmentName), Network.getPublicSubnetsFromParameterStore(scope, environmentName), Network.getAvailabilityZonesFromParameterStore(scope, environmentName));
    }

    @NotNull
    private static String createParameterName(String environmentName, String parameterName) {
        return environmentName + "-Network-" + parameterName;
    }

    private static String getVpcIdFromParameterStore(Construct scope, String environmentName) {
        return StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_VPC_ID, (String)Network.createParameterName(environmentName, PARAMETER_VPC_ID)).getStringValue();
    }

    private static String getHttpListenerArnFromParameterStore(Construct scope, String environmentName) {
        return StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_HTTP_LISTENER, (String)Network.createParameterName(environmentName, PARAMETER_HTTP_LISTENER)).getStringValue();
    }

    private static Optional<String> getHttpsListenerArnFromParameterStore(Construct scope, String environmentName) {
        String value = StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_HTTPS_LISTENER, (String)Network.createParameterName(environmentName, PARAMETER_HTTPS_LISTENER)).getStringValue();
        if (value.equals("null")) {
            return Optional.empty();
        }
        return Optional.ofNullable(value);
    }

    private static String getLoadbalancerSecurityGroupIdFromParameterStore(Construct scope, String environmentName) {
        return StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_LOADBALANCER_SECURITY_GROUP_ID, (String)Network.createParameterName(environmentName, PARAMETER_LOADBALANCER_SECURITY_GROUP_ID)).getStringValue();
    }

    private static String getEcsClusterNameFromParameterStore(Construct scope, String environmentName) {
        return StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_ECS_CLUSTER_NAME, (String)Network.createParameterName(environmentName, PARAMETER_ECS_CLUSTER_NAME)).getStringValue();
    }

    private static List<String> getIsolatedSubnetsFromParameterStore(Construct scope, String environmentName) {
        String subnetOneId = StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_ISOLATED_SUBNET_ONE, (String)Network.createParameterName(environmentName, PARAMETER_ISOLATED_SUBNET_ONE)).getStringValue();
        String subnetTwoId = StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_ISOLATED_SUBNET_TWO, (String)Network.createParameterName(environmentName, PARAMETER_ISOLATED_SUBNET_TWO)).getStringValue();
        return Arrays.asList(subnetOneId, subnetTwoId);
    }

    private static List<String> getPublicSubnetsFromParameterStore(Construct scope, String environmentName) {
        String subnetOneId = StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_PUBLIC_SUBNET_ONE, (String)Network.createParameterName(environmentName, PARAMETER_PUBLIC_SUBNET_ONE)).getStringValue();
        String subnetTwoId = StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_PUBLIC_SUBNET_TWO, (String)Network.createParameterName(environmentName, PARAMETER_PUBLIC_SUBNET_TWO)).getStringValue();
        return Arrays.asList(subnetOneId, subnetTwoId);
    }

    private static List<String> getAvailabilityZonesFromParameterStore(Construct scope, String environmentName) {
        String availabilityZoneOne = StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_AVAILABILITY_ZONE_ONE, (String)Network.createParameterName(environmentName, PARAMETER_AVAILABILITY_ZONE_ONE)).getStringValue();
        String availabilityZoneTwo = StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_AVAILABILITY_ZONE_TWO, (String)Network.createParameterName(environmentName, PARAMETER_AVAILABILITY_ZONE_TWO)).getStringValue();
        return Arrays.asList(availabilityZoneOne, availabilityZoneTwo);
    }

    public IVpc getVpc() {
        return this.vpc;
    }

    public IApplicationListener getHttpListener() {
        return this.httpListener;
    }

    @Nullable
    public IApplicationListener getHttpsListener() {
        return this.httpsListener;
    }

    public ISecurityGroup getLoadbalancerSecurityGroup() {
        return this.loadbalancerSecurityGroup;
    }

    public IApplicationLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ICluster getEcsCluster() {
        return this.ecsCluster;
    }

    private IVpc createVpc(String environmentName) {
        SubnetConfiguration publicSubnets = SubnetConfiguration.builder().subnetType(SubnetType.PUBLIC).name(this.prefixWithEnvironmentName("publicSubnet")).build();
        SubnetConfiguration isolatedSubnets = SubnetConfiguration.builder().subnetType(SubnetType.ISOLATED).name(this.prefixWithEnvironmentName("isolatedSubnet")).build();
        return Vpc.Builder.create((software.constructs.Construct)this, (String)"vpc").natGateways((Number)0).maxAzs((Number)2).subnetConfiguration(Arrays.asList(publicSubnets, isolatedSubnets)).build();
    }

    private String prefixWithEnvironmentName(String string) {
        return this.environmentName + "-" + string;
    }

    private void createLoadBalancer(IVpc vpc, Optional<String> sslCertificateArn) {
        this.loadbalancerSecurityGroup = SecurityGroup.Builder.create((software.constructs.Construct)this, (String)"loadbalancerSecurityGroup").securityGroupName(this.prefixWithEnvironmentName("loadbalancerSecurityGroup")).description("Public access to the load balancer.").vpc(vpc).build();
        CfnSecurityGroupIngress ingressFromPublic = CfnSecurityGroupIngress.Builder.create((Construct)this, (String)"ingressToLoadbalancer").groupId(this.loadbalancerSecurityGroup.getSecurityGroupId()).cidrIp("0.0.0.0/0").ipProtocol("-1").build();
        this.loadBalancer = ApplicationLoadBalancer.Builder.create((software.constructs.Construct)this, (String)"loadbalancer").loadBalancerName(this.prefixWithEnvironmentName("loadbalancer")).vpc(vpc).internetFacing(Boolean.valueOf(true)).securityGroup(this.loadbalancerSecurityGroup).build();
        ApplicationTargetGroup dummyTargetGroup = ApplicationTargetGroup.Builder.create((software.constructs.Construct)this, (String)"dummyTargetGroup").vpc(vpc).port((Number)8080).protocol(ApplicationProtocol.HTTP).targetGroupName(this.prefixWithEnvironmentName("no-op-targetGroup")).targetType(TargetType.IP).build();
        this.httpListener = this.loadBalancer.addListener("httpListener", BaseApplicationListenerProps.builder().port((Number)80).protocol(ApplicationProtocol.HTTP).open(Boolean.valueOf(true)).build());
        this.httpListener.addTargetGroups("http-dummy", AddApplicationTargetGroupsProps.builder().targetGroups(Collections.singletonList(dummyTargetGroup)).build());
        if (sslCertificateArn.isPresent()) {
            ListenerCertificate certificate = ListenerCertificate.fromArn((String)sslCertificateArn.get());
            this.httpsListener = this.loadBalancer.addListener("httpsListener", BaseApplicationListenerProps.builder().port((Number)443).protocol(ApplicationProtocol.HTTPS).certificates(Collections.singletonList(certificate)).open(Boolean.valueOf(true)).build());
            this.httpsListener.addTargetGroups("https-dummy", AddApplicationTargetGroupsProps.builder().targetGroups(Collections.singletonList(dummyTargetGroup)).build());
        }
        this.createOutputParameters();
    }

    private void createOutputParameters() {
        StringParameter vpcId = StringParameter.Builder.create((software.constructs.Construct)this, (String)PARAMETER_VPC_ID).parameterName(Network.createParameterName(this.environmentName, PARAMETER_VPC_ID)).stringValue(this.vpc.getVpcId()).build();
        StringParameter httpListener = StringParameter.Builder.create((software.constructs.Construct)this, (String)"httpListener").parameterName(Network.createParameterName(this.environmentName, PARAMETER_HTTP_LISTENER)).stringValue(this.httpListener.getListenerArn()).build();
        StringParameter stringParameter = this.httpsListener != null ? StringParameter.Builder.create((software.constructs.Construct)this, (String)"httpsListener").parameterName(Network.createParameterName(this.environmentName, PARAMETER_HTTPS_LISTENER)).stringValue(this.httpsListener.getListenerArn()).build() : StringParameter.Builder.create((software.constructs.Construct)this, (String)"httpsListener").parameterName(Network.createParameterName(this.environmentName, PARAMETER_HTTPS_LISTENER)).stringValue("null").build();
        StringParameter loadbalancerSecurityGroup = StringParameter.Builder.create((software.constructs.Construct)this, (String)PARAMETER_LOADBALANCER_SECURITY_GROUP_ID).parameterName(Network.createParameterName(this.environmentName, PARAMETER_LOADBALANCER_SECURITY_GROUP_ID)).stringValue(this.loadbalancerSecurityGroup.getSecurityGroupId()).build();
        StringParameter cluster = StringParameter.Builder.create((software.constructs.Construct)this, (String)PARAMETER_ECS_CLUSTER_NAME).parameterName(Network.createParameterName(this.environmentName, PARAMETER_ECS_CLUSTER_NAME)).stringValue(this.ecsCluster.getClusterName()).build();
        StringParameter availabilityZoneOne = StringParameter.Builder.create((software.constructs.Construct)this, (String)PARAMETER_AVAILABILITY_ZONE_ONE).parameterName(Network.createParameterName(this.environmentName, PARAMETER_AVAILABILITY_ZONE_ONE)).stringValue((String)this.vpc.getAvailabilityZones().get(0)).build();
        StringParameter availabilityZoneTwo = StringParameter.Builder.create((software.constructs.Construct)this, (String)PARAMETER_AVAILABILITY_ZONE_TWO).parameterName(Network.createParameterName(this.environmentName, PARAMETER_AVAILABILITY_ZONE_TWO)).stringValue((String)this.vpc.getAvailabilityZones().get(1)).build();
        StringParameter isolatedSubnetOne = StringParameter.Builder.create((software.constructs.Construct)this, (String)"isolatedSubnetOne").parameterName(Network.createParameterName(this.environmentName, PARAMETER_ISOLATED_SUBNET_ONE)).stringValue(((ISubnet)this.vpc.getIsolatedSubnets().get(0)).getSubnetId()).build();
        StringParameter isolatedSubnetTwo = StringParameter.Builder.create((software.constructs.Construct)this, (String)"isolatedSubnetTwo").parameterName(Network.createParameterName(this.environmentName, PARAMETER_ISOLATED_SUBNET_TWO)).stringValue(((ISubnet)this.vpc.getIsolatedSubnets().get(1)).getSubnetId()).build();
        StringParameter publicSubnetOne = StringParameter.Builder.create((software.constructs.Construct)this, (String)"publicSubnetOne").parameterName(Network.createParameterName(this.environmentName, PARAMETER_PUBLIC_SUBNET_ONE)).stringValue(((ISubnet)this.vpc.getPublicSubnets().get(0)).getSubnetId()).build();
        StringParameter publicSubnetTwo = StringParameter.Builder.create((software.constructs.Construct)this, (String)"publicSubnetTwo").parameterName(Network.createParameterName(this.environmentName, PARAMETER_PUBLIC_SUBNET_TWO)).stringValue(((ISubnet)this.vpc.getPublicSubnets().get(1)).getSubnetId()).build();
    }

    public NetworkOutputParameters getOutputParameters() {
        return new NetworkOutputParameters(this.vpc.getVpcId(), this.httpListener.getListenerArn(), this.httpsListener != null ? Optional.of(this.httpsListener.getListenerArn()) : Optional.empty(), this.loadbalancerSecurityGroup.getSecurityGroupId(), this.ecsCluster.getClusterName(), this.vpc.getIsolatedSubnets().stream().map(ISubnet::getSubnetId).collect(Collectors.toList()), this.vpc.getPublicSubnets().stream().map(ISubnet::getSubnetId).collect(Collectors.toList()), this.vpc.getAvailabilityZones());
    }

    public static class NetworkOutputParameters {
        private final String vpcId;
        private final String httpListenerArn;
        private final Optional<String> httpsListenerArn;
        private final String loadbalancerSecurityGroupId;
        private final String ecsClusterName;
        private final List<String> isolatedSubnets;
        private final List<String> publicSubnets;
        private final List<String> availabilityZones;

        public NetworkOutputParameters(String vpcId, String httpListenerArn, Optional<String> httpsListenerArn, String loadbalancerSecurityGroupId, String ecsClusterName, List<String> isolatedSubnets, List<String> publicSubnets, List<String> availabilityZones) {
            this.vpcId = vpcId;
            this.httpListenerArn = httpListenerArn;
            this.httpsListenerArn = httpsListenerArn;
            this.loadbalancerSecurityGroupId = loadbalancerSecurityGroupId;
            this.ecsClusterName = ecsClusterName;
            this.isolatedSubnets = isolatedSubnets;
            this.publicSubnets = publicSubnets;
            this.availabilityZones = availabilityZones;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public String getHttpListenerArn() {
            return this.httpListenerArn;
        }

        public Optional<String> getHttpsListenerArn() {
            return this.httpsListenerArn;
        }

        public String getLoadbalancerSecurityGroupId() {
            return this.loadbalancerSecurityGroupId;
        }

        public String getEcsClusterName() {
            return this.ecsClusterName;
        }

        public List<String> getIsolatedSubnets() {
            return this.isolatedSubnets;
        }

        public List<String> getPublicSubnets() {
            return this.publicSubnets;
        }

        public List<String> getAvailabilityZones() {
            return this.availabilityZones;
        }
    }

    public static class NetworkInputParameters {
        private final Optional<String> sslCertificateArn;

        public NetworkInputParameters(String sslCertificateArn) {
            Objects.requireNonNull(sslCertificateArn);
            this.sslCertificateArn = Optional.of(sslCertificateArn);
        }

        public NetworkInputParameters() {
            this.sslCertificateArn = Optional.empty();
        }

        public Optional<String> getSslCertificateArn() {
            return this.sslCertificateArn;
        }
    }
}

