/*
 * Decompiled with CFR 0.152.
 */
package dev.stratospheric.cdk;

import dev.stratospheric.cdk.ApplicationEnvironment;
import dev.stratospheric.cdk.Network;
import dev.stratospheric.cdk.Service;
import java.util.Collections;
import software.amazon.awscdk.core.CfnOutput;
import software.amazon.awscdk.core.CfnOutputProps;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Environment;
import software.amazon.awscdk.core.Stack;
import software.amazon.awscdk.core.StackProps;

public class SpringBootApplicationStack
extends Stack {
    public SpringBootApplicationStack(Construct scope, String id, Environment environment, String dockerImageUrl) {
        super((software.constructs.Construct)scope, id, StackProps.builder().stackName("SpringBootApplication").env(environment).build());
        Network network = new Network((Construct)this, "network", environment, "prod", new Network.NetworkInputParameters());
        Service service = new Service((Construct)this, "Service", environment, new ApplicationEnvironment("SpringBootApplication", "prod"), new Service.ServiceInputParameters(new Service.DockerImageSource(dockerImageUrl), Collections.emptyList(), Collections.emptyMap()), network.getOutputParameters());
        CfnOutput httpsListenerOutput = new CfnOutput((software.constructs.Construct)this, "loadbalancerDnsName", CfnOutputProps.builder().exportName("loadbalancerDnsName").value(network.getLoadBalancer().getLoadBalancerDnsName()).build());
    }
}

