/*
 * Decompiled with CFR 0.152.
 */
package dev.stratospheric.cdk;

import dev.stratospheric.cdk.ApplicationEnvironment;
import dev.stratospheric.cdk.Network;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Environment;
import software.amazon.awscdk.core.IConstruct;
import software.amazon.awscdk.services.ec2.CfnSecurityGroup;
import software.amazon.awscdk.services.rds.CfnDBInstance;
import software.amazon.awscdk.services.rds.CfnDBSubnetGroup;
import software.amazon.awscdk.services.secretsmanager.CfnSecretTargetAttachment;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.Secret;
import software.amazon.awscdk.services.secretsmanager.SecretStringGenerator;
import software.amazon.awscdk.services.ssm.StringParameter;

public class PostgresDatabase
extends Construct {
    private static final String PARAMETER_ENDPOINT_ADDRESS = "endpointAddress";
    private static final String PARAMETER_ENDPOINT_PORT = "endpointPort";
    private static final String PARAMETER_DATABASE_NAME = "databaseName";
    private static final String PARAMETER_SECURITY_GROUP_ID = "securityGroupId";
    private static final String PARAMETER_SECRET_ARN = "secretArn";
    private final CfnSecurityGroup databaseSecurityGroup;
    private final CfnDBInstance dbInstance;
    private final ISecret databaseSecret;
    private final ApplicationEnvironment applicationEnvironment;

    public PostgresDatabase(Construct scope, String id, Environment awsEnvironment, ApplicationEnvironment applicationEnvironment, DatabaseInputParameters databaseInputParameters) {
        super((software.constructs.Construct)scope, id);
        this.applicationEnvironment = applicationEnvironment;
        Network.NetworkOutputParameters networkOutputParameters = Network.getOutputParametersFromParameterStore(this, applicationEnvironment.getEnvironmentName());
        String username = this.sanitizeDbName(applicationEnvironment.prefix("dbUser"));
        this.databaseSecurityGroup = CfnSecurityGroup.Builder.create((Construct)this, (String)"databaseSecurityGroup").vpcId(networkOutputParameters.getVpcId()).groupDescription("Security Group for the database instance").groupName(applicationEnvironment.prefix("dbSecurityGroup")).build();
        this.databaseSecret = Secret.Builder.create((software.constructs.Construct)this, (String)"databaseSecret").secretName(applicationEnvironment.prefix("DatabaseSecret")).description("Credentials to the RDS instance").generateSecretString(SecretStringGenerator.builder().secretStringTemplate(String.format("{\"username\": \"%s\"}", username)).generateStringKey("password").passwordLength((Number)32).excludeCharacters("@/\\\" ").build()).build();
        CfnDBSubnetGroup subnetGroup = CfnDBSubnetGroup.Builder.create((Construct)this, (String)"dbSubnetGroup").dbSubnetGroupDescription("Subnet group for the RDS instance").dbSubnetGroupName(applicationEnvironment.prefix("dbSubnetGroup")).subnetIds(networkOutputParameters.getIsolatedSubnets()).build();
        this.dbInstance = CfnDBInstance.Builder.create((Construct)this, (String)"postgresInstance").allocatedStorage(String.valueOf(databaseInputParameters.storageInGb)).availabilityZone(networkOutputParameters.getAvailabilityZones().get(0)).dbInstanceClass(databaseInputParameters.instanceClass).dbName(this.sanitizeDbName(applicationEnvironment.prefix("database"))).dbSubnetGroupName(subnetGroup.getDbSubnetGroupName()).engine("postgres").engineVersion(databaseInputParameters.postgresVersion).masterUsername(username).masterUserPassword(this.databaseSecret.secretValueFromJson("password").toString()).publiclyAccessible(Boolean.valueOf(false)).vpcSecurityGroups(Collections.singletonList(this.databaseSecurityGroup.getAttrGroupId())).build();
        CfnSecretTargetAttachment.Builder.create((Construct)this, (String)"secretTargetAttachment").secretId(this.databaseSecret.getSecretArn()).targetId(this.dbInstance.getRef()).targetType("AWS::RDS::DBInstance").build();
        this.createOutputParameters();
        applicationEnvironment.tag((IConstruct)this);
    }

    @NotNull
    private static String createParameterName(ApplicationEnvironment applicationEnvironment, String parameterName) {
        return applicationEnvironment.getEnvironmentName() + "-" + applicationEnvironment.getApplicationName() + "-Database-" + parameterName;
    }

    public static DatabaseOutputParameters getOutputParametersFromParameterStore(Construct scope, ApplicationEnvironment environment) {
        return new DatabaseOutputParameters(PostgresDatabase.getEndpointAddress(scope, environment), PostgresDatabase.getEndpointPort(scope, environment), PostgresDatabase.getDbName(scope, environment), PostgresDatabase.getDatabaseSecretArn(scope, environment), PostgresDatabase.getDatabaseSecurityGroupId(scope, environment));
    }

    private static String getEndpointAddress(Construct scope, ApplicationEnvironment environment) {
        return StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_ENDPOINT_ADDRESS, (String)PostgresDatabase.createParameterName(environment, PARAMETER_ENDPOINT_ADDRESS)).getStringValue();
    }

    private static String getEndpointPort(Construct scope, ApplicationEnvironment environment) {
        return StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_ENDPOINT_PORT, (String)PostgresDatabase.createParameterName(environment, PARAMETER_ENDPOINT_PORT)).getStringValue();
    }

    private static String getDbName(Construct scope, ApplicationEnvironment environment) {
        return StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_DATABASE_NAME, (String)PostgresDatabase.createParameterName(environment, PARAMETER_DATABASE_NAME)).getStringValue();
    }

    private static String getDatabaseSecretArn(Construct scope, ApplicationEnvironment environment) {
        String secretArn = StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_SECRET_ARN, (String)PostgresDatabase.createParameterName(environment, PARAMETER_SECRET_ARN)).getStringValue();
        return secretArn;
    }

    private static String getDatabaseSecurityGroupId(Construct scope, ApplicationEnvironment environment) {
        String securityGroupId = StringParameter.fromStringParameterName((software.constructs.Construct)scope, (String)PARAMETER_SECURITY_GROUP_ID, (String)PostgresDatabase.createParameterName(environment, PARAMETER_SECURITY_GROUP_ID)).getStringValue();
        return securityGroupId;
    }

    private void createOutputParameters() {
        StringParameter endpointAddress = StringParameter.Builder.create((software.constructs.Construct)this, (String)PARAMETER_ENDPOINT_ADDRESS).parameterName(PostgresDatabase.createParameterName(this.applicationEnvironment, PARAMETER_ENDPOINT_ADDRESS)).stringValue(this.dbInstance.getAttrEndpointAddress()).build();
        StringParameter endpointPort = StringParameter.Builder.create((software.constructs.Construct)this, (String)PARAMETER_ENDPOINT_PORT).parameterName(PostgresDatabase.createParameterName(this.applicationEnvironment, PARAMETER_ENDPOINT_PORT)).stringValue(this.dbInstance.getAttrEndpointPort()).build();
        StringParameter databaseName = StringParameter.Builder.create((software.constructs.Construct)this, (String)PARAMETER_DATABASE_NAME).parameterName(PostgresDatabase.createParameterName(this.applicationEnvironment, PARAMETER_DATABASE_NAME)).stringValue(this.dbInstance.getDbName()).build();
        StringParameter securityGroupId = StringParameter.Builder.create((software.constructs.Construct)this, (String)PARAMETER_SECURITY_GROUP_ID).parameterName(PostgresDatabase.createParameterName(this.applicationEnvironment, PARAMETER_SECURITY_GROUP_ID)).stringValue(this.databaseSecurityGroup.getAttrGroupId()).build();
        StringParameter secret = StringParameter.Builder.create((software.constructs.Construct)this, (String)"secret").parameterName(PostgresDatabase.createParameterName(this.applicationEnvironment, PARAMETER_SECRET_ARN)).stringValue(this.databaseSecret.getSecretArn()).build();
    }

    private String sanitizeDbName(String dbName) {
        return dbName.replaceAll("[^a-zA-Z0-9]", "").replaceAll("^[0-9]", "a");
    }

    public DatabaseOutputParameters getOutputParameters() {
        return new DatabaseOutputParameters(this.dbInstance.getAttrEndpointAddress(), this.dbInstance.getAttrEndpointPort(), this.dbInstance.getDbName(), this.databaseSecurityGroup.getAttrGroupId(), this.databaseSecret.getSecretArn());
    }

    public static class DatabaseOutputParameters {
        private final String endpointAddress;
        private final String endpointPort;
        private final String dbName;
        private final String databaseSecretArn;
        private final String databaseSecurityGroupId;

        public DatabaseOutputParameters(String endpointAddress, String endpointPort, String dbName, String databaseSecretArn, String databaseSecurityGroupId) {
            this.endpointAddress = endpointAddress;
            this.endpointPort = endpointPort;
            this.dbName = dbName;
            this.databaseSecretArn = databaseSecretArn;
            this.databaseSecurityGroupId = databaseSecurityGroupId;
        }

        public String getEndpointAddress() {
            return this.endpointAddress;
        }

        public String getEndpointPort() {
            return this.endpointPort;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getDatabaseSecretArn() {
            return this.databaseSecretArn;
        }

        public String getDatabaseSecurityGroupId() {
            return this.databaseSecurityGroupId;
        }
    }

    public static class DatabaseInputParameters {
        private int storageInGb = 20;
        private String instanceClass = "db.t2.micro";
        private String postgresVersion = "11.5";

        public DatabaseInputParameters withStorageInGb(int storageInGb) {
            this.storageInGb = storageInGb;
            return this;
        }

        public DatabaseInputParameters withInstanceClass(String instanceClass) {
            Objects.requireNonNull(instanceClass);
            this.instanceClass = instanceClass;
            return this;
        }

        public DatabaseInputParameters withPostgresVersion(String postgresVersion) {
            Objects.requireNonNull(postgresVersion);
            this.postgresVersion = postgresVersion;
            return this;
        }
    }
}

