/*
 * Decompiled with CFR 0.152.
 */
package dev.stratospheric.cdk;

import software.amazon.awscdk.Tags;
import software.constructs.IConstruct;

public class ApplicationEnvironment {
    private final String applicationName;
    private final String environmentName;

    public ApplicationEnvironment(String applicationName, String environmentName) {
        this.applicationName = applicationName;
        this.environmentName = environmentName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    private String sanitize(String environmentName) {
        return environmentName.replaceAll("[^a-zA-Z0-9-]", "");
    }

    public String toString() {
        return this.sanitize(this.environmentName + "-" + this.applicationName);
    }

    public String prefix(String string) {
        return this + "-" + string;
    }

    public String prefix(String string, int characterLimit) {
        String name = this + "-" + string;
        if (name.length() <= characterLimit) {
            return name;
        }
        return name.substring(name.length() - 21);
    }

    public void tag(IConstruct construct) {
        Tags.of((IConstruct)construct).add("environment", this.environmentName);
        Tags.of((IConstruct)construct).add("application", this.applicationName);
    }
}

