/*
 * Decompiled with CFR 0.152.
 */
package dev.stratospheric.cdk;

import dev.stratospheric.cdk.ApplicationEnvironment;
import dev.stratospheric.cdk.Network;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awscdk.CfnCondition;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.Environment;
import software.amazon.awscdk.Fn;
import software.amazon.awscdk.ICfnConditionExpression;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.ec2.CfnSecurityGroup;
import software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress;
import software.amazon.awscdk.services.ecr.IRepository;
import software.amazon.awscdk.services.ecr.Repository;
import software.amazon.awscdk.services.ecs.CfnService;
import software.amazon.awscdk.services.ecs.CfnTaskDefinition;
import software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule;
import software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroup;
import software.amazon.awscdk.services.iam.Effect;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.awscdk.services.iam.ServicePrincipal;
import software.amazon.awscdk.services.logs.LogGroup;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.constructs.Construct;
import software.constructs.IConstruct;

public class Service
extends Construct {
    public Service(Construct scope, String id, Environment awsEnvironment, ApplicationEnvironment applicationEnvironment, ServiceInputParameters serviceInputParameters, Network.NetworkOutputParameters networkOutputParameters) {
        super(scope, id);
        List<CfnTargetGroup.TargetGroupAttributeProperty> stickySessionConfiguration = Arrays.asList(CfnTargetGroup.TargetGroupAttributeProperty.builder().key("stickiness.enabled").value("true").build(), CfnTargetGroup.TargetGroupAttributeProperty.builder().key("stickiness.type").value("lb_cookie").build(), CfnTargetGroup.TargetGroupAttributeProperty.builder().key("stickiness.lb_cookie.duration_seconds").value("3600").build());
        List<CfnTargetGroup.TargetGroupAttributeProperty> deregistrationDelayConfiguration = List.of(CfnTargetGroup.TargetGroupAttributeProperty.builder().key("deregistration_delay.timeout_seconds").value("5").build());
        ArrayList<CfnTargetGroup.TargetGroupAttributeProperty> targetGroupAttributes = new ArrayList<CfnTargetGroup.TargetGroupAttributeProperty>(deregistrationDelayConfiguration);
        if (serviceInputParameters.stickySessionsEnabled) {
            targetGroupAttributes.addAll(stickySessionConfiguration);
        }
        CfnTargetGroup targetGroup = CfnTargetGroup.Builder.create((Construct)this, (String)"targetGroup").healthCheckIntervalSeconds((Number)serviceInputParameters.healthCheckIntervalSeconds).healthCheckPath(serviceInputParameters.healthCheckPath).healthCheckPort(String.valueOf(serviceInputParameters.containerPort)).healthCheckProtocol(serviceInputParameters.containerProtocol).healthCheckTimeoutSeconds((Number)serviceInputParameters.healthCheckTimeoutSeconds).healthyThresholdCount((Number)serviceInputParameters.healthyThresholdCount).unhealthyThresholdCount((Number)serviceInputParameters.unhealthyThresholdCount).targetGroupAttributes(targetGroupAttributes).targetType("ip").port((Number)serviceInputParameters.containerPort).protocol(serviceInputParameters.containerProtocol).vpcId(networkOutputParameters.getVpcId()).build();
        CfnListenerRule.ActionProperty actionProperty = CfnListenerRule.ActionProperty.builder().targetGroupArn(targetGroup.getRef()).type("forward").build();
        CfnListenerRule.RuleConditionProperty condition = CfnListenerRule.RuleConditionProperty.builder().field("path-pattern").values(Collections.singletonList("*")).build();
        Optional<String> httpsListenerArn = networkOutputParameters.getHttpsListenerArn();
        if (httpsListenerArn.isPresent()) {
            CfnListenerRule httpsListenerRule = CfnListenerRule.Builder.create((Construct)this, (String)"httpsListenerRule").actions(Collections.singletonList(actionProperty)).conditions(Collections.singletonList(condition)).listenerArn(httpsListenerArn.get()).priority((Number)1).build();
            CfnCondition httpsListenerRuleCondition = CfnCondition.Builder.create((Construct)this, (String)"httpsListenerRuleCondition").expression((ICfnConditionExpression)Fn.conditionNot((ICfnConditionExpression)Fn.conditionEquals((Object)httpsListenerArn.get(), (Object)"null"))).build();
            httpsListenerRule.getCfnOptions().setCondition(httpsListenerRuleCondition);
        }
        CfnListenerRule httpListenerRule = CfnListenerRule.Builder.create((Construct)this, (String)"httpListenerRule").actions(Collections.singletonList(actionProperty)).conditions(Collections.singletonList(condition)).listenerArn(networkOutputParameters.getHttpListenerArn()).priority((Number)2).build();
        LogGroup logGroup = LogGroup.Builder.create((Construct)this, (String)"ecsLogGroup").logGroupName(applicationEnvironment.prefix("logs")).retention(serviceInputParameters.logRetention).removalPolicy(RemovalPolicy.DESTROY).build();
        Role ecsTaskExecutionRole = Role.Builder.create((Construct)this, (String)"ecsTaskExecutionRole").assumedBy((IPrincipal)ServicePrincipal.Builder.create((String)"ecs-tasks.amazonaws.com").build()).path("/").inlinePolicies(Map.of(applicationEnvironment.prefix("ecsTaskExecutionRolePolicy"), PolicyDocument.Builder.create().statements(Collections.singletonList(PolicyStatement.Builder.create().effect(Effect.ALLOW).resources(Collections.singletonList("*")).actions(Arrays.asList("ecr:GetAuthorizationToken", "ecr:BatchCheckLayerAvailability", "ecr:GetDownloadUrlForLayer", "ecr:BatchGetImage", "logs:CreateLogStream", "logs:PutLogEvents")).build())).build())).build();
        Role.Builder roleBuilder = Role.Builder.create((Construct)this, (String)"ecsTaskRole").assumedBy((IPrincipal)ServicePrincipal.Builder.create((String)"ecs-tasks.amazonaws.com").build()).path("/");
        if (!serviceInputParameters.taskRolePolicyStatements.isEmpty()) {
            roleBuilder.inlinePolicies(Map.of(applicationEnvironment.prefix("ecsTaskRolePolicy"), PolicyDocument.Builder.create().statements(serviceInputParameters.taskRolePolicyStatements).build()));
        }
        Role ecsTaskRole = roleBuilder.build();
        String dockerRepositoryUrl = null;
        if (serviceInputParameters.dockerImageSource.isEcrSource()) {
            IRepository dockerRepository = Repository.fromRepositoryName((Construct)this, (String)"ecrRepository", (String)serviceInputParameters.dockerImageSource.getDockerRepositoryName());
            dockerRepository.grantPull((IGrantable)ecsTaskExecutionRole);
            dockerRepositoryUrl = dockerRepository.repositoryUriForTag(serviceInputParameters.dockerImageSource.getDockerImageTag());
        } else {
            dockerRepositoryUrl = serviceInputParameters.dockerImageSource.dockerImageUrl;
        }
        CfnTaskDefinition.ContainerDefinitionProperty container = CfnTaskDefinition.ContainerDefinitionProperty.builder().name(this.containerName(applicationEnvironment)).cpu((Number)serviceInputParameters.cpu).memory((Number)serviceInputParameters.memory).image(dockerRepositoryUrl).logConfiguration(CfnTaskDefinition.LogConfigurationProperty.builder().logDriver("awslogs").options(Map.of("awslogs-group", logGroup.getLogGroupName(), "awslogs-region", awsEnvironment.getRegion(), "awslogs-stream-prefix", applicationEnvironment.prefix("stream"), "awslogs-datetime-format", serviceInputParameters.awslogsDateTimeFormat)).build()).portMappings(Collections.singletonList(CfnTaskDefinition.PortMappingProperty.builder().containerPort((Number)serviceInputParameters.containerPort).build())).environment(this.toKeyValuePairs(serviceInputParameters.environmentVariables)).stopTimeout((Number)2).build();
        CfnTaskDefinition taskDefinition = CfnTaskDefinition.Builder.create((Construct)this, (String)"taskDefinition").cpu(String.valueOf(serviceInputParameters.cpu)).memory(String.valueOf(serviceInputParameters.memory)).networkMode("awsvpc").requiresCompatibilities(Collections.singletonList("FARGATE")).executionRoleArn(ecsTaskExecutionRole.getRoleArn()).taskRoleArn(ecsTaskRole.getRoleArn()).containerDefinitions(Collections.singletonList(container)).build();
        CfnSecurityGroup ecsSecurityGroup = CfnSecurityGroup.Builder.create((Construct)this, (String)"ecsSecurityGroup").vpcId(networkOutputParameters.getVpcId()).groupDescription("SecurityGroup for the ECS containers").build();
        CfnSecurityGroupIngress ecsIngressFromSelf = CfnSecurityGroupIngress.Builder.create((Construct)this, (String)"ecsIngressFromSelf").ipProtocol("-1").sourceSecurityGroupId(ecsSecurityGroup.getAttrGroupId()).groupId(ecsSecurityGroup.getAttrGroupId()).build();
        CfnSecurityGroupIngress ecsIngressFromLoadbalancer = CfnSecurityGroupIngress.Builder.create((Construct)this, (String)"ecsIngressFromLoadbalancer").ipProtocol("-1").sourceSecurityGroupId(networkOutputParameters.getLoadbalancerSecurityGroupId()).groupId(ecsSecurityGroup.getAttrGroupId()).build();
        this.allowIngressFromEcs(serviceInputParameters.securityGroupIdsToGrantIngressFromEcs, ecsSecurityGroup);
        CfnService service = CfnService.Builder.create((Construct)this, (String)"ecsService").cluster(networkOutputParameters.getEcsClusterName()).launchType("FARGATE").deploymentConfiguration(CfnService.DeploymentConfigurationProperty.builder().maximumPercent((Number)serviceInputParameters.maximumInstancesPercent).minimumHealthyPercent((Number)serviceInputParameters.minimumHealthyInstancesPercent).build()).desiredCount((Number)serviceInputParameters.desiredInstancesCount).taskDefinition(taskDefinition.getRef()).loadBalancers(Collections.singletonList(CfnService.LoadBalancerProperty.builder().containerName(this.containerName(applicationEnvironment)).containerPort((Number)serviceInputParameters.containerPort).targetGroupArn(targetGroup.getRef()).build())).networkConfiguration(CfnService.NetworkConfigurationProperty.builder().awsvpcConfiguration(CfnService.AwsVpcConfigurationProperty.builder().assignPublicIp("ENABLED").securityGroups(Collections.singletonList(ecsSecurityGroup.getAttrGroupId())).subnets(networkOutputParameters.getPublicSubnets()).build()).build()).build();
        service.addDependsOn((CfnResource)httpListenerRule);
        applicationEnvironment.tag((IConstruct)this);
    }

    private void allowIngressFromEcs(List<String> securityGroupIds, CfnSecurityGroup ecsSecurityGroup) {
        int i = 1;
        for (String securityGroupId : securityGroupIds) {
            CfnSecurityGroupIngress ingress = CfnSecurityGroupIngress.Builder.create((Construct)this, (String)("securityGroupIngress" + i)).sourceSecurityGroupId(ecsSecurityGroup.getAttrGroupId()).groupId(securityGroupId).ipProtocol("-1").build();
            ++i;
        }
    }

    private String containerName(ApplicationEnvironment applicationEnvironment) {
        return applicationEnvironment.prefix("container");
    }

    private CfnTaskDefinition.KeyValuePairProperty keyValuePair(String key, String value) {
        return CfnTaskDefinition.KeyValuePairProperty.builder().name(key).value(value).build();
    }

    public List<CfnTaskDefinition.KeyValuePairProperty> toKeyValuePairs(Map<String, String> map) {
        ArrayList<CfnTaskDefinition.KeyValuePairProperty> keyValuePairs = new ArrayList<CfnTaskDefinition.KeyValuePairProperty>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            keyValuePairs.add(this.keyValuePair(entry.getKey(), entry.getValue()));
        }
        return keyValuePairs;
    }

    public static class ServiceInputParameters {
        private final DockerImageSource dockerImageSource;
        private final Map<String, String> environmentVariables;
        private final List<String> securityGroupIdsToGrantIngressFromEcs;
        private List<PolicyStatement> taskRolePolicyStatements = new ArrayList<PolicyStatement>();
        private int healthCheckIntervalSeconds = 5;
        private String healthCheckPath = "/";
        private int containerPort = 8080;
        private String containerProtocol = "HTTP";
        private int healthCheckTimeoutSeconds = 5;
        private int healthyThresholdCount = 2;
        private int unhealthyThresholdCount = 8;
        private RetentionDays logRetention = RetentionDays.ONE_WEEK;
        private int cpu = 256;
        private int memory = 512;
        private int desiredInstancesCount = 2;
        private int maximumInstancesPercent = 200;
        private int minimumHealthyInstancesPercent = 50;
        private boolean stickySessionsEnabled = false;
        private String awslogsDateTimeFormat = "%Y-%m-%dT%H:%M:%S.%f%z";

        public ServiceInputParameters(DockerImageSource dockerImageSource, List<String> securityGroupIdsToGrantIngressFromEcs, Map<String, String> environmentVariables) {
            this.dockerImageSource = dockerImageSource;
            this.environmentVariables = environmentVariables;
            this.securityGroupIdsToGrantIngressFromEcs = securityGroupIdsToGrantIngressFromEcs;
        }

        public ServiceInputParameters(DockerImageSource dockerImageSource, Map<String, String> environmentVariables) {
            this.dockerImageSource = dockerImageSource;
            this.environmentVariables = environmentVariables;
            this.securityGroupIdsToGrantIngressFromEcs = Collections.emptyList();
        }

        public ServiceInputParameters withHealthCheckIntervalSeconds(int healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public ServiceInputParameters withHealthCheckPath(String healthCheckPath) {
            Objects.requireNonNull(healthCheckPath);
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public ServiceInputParameters withContainerPort(int containerPort) {
            Objects.requireNonNull(containerPort);
            this.containerPort = containerPort;
            return this;
        }

        public ServiceInputParameters withContainerProtocol(String containerProtocol) {
            Objects.requireNonNull(containerProtocol);
            this.containerProtocol = containerProtocol;
            return this;
        }

        public ServiceInputParameters withHealthCheckTimeoutSeconds(int healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public ServiceInputParameters withHealthyThresholdCount(int healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public ServiceInputParameters withUnhealthyThresholdCount(int unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public ServiceInputParameters withCpu(int cpu) {
            this.cpu = cpu;
            return this;
        }

        public ServiceInputParameters withMemory(int memory) {
            this.memory = memory;
            return this;
        }

        public ServiceInputParameters withLogRetention(RetentionDays logRetention) {
            Objects.requireNonNull(logRetention);
            this.logRetention = logRetention;
            return this;
        }

        public ServiceInputParameters withDesiredInstances(int desiredInstances) {
            this.desiredInstancesCount = desiredInstances;
            return this;
        }

        public ServiceInputParameters withMaximumInstancesPercent(int maximumInstancesPercent) {
            this.maximumInstancesPercent = maximumInstancesPercent;
            return this;
        }

        public ServiceInputParameters withMinimumHealthyInstancesPercent(int minimumHealthyInstancesPercent) {
            this.minimumHealthyInstancesPercent = minimumHealthyInstancesPercent;
            return this;
        }

        public ServiceInputParameters withTaskRolePolicyStatements(List<PolicyStatement> taskRolePolicyStatements) {
            this.taskRolePolicyStatements = taskRolePolicyStatements;
            return this;
        }

        public ServiceInputParameters withStickySessionsEnabled(boolean stickySessionsEnabled) {
            this.stickySessionsEnabled = stickySessionsEnabled;
            return this;
        }

        public ServiceInputParameters withAwsLogsDateTimeFormat(String awsLogsDateTimeFormat) {
            this.awslogsDateTimeFormat = awsLogsDateTimeFormat;
            return this;
        }
    }

    public static class DockerImageSource {
        private final String dockerRepositoryName;
        private final String dockerImageTag;
        private final String dockerImageUrl;

        public DockerImageSource(String dockerImageUrl) {
            Objects.requireNonNull(dockerImageUrl);
            this.dockerImageUrl = dockerImageUrl;
            this.dockerImageTag = null;
            this.dockerRepositoryName = null;
        }

        public DockerImageSource(String dockerRepositoryName, String dockerImageTag) {
            Objects.requireNonNull(dockerRepositoryName);
            Objects.requireNonNull(dockerImageTag);
            this.dockerRepositoryName = dockerRepositoryName;
            this.dockerImageTag = dockerImageTag;
            this.dockerImageUrl = null;
        }

        public boolean isEcrSource() {
            return this.dockerRepositoryName != null;
        }

        public String getDockerRepositoryName() {
            return this.dockerRepositoryName;
        }

        public String getDockerImageTag() {
            return this.dockerImageTag;
        }

        public String getDockerImageUrl() {
            return this.dockerImageUrl;
        }
    }
}

