/*
 * Decompiled with CFR 0.152.
 */
package dev.stratospheric.cdk;

import java.util.Collections;
import java.util.Objects;
import software.amazon.awscdk.Environment;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.ecr.IRepository;
import software.amazon.awscdk.services.ecr.LifecycleRule;
import software.amazon.awscdk.services.ecr.Repository;
import software.amazon.awscdk.services.iam.AccountPrincipal;
import software.amazon.awscdk.services.iam.IGrantable;
import software.constructs.Construct;

public class DockerRepository
extends Construct {
    private final IRepository ecrRepository;

    public DockerRepository(Construct scope, String id, Environment awsEnvironment, DockerRepositoryInputParameters dockerRepositoryInputParameters) {
        super(scope, id);
        this.ecrRepository = Repository.Builder.create((Construct)this, (String)"ecrRepository").repositoryName(dockerRepositoryInputParameters.dockerRepositoryName).removalPolicy(dockerRepositoryInputParameters.retainRegistryOnDelete ? RemovalPolicy.RETAIN : RemovalPolicy.DESTROY).lifecycleRules(Collections.singletonList(LifecycleRule.builder().rulePriority((Number)1).description("limit to " + dockerRepositoryInputParameters.maxImageCount + " images").maxImageCount((Number)dockerRepositoryInputParameters.maxImageCount).build())).build();
        this.ecrRepository.grantPullPush((IGrantable)new AccountPrincipal((Object)dockerRepositoryInputParameters.accountId));
    }

    public IRepository getEcrRepository() {
        return this.ecrRepository;
    }

    public static class DockerRepositoryInputParameters {
        private final String dockerRepositoryName;
        private final String accountId;
        private final int maxImageCount;
        private final boolean retainRegistryOnDelete;

        public DockerRepositoryInputParameters(String dockerRepositoryName, String accountId) {
            this.dockerRepositoryName = dockerRepositoryName;
            this.accountId = accountId;
            this.maxImageCount = 10;
            this.retainRegistryOnDelete = true;
        }

        public DockerRepositoryInputParameters(String dockerRepositoryName, String accountId, int maxImageCount) {
            Objects.requireNonNull(accountId, "accountId must not be null");
            Objects.requireNonNull(dockerRepositoryName, "dockerRepositoryName must not be null");
            this.accountId = accountId;
            this.maxImageCount = maxImageCount;
            this.dockerRepositoryName = dockerRepositoryName;
            this.retainRegistryOnDelete = true;
        }

        public DockerRepositoryInputParameters(String dockerRepositoryName, String accountId, int maxImageCount, boolean retainRegistryOnDelete) {
            Objects.requireNonNull(accountId, "accountId must not be null");
            Objects.requireNonNull(dockerRepositoryName, "dockerRepositoryName must not be null");
            this.accountId = accountId;
            this.maxImageCount = maxImageCount;
            this.dockerRepositoryName = dockerRepositoryName;
            this.retainRegistryOnDelete = retainRegistryOnDelete;
        }
    }
}

