/*
 * Decompiled with CFR 0.152.
 */
package dev.stratospheric.cdk;

import dev.stratospheric.cdk.ApplicationEnvironment;
import dev.stratospheric.cdk.Network;
import dev.stratospheric.cdk.PostgresDatabase;
import java.util.Collections;
import java.util.Objects;
import software.amazon.awscdk.CfnOutput;
import software.amazon.awscdk.Environment;
import software.amazon.awscdk.services.ec2.CfnInstance;
import software.amazon.awscdk.services.ec2.CfnSecurityGroup;
import software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress;
import software.constructs.Construct;
import software.constructs.IConstruct;

public class JumpHost
extends Construct {
    private final ApplicationEnvironment applicationEnvironment;

    public JumpHost(Construct scope, String id, Environment environment, ApplicationEnvironment applicationEnvironment, JumpHostInputParameters jumpHostInputParameters, PostgresDatabase.DatabaseOutputParameters databaseOutputParameters) {
        super(scope, id);
        this.applicationEnvironment = applicationEnvironment;
        Network.NetworkOutputParameters networkOutputParameters = Network.getOutputParametersFromParameterStore(this, applicationEnvironment.getEnvironmentName());
        CfnSecurityGroup jumpHostSecurityGroup = CfnSecurityGroup.Builder.create((Construct)this, (String)"securityGroup").groupName(applicationEnvironment.prefix("jumpHostSecurityGroup")).groupDescription("SecurityGroup containing the jump host").vpcId(networkOutputParameters.getVpcId()).build();
        String databaseSecurityGroupId = databaseOutputParameters.getDatabaseSecurityGroupId();
        this.allowAccessToJumpHost(jumpHostSecurityGroup);
        this.allowAccessToDatabase(jumpHostSecurityGroup, databaseSecurityGroupId);
        CfnInstance instance = this.createEc2Instance(jumpHostInputParameters.keyName, jumpHostSecurityGroup, networkOutputParameters);
        CfnOutput publicIpOutput = CfnOutput.Builder.create((Construct)this, (String)"publicIp").value(instance.getAttrPublicIp()).build();
        applicationEnvironment.tag((IConstruct)this);
    }

    private CfnInstance createEc2Instance(String keyName, CfnSecurityGroup jumpHostSecurityGroup, Network.NetworkOutputParameters networkOutputParameters) {
        return CfnInstance.Builder.create((Construct)this, (String)"jumpHostInstance").instanceType("t2.nano").securityGroupIds(Collections.singletonList(jumpHostSecurityGroup.getAttrGroupId())).imageId("ami-0f96495a064477ffb").subnetId(networkOutputParameters.getPublicSubnets().get(0)).keyName(keyName).build();
    }

    private void allowAccessToDatabase(CfnSecurityGroup fromSecurityGroup, String toSecurityGroupId) {
        CfnSecurityGroupIngress dbSecurityGroupIngress = CfnSecurityGroupIngress.Builder.create((Construct)this, (String)"IngressFromJumpHost").sourceSecurityGroupId(fromSecurityGroup.getAttrGroupId()).groupId(toSecurityGroupId).fromPort((Number)5432).toPort((Number)5432).ipProtocol("TCP").build();
    }

    private void allowAccessToJumpHost(CfnSecurityGroup jumpHostSecurityGroup) {
        CfnSecurityGroupIngress jumpHostSecurityGroupIngress = CfnSecurityGroupIngress.Builder.create((Construct)this, (String)"IngressFromOutside").groupId(jumpHostSecurityGroup.getAttrGroupId()).fromPort((Number)22).toPort((Number)22).ipProtocol("TCP").cidrIp("0.0.0.0/0").build();
    }

    public static class JumpHostInputParameters {
        private final String keyName;

        public JumpHostInputParameters(String keyName) {
            Objects.requireNonNull(keyName, "parameter 'keyName' cannot be null");
            this.keyName = keyName;
        }
    }
}

