/*
 * Decompiled with CFR 0.152.
 */
package dev.stratospheric.cdk;

import dev.stratospheric.cdk.ApplicationEnvironment;
import dev.stratospheric.cdk.Network;
import dev.stratospheric.cdk.Service;
import java.util.Collections;
import software.amazon.awscdk.CfnOutput;
import software.amazon.awscdk.CfnOutputProps;
import software.amazon.awscdk.Environment;
import software.amazon.awscdk.Stack;
import software.amazon.awscdk.StackProps;
import software.constructs.Construct;

public class SpringBootApplicationStack
extends Stack {
    public SpringBootApplicationStack(Construct scope, String id, Environment environment, String dockerImageUrl) {
        super(scope, id, StackProps.builder().stackName("SpringBootApplication").env(environment).build());
        Network network = new Network((Construct)this, "network", environment, "prod", new Network.NetworkInputParameters());
        Service service = new Service((Construct)this, "Service", environment, new ApplicationEnvironment("SpringBootApplication", "prod"), new Service.ServiceInputParameters(new Service.DockerImageSource(dockerImageUrl), Collections.emptyList(), Collections.emptyMap()), network.getOutputParameters());
        CfnOutput httpsListenerOutput = new CfnOutput((Construct)this, "loadbalancerDnsName", CfnOutputProps.builder().exportName("loadbalancerDnsName").value(network.getLoadBalancer().getLoadBalancerDnsName()).build());
    }
}

