/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.godfather.quarkus.data.repository.impl;

import dev.struchkov.godfather.quarkus.context.service.Pusher;
import dev.struchkov.godfather.quarkus.data.preser.AnswerSavePreservable;
import dev.struchkov.haiti.utils.Checker;
import io.smallrye.mutiny.Uni;
import java.util.HashMap;
import java.util.Map;

public class AnswerSaveMapPreservable<S>
implements AnswerSavePreservable<S> {
    private final Map<String, Map<String, S>> saveMap = new HashMap<String, Map<String, S>>();

    @Override
    public Uni<Void> save(String personId, String key, S save) {
        this.saveMap.computeIfAbsent(personId, k -> new HashMap()).put(key, save);
        return Uni.createFrom().voidItem();
    }

    @Override
    public Uni<S> getByKey(String personId, String key) {
        if (this.saveMap.containsKey(personId) && this.saveMap.get(personId).containsKey(key)) {
            return Uni.createFrom().item(this.saveMap.get(personId).get(key));
        }
        return Uni.createFrom().nullItem();
    }

    @Override
    public Uni<Map<String, S>> getAllSaveElement(String personId) {
        return Uni.createFrom().item(this.saveMap.get(personId));
    }

    @Override
    public Uni<Void> push(String personId, Pusher<S> pusher) {
        if (Checker.checkNotNull(pusher)) {
            return this.getAllSaveElement(personId).onItem().transformToUni(allItems -> {
                if (Checker.checkNotEmpty((Object[])new Object[]{allItems})) {
                    return pusher.push(personId, allItems);
                }
                return Uni.createFrom().nullItem();
            });
        }
        return Uni.createFrom().voidItem();
    }
}

