/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.godfather.quarkus.data.repository.impl;

import dev.struchkov.godfather.main.domain.StorylineHistory;
import dev.struchkov.godfather.quarkus.context.repository.StorylineHistoryRepository;
import io.smallrye.mutiny.Uni;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class StorylineMapHistoryRepository
implements StorylineHistoryRepository {
    private final Map<String, Stack<StorylineHistory>> map = new HashMap<String, Stack<StorylineHistory>>();
    private final Map<String, Set<String>> historyUnitName = new HashMap<String, Set<String>>();

    public Uni<Void> save(@NotNull StorylineHistory history) {
        String personId = history.getPersonId();
        this.map.computeIfAbsent(personId, k -> new Stack()).push(history);
        this.historyUnitName.computeIfAbsent(personId, k -> new HashSet()).add(history.getUnitName());
        return Uni.createFrom().voidItem();
    }

    public Uni<StorylineHistory> findByCountLast(String personId, int countUnitsToBack) {
        if (this.map.containsKey(personId)) {
            Stack<StorylineHistory> stack = this.map.get(personId);
            if (stack.size() < countUnitsToBack) {
                countUnitsToBack = stack.size();
            }
            StorylineHistory storylineHistory = null;
            for (int i = 0; i < countUnitsToBack; ++i) {
                storylineHistory = stack.pop();
                this.historyUnitName.get(personId).remove(storylineHistory.getUnitName());
            }
            return Uni.createFrom().item(storylineHistory);
        }
        return Uni.createFrom().nullItem();
    }

    public Uni<StorylineHistory> findByCountLast(String personId, String unitName) {
        if (this.map.containsKey(personId)) {
            Stack<StorylineHistory> stack = this.map.get(personId);
            while (!stack.isEmpty() && this.historyUnitName.get(personId).contains(unitName)) {
                StorylineHistory storylineHistory = stack.pop();
                this.historyUnitName.get(personId).remove(storylineHistory.getUnitName());
                if (!unitName.equals(storylineHistory.getUnitName())) continue;
                return Uni.createFrom().item((Object)storylineHistory);
            }
        }
        return Uni.createFrom().nullItem();
    }

    public Uni<Void> cleanHistoryByPersonId(@NotNull String personId) {
        if (this.map.containsKey(personId)) {
            this.map.get(personId).clear();
        } else {
            this.map.put(personId, new Stack());
        }
        return Uni.createFrom().voidItem();
    }
}

