/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.openai.domain.chat;

import java.util.UUID;

public class ChatInfo {
    private UUID chatId;
    private Long contextConstraint;
    private String systemBehavior;

    public static ChatInfoBuilder builder() {
        return new ChatInfoBuilder();
    }

    public UUID getChatId() {
        return this.chatId;
    }

    public Long getContextConstraint() {
        return this.contextConstraint;
    }

    public String getSystemBehavior() {
        return this.systemBehavior;
    }

    public void setChatId(UUID chatId) {
        this.chatId = chatId;
    }

    public void setContextConstraint(Long contextConstraint) {
        this.contextConstraint = contextConstraint;
    }

    public void setSystemBehavior(String systemBehavior) {
        this.systemBehavior = systemBehavior;
    }

    public String toString() {
        return "ChatInfo(chatId=" + this.getChatId() + ", contextConstraint=" + this.getContextConstraint() + ")";
    }

    public ChatInfo() {
    }

    private ChatInfo(UUID chatId, Long contextConstraint, String systemBehavior) {
        this.chatId = chatId;
        this.contextConstraint = contextConstraint;
        this.systemBehavior = systemBehavior;
    }

    public static class ChatInfoBuilder {
        private UUID chatId;
        private Long contextConstraint;
        private String systemBehavior;

        ChatInfoBuilder() {
        }

        public ChatInfoBuilder chatId(UUID chatId) {
            this.chatId = chatId;
            return this;
        }

        public ChatInfoBuilder contextConstraint(Long contextConstraint) {
            this.contextConstraint = contextConstraint;
            return this;
        }

        public ChatInfoBuilder systemBehavior(String systemBehavior) {
            this.systemBehavior = systemBehavior;
            return this;
        }

        public ChatInfo build() {
            return new ChatInfo(this.chatId, this.contextConstraint, this.systemBehavior);
        }

        public String toString() {
            return "ChatInfo.ChatInfoBuilder(chatId=" + this.chatId + ", contextConstraint=" + this.contextConstraint + ", systemBehavior=" + this.systemBehavior + ")";
        }
    }
}

