/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.openai.domain.chat;

import java.util.UUID;

public class ChatMessage {
    private UUID messageId;
    private UUID chatId;
    private String role;
    private String message;

    ChatMessage(UUID messageId, UUID chatId, String role, String message) {
        this.messageId = messageId;
        this.chatId = chatId;
        this.role = role;
        this.message = message;
    }

    public static ChatMessageBuilder builder() {
        return new ChatMessageBuilder();
    }

    public UUID getMessageId() {
        return this.messageId;
    }

    public UUID getChatId() {
        return this.chatId;
    }

    public String getRole() {
        return this.role;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessageId(UUID messageId) {
        this.messageId = messageId;
    }

    public void setChatId(UUID chatId) {
        this.chatId = chatId;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static class ChatMessageBuilder {
        private UUID messageId;
        private UUID chatId;
        private String role;
        private String message;

        ChatMessageBuilder() {
        }

        public ChatMessageBuilder messageId(UUID messageId) {
            this.messageId = messageId;
            return this;
        }

        public ChatMessageBuilder chatId(UUID chatId) {
            this.chatId = chatId;
            return this;
        }

        public ChatMessageBuilder role(String role) {
            this.role = role;
            return this;
        }

        public ChatMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ChatMessage build() {
            return new ChatMessage(this.messageId, this.chatId, this.role, this.message);
        }

        public String toString() {
            return "ChatMessage.ChatMessageBuilder(messageId=" + this.messageId + ", chatId=" + this.chatId + ", role=" + this.role + ", message=" + this.message + ")";
        }
    }
}

