/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.openai.domain.common;

public class GptMessage {
    private String role;
    private String content;

    public static GptMessage fromUser(String content) {
        return GptMessage.builder().role("user").content(content).build();
    }

    public static GptMessage fromAssistant(String content) {
        return GptMessage.builder().role("assistant").content(content).build();
    }

    public static GptMessage fromSystem(String content) {
        return GptMessage.builder().role("system").content(content).build();
    }

    private static String $default$role() {
        return "user";
    }

    public static GptMessageBuilder builder() {
        return new GptMessageBuilder();
    }

    public String getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        return "GptMessage(role=" + this.getRole() + ", content=" + this.getContent() + ")";
    }

    public GptMessage() {
        this.role = GptMessage.$default$role();
    }

    private GptMessage(String role, String content) {
        this.role = role;
        this.content = content;
    }

    public static class GptMessageBuilder {
        private boolean role$set;
        private String role$value;
        private String content;

        GptMessageBuilder() {
        }

        public GptMessageBuilder role(String role) {
            this.role$value = role;
            this.role$set = true;
            return this;
        }

        public GptMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public GptMessage build() {
            String role$value = this.role$value;
            if (!this.role$set) {
                role$value = GptMessage.$default$role();
            }
            return new GptMessage(role$value, this.content);
        }

        public String toString() {
            return "GptMessage.GptMessageBuilder(role$value=" + this.role$value + ", content=" + this.content + ")";
        }
    }
}

