/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.openai.domain.conf;

import dev.struchkov.openai.domain.conf.OpenAIConfig;
import dev.struchkov.openai.domain.model.gpt.GPTModel;

public class GPTConfig
extends OpenAIConfig {
    public GPTConfig(String url, String token, String organisation, GPTModel aiModel) {
        super(url, token, organisation, aiModel);
    }

    public static GPTConfigBuilder builder() {
        return new GPTConfigBuilder();
    }

    public GPTConfig() {
    }

    public static class GPTConfigBuilder {
        private String url;
        private String token;
        private String organisation;
        private GPTModel aiModel;

        GPTConfigBuilder() {
        }

        public GPTConfigBuilder url(String url) {
            this.url = url;
            return this;
        }

        public GPTConfigBuilder token(String token) {
            this.token = token;
            return this;
        }

        public GPTConfigBuilder organisation(String organisation) {
            this.organisation = organisation;
            return this;
        }

        public GPTConfigBuilder aiModel(GPTModel aiModel) {
            this.aiModel = aiModel;
            return this;
        }

        public GPTConfig build() {
            return new GPTConfig(this.url, this.token, this.organisation, this.aiModel);
        }

        public String toString() {
            return "GPTConfig.GPTConfigBuilder(url=" + this.url + ", token=" + this.token + ", organisation=" + this.organisation + ", aiModel=" + this.aiModel + ")";
        }
    }
}

