/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.openai.domain.model.gpt;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.struchkov.openai.domain.model.gpt.GPTModel;
import java.util.Arrays;

public enum GPT3Model implements GPTModel
{
    GPT_3_5_TURBO("gpt-3.5-turbo", 2.0E-6),
    GPT_3_5_TURBO_0301("gpt-3.5-turbo-0301", 2.0E-6),
    TEXT_DAVINCI_003("text-davinci-003", 2.0E-6),
    TEXT_DAVINCI_002("text-davinci-002", 2.0E-6);

    private final String value;
    private final double price;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static GPT3Model findByValue(String value) {
        return Arrays.stream(GPT3Model.values()).filter(model -> model.getValue().equalsIgnoreCase(value)).findFirst().orElse(null);
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public double getPrice() {
        return this.price;
    }

    private GPT3Model(String value, double price) {
        this.value = value;
        this.price = price;
    }
}

