/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.openai.domain.model.gpt;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.struchkov.openai.domain.model.gpt.GPTModel;
import java.util.Arrays;

public enum GPT4Model implements GPTModel
{
    GPT_4("gpt-4", 3.0E-5, 6.0E-5),
    GPT_4_0314("gpt-4-0314", 3.0E-5, 6.0E-5),
    GPT_4_32_K("gpt-4-32k", 6.0E-5, 1.2E-4),
    GPT_4_32_K_0314("gpt-4-32k-0314", 6.0E-5, 1.2E-4);

    private final String value;
    private final double requestPrice;
    private final double responsePrice;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static GPT4Model findByValue(String value) {
        return Arrays.stream(GPT4Model.values()).filter(model -> model.getValue().equalsIgnoreCase(value)).findFirst().orElse(null);
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    @Override
    public double getPrice() {
        return 0.0;
    }

    private GPT4Model(String value, double requestPrice, double responsePrice) {
        this.value = value;
        this.requestPrice = requestPrice;
        this.responsePrice = responsePrice;
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

