/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.openai.domain.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.struchkov.openai.domain.common.GptMessage;
import dev.struchkov.openai.domain.model.gpt.GPTModel;
import dev.struchkov.openai.domain.request.format.ResponseFormat;
import dev.struchkov.openai.domain.request.picture.PictureSize;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GptRequest {
    private GPTModel model;
    private Double temperature;
    private List<GptMessage> messages;
    @JsonProperty(value="top_p")
    private Double topP;
    private Integer n;
    private Boolean stream;
    private List<String> stop;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="logit_bias")
    private Map<Long, Long> logitBias;
    private String user;
    private String prompt;
    private PictureSize size;
    @JsonProperty(value="response_format")
    private ResponseFormat responseFormat;

    public static GptRequestBuilder builder() {
        return new GptRequestBuilder();
    }

    public GPTModel getModel() {
        return this.model;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public List<GptMessage> getMessages() {
        return this.messages;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map<Long, Long> getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public PictureSize getSize() {
        return this.size;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setModel(GPTModel model) {
        this.model = model;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public void setMessages(List<GptMessage> messages) {
        this.messages = messages;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="logit_bias")
    public void setLogitBias(Map<Long, Long> logitBias) {
        this.logitBias = logitBias;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public void setSize(PictureSize size) {
        this.size = size;
    }

    @JsonProperty(value="response_format")
    public void setResponseFormat(ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public String toString() {
        return "GptRequest(model=" + this.getModel() + ", temperature=" + this.getTemperature() + ", messages=" + this.getMessages() + ", topP=" + this.getTopP() + ", n=" + this.getN() + ", stream=" + this.getStream() + ", stop=" + this.getStop() + ", presencePenalty=" + this.getPresencePenalty() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ", prompt=" + this.getPrompt() + ", size=" + this.getSize() + ", responseFormat=" + this.getResponseFormat() + ")";
    }

    public GptRequest() {
    }

    private GptRequest(GPTModel model, Double temperature, List<GptMessage> messages, Double topP, Integer n, Boolean stream, List<String> stop, Double presencePenalty, Double frequencyPenalty, Map<Long, Long> logitBias, String user, String prompt, PictureSize size, ResponseFormat responseFormat) {
        this.model = model;
        this.temperature = temperature;
        this.messages = messages;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.user = user;
        this.prompt = prompt;
        this.size = size;
        this.responseFormat = responseFormat;
    }

    public static class GptRequestBuilder {
        private GPTModel model;
        private Double temperature;
        private List<GptMessage> messages;
        private Double topP;
        private Integer n;
        private Boolean stream;
        private List<String> stop;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Map<Long, Long> logitBias;
        private String user;
        private String prompt;
        private PictureSize size;
        private ResponseFormat responseFormat;

        GptRequestBuilder() {
        }

        public GptRequestBuilder model(GPTModel model) {
            this.model = model;
            return this;
        }

        public GptRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public GptRequestBuilder messages(List<GptMessage> messages) {
            this.messages = messages;
            return this;
        }

        @JsonProperty(value="top_p")
        public GptRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public GptRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public GptRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public GptRequestBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public GptRequestBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public GptRequestBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public GptRequestBuilder logitBias(Map<Long, Long> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public GptRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public GptRequestBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public GptRequestBuilder size(PictureSize size) {
            this.size = size;
            return this;
        }

        @JsonProperty(value="response_format")
        public GptRequestBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public GptRequest build() {
            return new GptRequest(this.model, this.temperature, this.messages, this.topP, this.n, this.stream, this.stop, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.user, this.prompt, this.size, this.responseFormat);
        }

        public String toString() {
            return "GptRequest.GptRequestBuilder(model=" + this.model + ", temperature=" + this.temperature + ", messages=" + this.messages + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", stop=" + this.stop + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", user=" + this.user + ", prompt=" + this.prompt + ", size=" + this.size + ", responseFormat=" + this.responseFormat + ")";
        }
    }
}

