/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.openai.domain.request.audio;

import dev.struchkov.openai.domain.model.gpt.Whisper;
import dev.struchkov.openai.domain.request.format.impl.VoiceResponseFormat;

public class VoiceToTextRequest {
    private String file;
    private Whisper model;
    private String prompt;
    private VoiceResponseFormat responseFormat;
    private Double temperature;
    private String language;

    VoiceToTextRequest(String file, Whisper model, String prompt, VoiceResponseFormat responseFormat, Double temperature, String language) {
        this.file = file;
        this.model = model;
        this.prompt = prompt;
        this.responseFormat = responseFormat;
        this.temperature = temperature;
        this.language = language;
    }

    public static VoiceToTextRequestBuilder builder() {
        return new VoiceToTextRequestBuilder();
    }

    public String getFile() {
        return this.file;
    }

    public Whisper getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public VoiceResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public String getLanguage() {
        return this.language;
    }

    public static class VoiceToTextRequestBuilder {
        private String file;
        private Whisper model;
        private String prompt;
        private VoiceResponseFormat responseFormat;
        private Double temperature;
        private String language;

        VoiceToTextRequestBuilder() {
        }

        public VoiceToTextRequestBuilder file(String file) {
            this.file = file;
            return this;
        }

        public VoiceToTextRequestBuilder model(Whisper model) {
            this.model = model;
            return this;
        }

        public VoiceToTextRequestBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public VoiceToTextRequestBuilder responseFormat(VoiceResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public VoiceToTextRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public VoiceToTextRequestBuilder language(String language) {
            this.language = language;
            return this;
        }

        public VoiceToTextRequest build() {
            return new VoiceToTextRequest(this.file, this.model, this.prompt, this.responseFormat, this.temperature, this.language);
        }

        public String toString() {
            return "VoiceToTextRequest.VoiceToTextRequestBuilder(file=" + this.file + ", model=" + this.model + ", prompt=" + this.prompt + ", responseFormat=" + this.responseFormat + ", temperature=" + this.temperature + ", language=" + this.language + ")";
        }
    }
}

