/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.openai.domain.request.picture;

import dev.struchkov.openai.domain.request.format.impl.PictureResponseFormat;
import dev.struchkov.openai.domain.request.picture.PictureSize;
import lombok.NonNull;

public class PictureRequest {
    @NonNull
    private String description;
    private Integer numberOfImages;
    private PictureSize size;
    private PictureResponseFormat pictureResponseFormat;
    private String user;

    PictureRequest(@NonNull String description, Integer numberOfImages, PictureSize size, PictureResponseFormat pictureResponseFormat, String user) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
        this.numberOfImages = numberOfImages;
        this.size = size;
        this.pictureResponseFormat = pictureResponseFormat;
        this.user = user;
    }

    public static PictureRequestBuilder builder() {
        return new PictureRequestBuilder();
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    public Integer getNumberOfImages() {
        return this.numberOfImages;
    }

    public PictureSize getSize() {
        return this.size;
    }

    public PictureResponseFormat getPictureResponseFormat() {
        return this.pictureResponseFormat;
    }

    public String getUser() {
        return this.user;
    }

    public static class PictureRequestBuilder {
        private String description;
        private Integer numberOfImages;
        private PictureSize size;
        private PictureResponseFormat pictureResponseFormat;
        private String user;

        PictureRequestBuilder() {
        }

        public PictureRequestBuilder description(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return this;
        }

        public PictureRequestBuilder numberOfImages(Integer numberOfImages) {
            this.numberOfImages = numberOfImages;
            return this;
        }

        public PictureRequestBuilder size(PictureSize size) {
            this.size = size;
            return this;
        }

        public PictureRequestBuilder pictureResponseFormat(PictureResponseFormat pictureResponseFormat) {
            this.pictureResponseFormat = pictureResponseFormat;
            return this;
        }

        public PictureRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public PictureRequest build() {
            return new PictureRequest(this.description, this.numberOfImages, this.size, this.pictureResponseFormat, this.user);
        }

        public String toString() {
            return "PictureRequest.PictureRequestBuilder(description=" + this.description + ", numberOfImages=" + this.numberOfImages + ", size=" + this.size + ", pictureResponseFormat=" + this.pictureResponseFormat + ", user=" + this.user + ")";
        }
    }
}

