/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.openai;

import dev.struchkov.haiti.utils.Checker;
import dev.struchkov.openai.context.ChatGptService;
import dev.struchkov.openai.context.GPTClient;
import dev.struchkov.openai.context.data.ChatGptStorage;
import dev.struchkov.openai.domain.chat.ChatInfo;
import dev.struchkov.openai.domain.chat.ChatMessage;
import dev.struchkov.openai.domain.chat.CreateChat;
import dev.struchkov.openai.domain.common.GptMessage;
import dev.struchkov.openai.domain.message.AnswerChatMessage;
import dev.struchkov.openai.domain.model.gpt.GPT3Model;
import dev.struchkov.openai.domain.model.gpt.GPTModel;
import dev.struchkov.openai.domain.request.GptRequest;
import dev.struchkov.openai.domain.response.Choice;
import dev.struchkov.openai.domain.response.GptResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class ChatGptServiceImpl
implements ChatGptService {
    private final GPTClient gptClient;
    private final ChatGptStorage chatStorage;

    public ChatInfo createChat(CreateChat createChat) {
        return this.chatStorage.save(ChatInfo.builder().contextConstraint(createChat.getContextConstraint()).systemBehavior(createChat.getSystemBehavior()).build());
    }

    public ChatInfo updateChat(ChatInfo updateChat) {
        ChatInfo oldChatInfo = (ChatInfo)this.chatStorage.findChatInfoById(updateChat.getChatId()).orElseThrow();
        oldChatInfo.setSystemBehavior(updateChat.getSystemBehavior());
        oldChatInfo.setContextConstraint(updateChat.getContextConstraint());
        return this.chatStorage.save(oldChatInfo);
    }

    public AnswerChatMessage sendNewMessage(@NonNull UUID chatId, @NonNull String message) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        ChatInfo chatInfo = (ChatInfo)this.chatStorage.findChatInfoById(chatId).orElseThrow();
        List<GptMessage> gptMessageHistory = this.generateGptMessages(chatInfo, message);
        ArrayList<GptMessage> gptMessages = new ArrayList<GptMessage>(gptMessageHistory.size() + 1);
        if (Checker.checkNotBlank((String)chatInfo.getSystemBehavior())) {
            gptMessages.add(GptMessage.fromSystem((String)chatInfo.getSystemBehavior()));
        }
        gptMessages.addAll(gptMessageHistory);
        GptResponse gptResponse = this.gptClient.execute(GptRequest.builder().messages(gptMessages).model((GPTModel)GPT3Model.GPT_3_5_TURBO).build());
        List choices = gptResponse.getChoices();
        GptMessage answer = ((Choice)choices.get(choices.size() - 1)).getMessage();
        ChatMessage answerMessage = this.convert(chatId, answer);
        return AnswerChatMessage.builder().message(this.chatStorage.save(answerMessage).getMessage()).usage(gptResponse.getUsage()).build();
    }

    public CompletableFuture<AnswerChatMessage> sendNewMessageAsync(@NonNull UUID chatId, @NonNull String message) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        ChatInfo chatInfo = (ChatInfo)this.chatStorage.findChatInfoById(chatId).orElseThrow();
        List<GptMessage> gptMessageHistory = this.generateGptMessages(chatInfo, message);
        ArrayList<GptMessage> gptMessages = new ArrayList<GptMessage>(gptMessageHistory.size() + 1);
        if (Checker.checkNotBlank((String)chatInfo.getSystemBehavior())) {
            gptMessages.add(GptMessage.fromSystem((String)chatInfo.getSystemBehavior()));
        }
        gptMessages.addAll(gptMessageHistory);
        return this.gptClient.executeAsync(GptRequest.builder().messages(gptMessages).model((GPTModel)GPT3Model.GPT_3_5_TURBO).build()).thenApply(gptResponse -> {
            List choices = gptResponse.getChoices();
            GptMessage answer = ((Choice)choices.get(choices.size() - 1)).getMessage();
            ChatMessage answerMessage = this.convert(chatId, answer);
            return AnswerChatMessage.builder().message(this.chatStorage.save(answerMessage).getMessage()).usage(gptResponse.getUsage()).build();
        });
    }

    public void clearContext(@NonNull UUID chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatStorage.removeAllMessages(chatId);
    }

    public void closeChat(@NonNull UUID chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatStorage.remove(chatId);
    }

    public long getCountMessages(@NonNull UUID chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        return this.chatStorage.countMessagesByChatId(chatId);
    }

    private List<GptMessage> generateGptMessages(@NotNull ChatInfo chatInfo, @NotNull String message) {
        ChatMessage chatMessage = ChatMessage.builder().chatId(chatInfo.getChatId()).role("user").message(message).build();
        this.chatStorage.save(chatMessage);
        List historyMessages = this.chatStorage.findAllMessage(chatInfo.getChatId());
        Long contextConstraint = chatInfo.getContextConstraint();
        if (Checker.checkNotNull((Object)contextConstraint) && (long)historyMessages.size() > contextConstraint) {
            long delta = (long)historyMessages.size() - contextConstraint;
            int i = 0;
            while ((long)i < delta) {
                this.chatStorage.removeMessage(chatInfo.getChatId(), ((ChatMessage)historyMessages.get(i)).getMessageId());
                ++i;
            }
        }
        return historyMessages.stream().map(ChatGptServiceImpl::convert).toList();
    }

    private ChatMessage convert(UUID chatId, GptMessage answer) {
        return ChatMessage.builder().chatId(chatId).role(answer.getRole()).message(answer.getContent()).build();
    }

    private static GptMessage convert(ChatMessage mes) {
        return GptMessage.builder().role(mes.getRole()).content(mes.getMessage()).build();
    }

    public ChatGptServiceImpl(GPTClient gptClient, ChatGptStorage chatStorage) {
        this.gptClient = gptClient;
        this.chatStorage = chatStorage;
    }
}

