/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.struchkov.haiti.utils.Checker;
import dev.struchkov.openai.context.GPTClient;
import dev.struchkov.openai.domain.conf.GPTConfig;
import dev.struchkov.openai.domain.request.GptRequest;
import dev.struchkov.openai.domain.response.GptResponse;
import dev.struchkov.openai.domain.response.error.GptErrorDetail;
import dev.struchkov.openai.domain.response.error.GptErrorResponse;
import dev.struchkov.openai.exception.gpt.OpenAIGptApiException;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPTClientImpl
implements GPTClient {
    private static final Logger log = LoggerFactory.getLogger(GPTClientImpl.class);
    private static final MediaType MEDIA_TYPE_APPLICATION_JSON = MediaType.parse((String)"application/json");
    private final ObjectMapper mapper;
    private final OkHttpClient okHttpClient;
    private final GPTConfig gptConfig;

    public GPTClientImpl(GPTConfig gptConfig) {
        this.mapper = new ObjectMapper();
        this.gptConfig = gptConfig;
        Duration timeout = Duration.ofMinutes(1L);
        this.okHttpClient = new OkHttpClient.Builder().callTimeout(timeout).writeTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).build();
    }

    public GPTClientImpl(ObjectMapper mapper, OkHttpClient okHttpClient, GPTConfig gptConfig) {
        this.mapper = mapper;
        this.okHttpClient = okHttpClient;
        this.gptConfig = gptConfig;
    }

    public CompletableFuture<GptResponse> executeAsync(@NonNull GptRequest gptRequest) {
        if (gptRequest == null) {
            throw new NullPointerException("gptRequest is marked non-null but is null");
        }
        final CompletableFuture<GptResponse> future = new CompletableFuture<GptResponse>();
        Request request = this.generateRequest(gptRequest);
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                String responseJson = response.body().string();
                if (response.isSuccessful()) {
                    future.complete((GptResponse)GPTClientImpl.this.mapper.readValue(responseJson, GptResponse.class));
                } else {
                    GptErrorResponse errorResponse = (GptErrorResponse)GPTClientImpl.this.mapper.readValue(responseJson, GptErrorResponse.class);
                    GptErrorDetail errorDetail = errorResponse.getError();
                    future.completeExceptionally((Throwable)new OpenAIGptApiException(errorDetail.getMessage(), errorDetail.getType(), errorDetail.getParam(), errorDetail.getCode()));
                }
            }
        });
        return future;
    }

    public GptResponse execute(@NonNull GptRequest gptRequest) {
        if (gptRequest == null) {
            throw new NullPointerException("gptRequest is marked non-null but is null");
        }
        try {
            Request request = this.generateRequest(gptRequest);
            Response response = this.okHttpClient.newCall(request).execute();
            String responseJson = response.body().string();
            if (response.isSuccessful()) {
                return (GptResponse)this.mapper.readValue(responseJson, GptResponse.class);
            }
            GptErrorResponse errorResponse = (GptErrorResponse)this.mapper.readValue(responseJson, GptErrorResponse.class);
            GptErrorDetail errorDetail = errorResponse.getError();
            throw new OpenAIGptApiException(errorDetail.getMessage(), errorDetail.getType(), errorDetail.getParam(), errorDetail.getCode());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException();
        }
    }

    @NotNull
    private Request generateRequest(@NotNull GptRequest gptRequest) {
        RequestBody body = RequestBody.create((MediaType)MEDIA_TYPE_APPLICATION_JSON, (String)this.mapper.writeValueAsString((Object)gptRequest));
        Request.Builder requestBuilder = new Request.Builder().url(this.gptConfig.getUrl() + "/v1/chat/completions").header("Authorization", "Bearer " + this.gptConfig.getToken()).post(body);
        String openAiOrg = this.gptConfig.getOrganisation();
        if (Checker.checkNotBlank((String)openAiOrg)) {
            requestBuilder.header("OpenAI-Organization", openAiOrg);
        }
        return requestBuilder.build();
    }
}

