/*
 * Decompiled with CFR 0.152.
 */
package dev.struchkov.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.struchkov.openai.context.OpenAIClient;
import dev.struchkov.openai.domain.conf.GPTConfig;
import dev.struchkov.openai.domain.response.account.TotalUsageResponse;
import dev.struchkov.openai.domain.response.error.GptErrorDetail;
import dev.struchkov.openai.domain.response.error.GptErrorResponse;
import dev.struchkov.openai.exception.OpenAIApiException;
import java.io.IOException;
import java.time.LocalDate;
import java.time.YearMonth;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIClientImpl
implements OpenAIClient {
    private static final Logger log = LoggerFactory.getLogger(OpenAIClientImpl.class);
    private final ObjectMapper mapper;
    private final OkHttpClient okHttpClient;
    private final GPTConfig gptConfig;

    public OpenAIClientImpl(GPTConfig gptConfig) {
        this.mapper = new ObjectMapper();
        this.gptConfig = gptConfig;
        this.okHttpClient = new OkHttpClient();
    }

    public TotalUsageResponse getTotalUsageInThisMount() {
        LocalDate today = LocalDate.now();
        LocalDate firstDayOfCurrentMonth = today.withDayOfMonth(1);
        YearMonth currentMonth = YearMonth.from(today);
        YearMonth nextMonth = currentMonth.plusMonths(1L);
        LocalDate firstDayOfNextMonth = nextMonth.atDay(1);
        Request request = this.generateRequestBuilder(this.generateHttpUrlBuilder().addQueryParameter("start_date", firstDayOfCurrentMonth.toString()).addQueryParameter("end_date", firstDayOfNextMonth.toString()).build()).get().build();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            String responseJson = response.body().string();
            if (response.isSuccessful()) {
                return (TotalUsageResponse)this.mapper.readValue(responseJson, TotalUsageResponse.class);
            }
            GptErrorResponse errorResponse = (GptErrorResponse)this.mapper.readValue(responseJson, GptErrorResponse.class);
            GptErrorDetail errorDetail = errorResponse.getError();
            throw new OpenAIApiException(errorDetail.getMessage(), new Object[]{errorDetail.getType(), errorDetail.getParam(), errorDetail.getCode()});
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    private Request.Builder generateRequestBuilder(HttpUrl httpUrl) {
        return new Request.Builder().url(httpUrl).header("Authorization", "Bearer " + this.gptConfig.getToken());
    }

    private HttpUrl.Builder generateHttpUrlBuilder() {
        return new HttpUrl.Builder().scheme("https").host("api.openai.com").addEncodedPathSegment("dashboard").addEncodedPathSegment("billing").addEncodedPathSegment("usage");
    }

    public OpenAIClientImpl(ObjectMapper mapper, OkHttpClient okHttpClient, GPTConfig gptConfig) {
        this.mapper = mapper;
        this.okHttpClient = okHttpClient;
        this.gptConfig = gptConfig;
    }
}

