/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.choam.async;

import cats.effect.std.Queue;
import dev.tauri.choam.async.AsyncQueueSource;
import dev.tauri.choam.async.AsyncReactive;
import dev.tauri.choam.async.BoundedQueue$;
import dev.tauri.choam.async.BoundedQueueSink;
import dev.tauri.choam.async.GenWaitList;
import dev.tauri.choam.core.Reactive;
import dev.tauri.choam.core.Rxn;
import dev.tauri.choam.data.Queue;
import dev.tauri.choam.data.QueueSourceSink;
import dev.tauri.choam.refs.Ref;
import scala.Option;

public abstract class BoundedQueue<F, A>
implements AsyncQueueSource<F, A>,
BoundedQueueSink<F, A>,
QueueSourceSink<A> {
    public static <F, A> Rxn<Object, BoundedQueue<F, A>> array(int n, AsyncReactive<F> asyncReactive) {
        return BoundedQueue$.MODULE$.array(n, asyncReactive);
    }

    public static <F, A> Rxn<Object, BoundedQueue<F, A>> linked(int n, AsyncReactive<F> asyncReactive) {
        return BoundedQueue$.MODULE$.linked(n, asyncReactive);
    }

    public abstract int bound();

    public abstract Queue<F, A> toCats();

    public abstract Rxn<Object, Object> size();

    public static final class ArrayBoundedQueue<F, A>
    extends BoundedQueue<F, A> {
        private final int _bound;
        private final Queue.WithSize<A> q;
        private final GenWaitList<F, A> gwl;
        private final AsyncReactive<F> F;

        public ArrayBoundedQueue(int _bound, Queue.WithSize<A> q, GenWaitList<F, A> gwl, AsyncReactive<F> F) {
            this._bound = _bound;
            this.q = q;
            this.gwl = gwl;
            this.F = F;
        }

        public Rxn<Object, Option<A>> tryDeque() {
            return this.gwl.tryGet();
        }

        @Override
        public <AA> F deque() {
            return (F)this.F.monad().widen(this.gwl.asyncGet());
        }

        public Rxn<A, Object> tryEnqueue() {
            return this.gwl.trySet();
        }

        @Override
        public F enqueue(A a) {
            return this.gwl.asyncSet(a);
        }

        @Override
        public int bound() {
            return this._bound;
        }

        @Override
        public Queue<F, A> toCats() {
            return new CatsQueueFromBoundedQueue(this, this.F);
        }

        @Override
        public Rxn<Object, Object> size() {
            return this.q.size();
        }
    }

    public static final class CatsQueueFromBoundedQueue<F, A>
    extends Queue<F, A> {
        private final BoundedQueue<F, A> self;
        private final Reactive<F> F;

        public CatsQueueFromBoundedQueue(BoundedQueue<F, A> self, Reactive<F> F) {
            this.self = self;
            this.F = F;
        }

        public final F take() {
            return this.self.deque();
        }

        public final F tryTake() {
            return (F)this.F.run(this.self.tryDeque(), this.F.run$default$2());
        }

        public final F size() {
            return (F)this.F.run(this.self.size(), this.F.run$default$2());
        }

        public final F offer(A a) {
            return (F)this.self.enqueue(a);
        }

        public final F tryOffer(A a) {
            return (F)this.F.apply(this.self.tryEnqueue(), a, this.F.apply$default$3());
        }
    }

    public static final class LinkedBoundedQueue<F, A>
    extends BoundedQueue<F, A> {
        private final int _bound;
        private final Ref<Object> s;
        private final GenWaitList<F, A> gwl;
        private final AsyncReactive<F> F;

        public LinkedBoundedQueue(int _bound, Ref<Object> s, GenWaitList<F, A> gwl, AsyncReactive<F> F) {
            this._bound = _bound;
            this.s = s;
            this.gwl = gwl;
            this.F = F;
        }

        public Rxn<Object, Option<A>> tryDeque() {
            return this.gwl.tryGet();
        }

        @Override
        public <AA> F deque() {
            return (F)this.F.monad().widen(this.gwl.asyncGet());
        }

        public Rxn<A, Object> tryEnqueue() {
            return this.gwl.trySet();
        }

        @Override
        public F enqueue(A a) {
            return this.gwl.asyncSet(a);
        }

        @Override
        public int bound() {
            return this._bound;
        }

        @Override
        public Queue<F, A> toCats() {
            return new CatsQueueFromBoundedQueue(this, this.F);
        }

        @Override
        public Rxn<Object, Object> size() {
            return this.s.get();
        }
    }
}

