/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.choam.async;

import cats.effect.std.Queue;
import dev.tauri.choam.async.AsyncQueue;
import dev.tauri.choam.async.AsyncReactive;
import dev.tauri.choam.async.GenWaitList;
import dev.tauri.choam.async.OverflowQueue$;
import dev.tauri.choam.async.UnboundedQueue;
import dev.tauri.choam.async.WaitList;
import dev.tauri.choam.core.Rxn;
import dev.tauri.choam.data.Queue;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class OverflowQueue<F, A>
extends UnboundedQueue.WithSize<F, A> {
    public static <F, A> Rxn<Object, OverflowQueue<F, A>> droppingQueue(int n, AsyncReactive<F> asyncReactive) {
        return OverflowQueue$.MODULE$.droppingQueue(n, asyncReactive);
    }

    public static <F, A> Rxn<Object, OverflowQueue<F, A>> lazyRingBuffer(int n, AsyncReactive<F> asyncReactive) {
        return OverflowQueue$.MODULE$.lazyRingBuffer(n, asyncReactive);
    }

    public static <F, A> Rxn<Object, OverflowQueue<F, A>> ringBuffer(int n, AsyncReactive<F> asyncReactive) {
        return OverflowQueue$.MODULE$.ringBuffer(n, asyncReactive);
    }

    public abstract int capacity();

    public static final class DroppingQueue<F, A>
    extends OverflowQueue<F, A> {
        private final int capacity;
        private final Queue.WithSize<A> q;
        private final GenWaitList<F, A> gwl;
        private final AsyncReactive<F> F;

        public DroppingQueue(int capacity, Queue.WithSize<A> q, GenWaitList<F, A> gwl, AsyncReactive<F> F) {
            this.capacity = capacity;
            this.q = q;
            this.gwl = gwl;
            this.F = F;
        }

        @Override
        public final int capacity() {
            return this.capacity;
        }

        @Override
        public final F size() {
            return (F)this.F.run(this.q.size(), this.F.run$default$2());
        }

        @Override
        public final Queue<F, A> toCats() {
            return new AsyncQueue.CatsQueueAdapter(this, this.F);
        }

        public final Rxn<A, Object> tryEnqueue() {
            return this.gwl.trySet();
        }

        public final Rxn<A, BoxedUnit> enqueue() {
            return this.tryEnqueue().void();
        }

        public final Rxn<Object, Option<A>> tryDeque() {
            return this.gwl.tryGet();
        }

        @Override
        public final <AA> F deque() {
            return (F)this.F.monad().widen(this.gwl.asyncGet());
        }
    }

    public static final class RingBuffer<F, A>
    extends OverflowQueue<F, A> {
        private final int capacity;
        private final Queue.WithSize<A> buff;
        private final WaitList<F, A> wl;
        private final AsyncReactive<F> F;

        public RingBuffer(int capacity, Queue.WithSize<A> buff, WaitList<F, A> wl, AsyncReactive<F> F) {
            this.capacity = capacity;
            this.buff = buff;
            this.wl = wl;
            this.F = F;
        }

        @Override
        public final int capacity() {
            return this.capacity;
        }

        @Override
        public final F size() {
            return (F)this.F.run(this.buff.size(), this.F.run$default$2());
        }

        @Override
        public final Queue<F, A> toCats() {
            return new AsyncQueue.CatsQueueAdapter(this, this.F);
        }

        public final Rxn<A, Object> tryEnqueue() {
            return this.enqueue().as((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }

        public final Rxn<A, BoxedUnit> enqueue() {
            return this.wl.set();
        }

        public final Rxn<Object, Option<A>> tryDeque() {
            return this.wl.tryGet();
        }

        @Override
        public final <AA> F deque() {
            return (F)this.F.monad().widen(this.wl.asyncGet());
        }
    }
}

