/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.choam.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.util.Collections;

public final class VarHandleHelper {
    private static final MethodHandle WITH_INVOKE_EXACT_BEHAVIOR = VarHandleHelper.findHandle();

    private static final MethodHandle findHandle() {
        MethodHandles.Lookup l = MethodHandles.lookup();
        try {
            return l.findVirtual(VarHandle.class, "withInvokeExactBehavior", MethodType.methodType(VarHandle.class, Collections.emptyList()));
        }
        catch (NoSuchMethodException e) {
            try {
                return l.findStatic(VarHandleHelper.class, "noopFallback", MethodType.methodType(VarHandle.class, new Class[]{VarHandle.class}));
            }
            catch (ReflectiveOperationException e2) {
                ExceptionInInitializerError ex = new ExceptionInInitializerError(e2);
                ex.addSuppressed(e);
                throw ex;
            }
        }
        catch (IllegalAccessException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final VarHandle noopFallback(VarHandle vh) {
        return vh;
    }

    public static final VarHandle withInvokeExactBehavior(VarHandle vh) {
        try {
            return WITH_INVOKE_EXACT_BEHAVIOR.invokeExact(vh);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
    }

    private VarHandleHelper() {
    }
}

