/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.choam.internal.skiplist;

import cats.kernel.Order;
import dev.tauri.choam.internal.skiplist.package$;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function2;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapFactoryDefaults;
import scala.collection.MapOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Cloneable;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Shrinkable;
import scala.runtime.BoxedUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SkipListMap<K, V>
implements scala.collection.concurrent.Map<K, V> {
    private final Order<K> K;
    private final AtomicReference<Index> _head;
    private final Object _marker;
    private final Object _tomb;

    public SkipListMap(Order<K> K) {
        this.K = K;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        scala.collection.mutable.Iterable.$init$((scala.collection.mutable.Iterable)this);
        PartialFunction.$init$((PartialFunction)this);
        MapOps.$init$((MapOps)this);
        MapFactoryDefaults.$init$((MapFactoryDefaults)this);
        Map.$init$((Map)this);
        Cloneable.$init$((Cloneable)this);
        Growable.$init$((Growable)this);
        Builder.$init$((Builder)this);
        Shrinkable.$init$((Shrinkable)this);
        scala.collection.mutable.MapOps.$init$((scala.collection.mutable.MapOps)this);
        scala.collection.mutable.Map.$init$((scala.collection.mutable.Map)this);
        scala.collection.concurrent.Map.$init$((scala.collection.concurrent.Map)this);
        this._head = new AtomicReference();
        this._marker = new Object();
        this._tomb = new Object();
    }

    public Object scala$collection$mutable$Cloneable$$super$clone() {
        return super.clone();
    }

    private final K MARKER() {
        return (K)this._marker;
    }

    public final boolean dev$tauri$choam$internal$skiplist$SkipListMap$$isMARKER(K k) {
        return package$.MODULE$.equ(k, this.MARKER());
    }

    public final V dev$tauri$choam$internal$skiplist$SkipListMap$$TOMB() {
        return (V)this._tomb;
    }

    public final boolean dev$tauri$choam$internal$skiplist$SkipListMap$$isTOMB(V v) {
        return package$.MODULE$.equ(v, this.dev$tauri$choam$internal$skiplist$SkipListMap$$TOMB());
    }

    public final Option<V> put(K key, V value) {
        return this.doPut(key, value, false, ThreadLocalRandom.current());
    }

    public final Option<V> putIfAbsent(K key, V value) {
        return this.doPut(key, value, true, ThreadLocalRandom.current());
    }

    public final Option<V> get(K key) {
        return this.doGet(key);
    }

    public final boolean del(K key) {
        return this.doRemove(key, this.dev$tauri$choam$internal$skiplist$SkipListMap$$TOMB());
    }

    public final boolean remove(K key, V value) {
        return this.doRemove(key, value);
    }

    public final boolean replace(K key, V ov, V nv) {
        return this.doReplace(key, ov, nv);
    }

    public final Iterator<Tuple2<K, V>> iterator() {
        return new Iterator<Tuple2<K, V>>(this){
            private Node nextNode;
            private Object nextValue;
            private final /* synthetic */ SkipListMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.nextNode = null;
                this.nextValue = $outer.dev$tauri$choam$internal$skiplist$SkipListMap$$TOMB();
                this.advance($outer.dev$tauri$choam$internal$skiplist$SkipListMap$$baseHead());
            }

            public final boolean hasNext() {
                return this.nextNode != null;
            }

            public final Tuple2 next() {
                Node n = this.nextNode;
                if (n == null) {
                    throw new NoSuchElementException();
                }
                K k = n.key();
                Object v = this.nextValue;
                this.advance(n);
                return Tuple2$.MODULE$.apply(k, v);
            }

            private final void advance(Node _b) {
                Node b = _b;
                if (b != null) {
                    while (true) {
                        Node n = b.getNext();
                        if (n != null) {
                            V v = n.getValue();
                            if (!this.$outer.dev$tauri$choam$internal$skiplist$SkipListMap$$isTOMB(v)) {
                                this.nextValue = v;
                                this.nextNode = n;
                                return;
                            }
                            b = n;
                            continue;
                        }
                        this.nextValue = this.$outer.dev$tauri$choam$internal$skiplist$SkipListMap$$TOMB();
                        this.nextNode = null;
                        return;
                    }
                    return;
                }
            }
        };
    }

    public final SkipListMap addOne(Tuple2<K, V> elem) {
        this.put(elem._1(), elem._2());
        return this;
    }

    public final SkipListMap subtractOne(K elem) {
        this.del(elem);
        return this;
    }

    public final Option<V> replace(K k, V v) {
        throw new NotImplementedError("SkipListMap#replace(K,V)");
    }

    public final void foreach(Function2<K, V, BoxedUnit> cb) {
        this.doForeach(cb);
    }

    public final String toString() {
        Node node = this.peekFirstNode();
        if (node == null) {
            return "SkipListMap()";
        }
        return "SkipListMap(...)";
    }

    private final int cpr(K x, K y) {
        return this.K.compare(x, y);
    }

    private final Option<V> doPut(K key, V value, boolean onlyIfAbsent, ThreadLocalRandom tlr) {
        Node z;
        int levels;
        Index h;
        while (true) {
            Node b;
            Node node;
            h = this._head.getAcquire();
            levels = 0;
            if (h == null) {
                Node base = new Node(this, this.MARKER(), this.dev$tauri$choam$internal$skiplist$SkipListMap$$TOMB(), null);
                Index h2 = new Index(base, null, null);
                node = this._head.compareAndSet(null, h2) ? base : null;
            } else {
                Index q = h;
                Node foundBase = null;
                while (foundBase == null) {
                    Index d = (q = this.walkRight(q, key)).down();
                    if (d != null) {
                        ++levels;
                        q = d;
                        continue;
                    }
                    foundBase = q.node();
                }
                node = foundBase;
            }
            if ((b = node) == null) continue;
            z = null;
            Node n = null;
            boolean go = true;
            while (go) {
                Node p;
                int c = 0;
                n = b.getNext();
                if (n == null) {
                    c = -1;
                } else if (n.isMarker()) {
                    go = false;
                } else {
                    Object v = n.getValue();
                    if (this.dev$tauri$choam$internal$skiplist$SkipListMap$$isTOMB(v)) {
                        this.unlinkNode(b, n);
                        c = 1;
                    } else {
                        c = this.cpr(key, n.key());
                        if (c > 0) {
                            b = n;
                        } else if (c == 0 && (onlyIfAbsent || n.casValue(v, value))) {
                            return Some$.MODULE$.apply(v);
                        }
                    }
                }
                if (c >= 0 || !b.casNext(n, p = new Node(this, key, value, n))) continue;
                z = p;
                go = false;
            }
            if (z != null) break;
        }
        long rnd = tlr.nextLong();
        if ((rnd & 3L) == 0L) {
            int skips = levels;
            Index x = null;
            boolean go = true;
            while (go) {
                x = new Index(z, x, null);
                if (rnd >= 0L) {
                    go = false;
                    continue;
                }
                if (--skips < 0) {
                    go = false;
                    continue;
                }
                rnd <<= 1;
            }
            if (this.addIndices(h, skips, x) && skips < 0 && this._head.getAcquire() == h) {
                Index hx = new Index(z, x, null);
                Index nh = new Index(h.node(), h, hx);
                this._head.compareAndSet(h, nh);
            }
            if (z.isDeleted()) {
                this.findPredecessor(key);
            }
        }
        return None$.MODULE$;
    }

    private final boolean doReplace(K key, V oldValue, V newValue) {
        while (true) {
            Node n = this.findNode(key);
            if (n == null) {
                return false;
            }
            Object v = n.getValue();
            if (this.dev$tauri$choam$internal$skiplist$SkipListMap$$isTOMB(v)) continue;
            if (!package$.MODULE$.equ(oldValue, v)) {
                return false;
            }
            if (!n.casValue(v, newValue)) continue;
            return true;
        }
        return false;
    }

    private final Option<V> doGet(K key) {
        Index q = this._head.getAcquire();
        if (q != null) {
            while (true) {
                boolean inner = true;
                while (inner) {
                    Index r = q.getRight();
                    if (r != null) {
                        Node p = r.node();
                        Object v = p.getValue();
                        if (p.isMarker() || this.dev$tauri$choam$internal$skiplist$SkipListMap$$isTOMB(v)) {
                            q.casRight(r, r.getRight());
                            continue;
                        }
                        int c = this.cpr(key, p.key());
                        if (c > 0) {
                            q = r;
                            continue;
                        }
                        if (c == 0) {
                            return Some$.MODULE$.apply(v);
                        }
                        inner = false;
                        continue;
                    }
                    inner = false;
                }
                Index d = q.down();
                if (d != null) {
                    q = d;
                    continue;
                }
                Node b = q.node();
                while (true) {
                    Node n = b.getNext();
                    if (n != null) {
                        Object v = n.getValue();
                        if (n.isMarker() || this.dev$tauri$choam$internal$skiplist$SkipListMap$$isTOMB(v)) {
                            b = n;
                            continue;
                        }
                        int c = this.cpr(key, n.key());
                        if (c > 0) {
                            b = n;
                            continue;
                        }
                        if (c == 0) {
                            return Some$.MODULE$.apply(v);
                        }
                        return None$.MODULE$;
                    }
                    return None$.MODULE$;
                }
            }
            return null;
        }
        return None$.MODULE$;
    }

    private final Index walkRight(Index q, K key) {
        Index r;
        while ((r = q.getRight()) != null) {
            Node p = r.node();
            if (p.isMarker() || p.isDeleted()) {
                q.casRight(r, r.getRight());
                continue;
            }
            if (this.cpr(key, p.key()) > 0) {
                q = r;
                continue;
            }
            return q;
        }
        return q;
    }

    private final boolean doRemove(K key, V value) {
        Node b = this.findPredecessor(key);
        while (b != null) {
            boolean inner = true;
            while (inner) {
                Node n = b.getNext();
                if (n == null) {
                    return false;
                }
                if (n.isMarker()) {
                    inner = false;
                    b = this.findPredecessor(key);
                    continue;
                }
                Object ncb = n.getValue();
                if (this.dev$tauri$choam$internal$skiplist$SkipListMap$$isTOMB(ncb)) {
                    this.unlinkNode(b, n);
                    continue;
                }
                int c = this.cpr(key, n.key());
                if (c > 0) {
                    b = n;
                    continue;
                }
                if (c < 0) {
                    return false;
                }
                if (!this.dev$tauri$choam$internal$skiplist$SkipListMap$$isTOMB(value) && !package$.MODULE$.equ(value, ncb)) {
                    return false;
                }
                if (!n.casValue(ncb, this.dev$tauri$choam$internal$skiplist$SkipListMap$$TOMB())) continue;
                this.unlinkNode(b, n);
                this.findPredecessor(key);
                this.tryReduceLevel();
                return true;
            }
        }
        return false;
    }

    private final void doForeach(Function2<K, V, BoxedUnit> cb) {
        for (Node n = this.dev$tauri$choam$internal$skiplist$SkipListMap$$baseHead(); n != null; n = n.getNext()) {
            Object value;
            Object key = n.key();
            if (this.dev$tauri$choam$internal$skiplist$SkipListMap$$isMARKER(key) || this.dev$tauri$choam$internal$skiplist$SkipListMap$$isTOMB(value = n.getValue())) continue;
            cb.apply(key, value);
        }
    }

    public final int size() {
        int count = 0;
        for (Node n = this.dev$tauri$choam$internal$skiplist$SkipListMap$$baseHead(); n != null; n = n.getNext()) {
            Object value;
            Object key = n.key();
            if (this.dev$tauri$choam$internal$skiplist$SkipListMap$$isMARKER(key) || this.dev$tauri$choam$internal$skiplist$SkipListMap$$isTOMB(value = n.getValue())) continue;
            ++count;
        }
        return count;
    }

    private final Node peekFirstNode() {
        Node b = this.dev$tauri$choam$internal$skiplist$SkipListMap$$baseHead();
        if (b != null) {
            Node n = null;
            while ((n = b.getNext()) != null && n.isDeleted()) {
                b = n;
            }
            return n;
        }
        return null;
    }

    public final Node dev$tauri$choam$internal$skiplist$SkipListMap$$baseHead() {
        Index h = this._head.getAcquire();
        if (h != null) {
            return h.node();
        }
        return null;
    }

    private final Node findNode(K key) {
        while (true) {
            Node b = this.findPredecessor(key);
            if (b != null) {
                boolean inner = true;
                while (inner) {
                    Node n = b.getNext();
                    if (n == null) {
                        return null;
                    }
                    Object k = n.key();
                    if (this.dev$tauri$choam$internal$skiplist$SkipListMap$$isMARKER(k)) {
                        inner = false;
                        continue;
                    }
                    Object v = n.getValue();
                    if (this.dev$tauri$choam$internal$skiplist$SkipListMap$$isTOMB(v)) {
                        this.unlinkNode(b, n);
                        continue;
                    }
                    int c = this.cpr(key, k);
                    if (c > 0) {
                        b = n;
                        continue;
                    }
                    if (c == 0) {
                        return n;
                    }
                    return null;
                }
                continue;
            }
            return null;
        }
        return null;
    }

    private final boolean addIndices(Index _q, int _skips, Index x) {
        if (x != null) {
            Index q = _q;
            int skips = _skips;
            Node z = x.node();
            if (z != null && !z.isMarker() && q != null) {
                boolean retrying = false;
                while (true) {
                    Index r = q.getRight();
                    int c = 0;
                    if (r != null) {
                        Node p = r.node();
                        if (p.isMarker() || p.isDeleted()) {
                            q.casRight(r, r.getRight());
                            c = 0;
                        } else {
                            c = this.cpr(z.key(), p.key());
                        }
                        if (c > 0) {
                            q = r;
                        } else if (c == 0) {
                            return false;
                        }
                    } else {
                        c = -1;
                    }
                    if (c >= 0) continue;
                    Index d = q.down();
                    if (d != null && skips > 0) {
                        --skips;
                        q = d;
                        continue;
                    }
                    if (d != null && !retrying && !this.addIndices(d, 0, x.down())) {
                        return false;
                    }
                    x.setRightPlain(r);
                    if (q.casRight(r, x)) {
                        return true;
                    }
                    retrying = true;
                }
            }
        }
        return false;
    }

    private final Node findPredecessor(K key) {
        Index q = this._head.getAcquire();
        if (q == null || this.dev$tauri$choam$internal$skiplist$SkipListMap$$isMARKER(key)) {
            return null;
        }
        while (true) {
            Index d = (q = this.walkRight(q, key)).down();
            if (d != null) {
                q = d;
                continue;
            }
            return q.node();
        }
        return null;
    }

    private final void unlinkNode(Node b, Node n) {
        if (b != null && n != null) {
            Node p = this.mark$1(n);
            b.casNext(n, p);
            return;
        }
    }

    private final void tryReduceLevel() {
        Index lv1 = this._head.getAcquire();
        if (lv1 != null && lv1.getRight() == null) {
            Index lv2 = lv1.down();
            if (lv2 != null && lv2.getRight() == null) {
                Index lv3 = lv2.down();
                if (lv3 != null && lv3.getRight() == null) {
                    if (this._head.compareAndSet(lv1, lv2)) {
                        if (lv1.getRight() != null) {
                            this._head.compareAndSet(lv2, lv1);
                            return;
                        }
                        return;
                    }
                    return;
                }
                return;
            }
            return;
        }
    }

    private final Node mark$1(Node n$1) {
        Node f;
        do {
            if ((f = n$1.getNext()) == null || !f.isMarker()) continue;
            return f.getNext();
        } while (!n$1.casNext(f, new Node(this, this.MARKER(), this.dev$tauri$choam$internal$skiplist$SkipListMap$$TOMB(), f)));
        return f;
    }

    public final class Index
    extends AtomicReference<Index> {
        private final Node node;
        private final Index down;

        public Index(Node node, Index down, Index r) {
            this.node = node;
            this.down = down;
            super(r);
            Predef$.MODULE$.require(node != null);
        }

        public Node node() {
            return this.node;
        }

        public Index down() {
            return this.down;
        }

        public final Index getRight() {
            return (Index)this.getAcquire();
        }

        public final void setRightPlain(Index nv) {
            this.setPlain(nv);
        }

        public final boolean casRight(Index ov, Index nv) {
            return this.compareAndSet(ov, nv);
        }

        @Override
        public final String toString() {
            return "Index(...)";
        }
    }

    public final class Node
    extends AtomicReference<Node> {
        private final Object key;
        private final AtomicReference<V> value;
        private final /* synthetic */ SkipListMap $outer;

        private Node(SkipListMap $outer, K key, AtomicReference<V> value, Node n) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(n);
        }

        public K key() {
            return this.key;
        }

        public Node(SkipListMap $outer, K key, V value, Node next) {
            this($outer, key, (Object)new AtomicReference(value), next);
        }

        public final boolean isMarker() {
            return this.$outer.dev$tauri$choam$internal$skiplist$SkipListMap$$isMARKER(this.key());
        }

        public final boolean isDeleted() {
            return this.$outer.dev$tauri$choam$internal$skiplist$SkipListMap$$isTOMB(this.getValue());
        }

        public final Node getNext() {
            return (Node)this.getAcquire();
        }

        public final boolean casNext(Node ov, Node nv) {
            return this.compareAndSet(ov, nv);
        }

        public final V getValue() {
            return this.value.getAcquire();
        }

        public final boolean casValue(V ov, V nv) {
            return this.value.compareAndSet(ov, nv);
        }

        @Override
        public final String toString() {
            return "Node(...)";
        }

        public final /* synthetic */ SkipListMap dev$tauri$choam$internal$skiplist$SkipListMap$Node$$$outer() {
            return this.$outer;
        }
    }
}

